/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.handler;

import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.provider.AdapterFactoryUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SelectAncestorDialog
extends MessageDialog {
    private Notifier[] notifiers;
    Notifier originNotifier;
    Notifier leftNotifier;
    Notifier rightNotifier;
    private Button[] buttons;
    private final AdapterFactory adapterFactory;
    private SelectionListener selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Button selectedButton = (Button)e.widget;
            if (!selectedButton.getSelection()) {
                return;
            }
            int i = 0;
            while (i < 3) {
                if (selectedButton == SelectAncestorDialog.this.buttons[i]) {
                    SelectAncestorDialog.this.pickOrigin(i);
                }
                ++i;
            }
        }
    };

    public SelectAncestorDialog(Shell parentShell, AdapterFactory adapterFactory, Notifier[] theResources) {
        super(parentShell, CompareMessages.SelectAncestorDialog_title, null, CompareMessages.SelectAncestorDialog_message, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.adapterFactory = adapterFactory;
        this.notifiers = theResources;
    }

    protected Control createCustomArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.buttons = new Button[3];
        int i = 0;
        while (i < 3) {
            this.buttons[i] = new Button(composite, 16);
            this.buttons[i].addSelectionListener(this.selectionListener);
            String text = "'" + AdapterFactoryUtil.getText((AdapterFactory)this.adapterFactory, (Object)this.notifiers[i]) + "'";
            if (this.notifiers[i] instanceof EObject) {
                text = String.valueOf(text) + " (" + EcoreUtil.getURI((EObject)((EObject)this.notifiers[i])) + ")";
            }
            this.buttons[i].setText(text);
            this.buttons[i].setFont(parent.getFont());
            this.buttons[i].setSelection(i == 0);
            ++i;
        }
        this.pickOrigin(0);
        return composite;
    }

    private void pickOrigin(int i) {
        this.originNotifier = this.notifiers[i];
        this.leftNotifier = this.notifiers[i == 0 ? 1 : 0];
        this.rightNotifier = this.notifiers[i == 2 ? 1 : 2];
    }
}

