/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.preferences;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.compare.conflict.IConflictDetector;
import org.eclipse.emf.compare.diff.IDiffEngine;
import org.eclipse.emf.compare.equi.IEquiEngine;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.internal.extension.IItemDescriptor;
import org.eclipse.emf.compare.rcp.internal.extension.IItemRegistry;
import org.eclipse.emf.compare.rcp.internal.extension.impl.ItemUtil;
import org.eclipse.emf.compare.rcp.internal.match.DefaultRCPMatchEngineFactory;
import org.eclipse.emf.compare.rcp.internal.tracer.TracingConstant;
import org.eclipse.emf.compare.rcp.ui.EMFCompareRCPUIPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.EMFCompareRCPUIMessages;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.ui.AbstractConfigurationUI;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.ui.IConfigurationUIFactory;
import org.eclipse.emf.compare.req.IReqEngine;
import org.eclipse.jface.databinding.viewers.IViewerObservableSet;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnginesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private final EngineDescriptorLabelProvider descriptorLabelProvider = new EngineDescriptorLabelProvider();
    private final Map<String, InteractiveUIContent> interactiveUis = new HashMap<String, InteractiveUIContent>();
    private final SingleValueHolder<IDiffEngine> diffEngineData = new SingleValueHolder();
    private final SingleValueHolder<IEquiEngine> equiEngineData = new SingleValueHolder();
    private final SingleValueHolder<IReqEngine> reqEngineData = new SingleValueHolder();
    private final SingleValueHolder<IConflictDetector> conflictsDetectorData = new SingleValueHolder();
    private final MultipleValueHolder<IMatchEngine.Factory> matchEnginesData = new MultipleValueHolder();

    public EnginesPreferencePage() {
    }

    public EnginesPreferencePage(String title) {
        super(title);
    }

    public EnginesPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public void init(IWorkbench workbench) {
        ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.eclipse.emf.compare.rcp");
        this.setPreferenceStore((IPreferenceStore)store);
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout(256));
        TabFolder tabFolder = new TabFolder(container, 0);
        this.createMatchEngineTab(tabFolder);
        this.createDiffEngineTab(tabFolder);
        this.createEquiEngineTab(tabFolder);
        this.createReqEngineTab(tabFolder);
        this.createConflictDetectorTab(tabFolder);
        return container;
    }

    private void createConflictDetectorTab(TabFolder tabFolder) {
        IItemRegistry conflictDetectorDescriptorRegistry = EMFCompareRCPPlugin.getDefault().getConflictDetectorDescriptorRegistry();
        Composite tabComposite = this.createTabSkeleton(tabFolder, EMFCompareRCPUIMessages.getString("EnginesPreferencePage.CONFLICT_DETECTOR_TAB_LABEL"), EMFCompareRCPUIMessages.getString("EnginesPreferencePagestatic.CONFLICT_DETECTOR_INTRO_TEXT"));
        InteractiveUIContent contentStructure = this.createContentSkeleton(tabComposite);
        this.setUpUniqueCheckViewer(conflictDetectorDescriptorRegistry, contentStructure, "org.eclipse.emf.compare.preference.conflict.detector", this.conflictsDetectorData);
        this.interactiveUis.put("org.eclipse.emf.compare.preference.conflict.detector", contentStructure);
    }

    private void createReqEngineTab(TabFolder tabFolder) {
        IItemRegistry reqEngineDescriptorRegistry = EMFCompareRCPPlugin.getDefault().getReqEngineDescriptorRegistry();
        Composite tabComposite = this.createTabSkeleton(tabFolder, EMFCompareRCPUIMessages.getString("EnginesPreferencePage.REQUIREMENT_ENGINE_TAB_LABEL"), EMFCompareRCPUIMessages.getString("EnginesPreferencePagestatic.REQ_ENGINE_INTRO_TEXT"));
        InteractiveUIContent contentStructure = this.createContentSkeleton(tabComposite);
        this.setUpUniqueCheckViewer(reqEngineDescriptorRegistry, contentStructure, "org.eclipse.emf.compare.preference.req.engine", this.reqEngineData);
        this.interactiveUis.put("org.eclipse.emf.compare.preference.req.engine", contentStructure);
    }

    private void createEquiEngineTab(TabFolder tabFolder) {
        IItemRegistry equiEngineDescriptorRegistry = EMFCompareRCPPlugin.getDefault().getEquiEngineDescriptorRegistry();
        Composite tabComposite = this.createTabSkeleton(tabFolder, EMFCompareRCPUIMessages.getString("EnginesPreferencePage.EQUIVALENCES_ENGINE_TAB_LABEL"), EMFCompareRCPUIMessages.getString("EnginesPreferencePagestatic.EQUI_ENGINE_INTRO_TEXT"));
        InteractiveUIContent contentStructure = this.createContentSkeleton(tabComposite);
        this.setUpUniqueCheckViewer(equiEngineDescriptorRegistry, contentStructure, "org.eclipse.emf.compare.preference.equi.engine", this.equiEngineData);
        this.interactiveUis.put("org.eclipse.emf.compare.preference.equi.engine", contentStructure);
    }

    private void createDiffEngineTab(TabFolder tabFolder) {
        IItemRegistry diffEngineDescriptorRegistry = EMFCompareRCPPlugin.getDefault().getDiffEngineDescriptorRegistry();
        Composite tabComposite = this.createTabSkeleton(tabFolder, EMFCompareRCPUIMessages.getString("EnginesPreferencePage.DIFFERENCES_ENGINE_TAB_LABEL"), EMFCompareRCPUIMessages.getString("EnginesPreferencePagestatic.DIFF_ENGINE_INTRO_TEXT"));
        InteractiveUIContent contentStructure = this.createContentSkeleton(tabComposite);
        this.setUpUniqueCheckViewer(diffEngineDescriptorRegistry, contentStructure, "org.eclipse.emf.compare.preference.diff.engine", this.diffEngineData);
        this.interactiveUis.put("org.eclipse.emf.compare.preference.diff.engine", contentStructure);
    }

    private void createMatchEngineTab(TabFolder tabFolder) {
        IItemRegistry matchEngineFactoryDescriptorRegistry = EMFCompareRCPPlugin.getDefault().getMatchEngineFactoryDescriptorRegistry();
        IItemDescriptor defaultMatchEngineDescriptor = matchEngineFactoryDescriptorRegistry.getItemDescriptor(DefaultRCPMatchEngineFactory.class.getCanonicalName());
        Composite tabComposite = this.createTabSkeleton(tabFolder, EMFCompareRCPUIMessages.getString("EnginesPreferencePage.MATCH_ENGINE_TAB_LABEL"), EMFCompareRCPUIMessages.getString("EnginesPreferencePagestatic.MATCH_ENGINE_INTRO_TEXT"));
        InteractiveUIContent interactiveUI = this.createContentSkeleton(tabComposite);
        Map<String, IConfigurationUIFactory> configuratorUIRegistry = EMFCompareRCPUIPlugin.getDefault().getMatchEngineConfiguratorRegistry();
        String matchEnginePreferenceKey = "org.eclipse.emf.compare.preference.match.engine";
        this.setUpMultipleCheckViewer(matchEngineFactoryDescriptorRegistry, interactiveUI, matchEnginePreferenceKey, configuratorUIRegistry);
        this.interactiveUis.put(matchEnginePreferenceKey, interactiveUI);
        interactiveUI.select(defaultMatchEngineDescriptor);
        this.matchEnginesData.setCurrentSelection(this.getActiveItems(matchEngineFactoryDescriptorRegistry, matchEnginePreferenceKey));
        this.bindMultipleData("currentSelection", interactiveUI.getViewer(), this.matchEnginesData);
    }

    private InteractiveUIContent createContentSkeleton(Composite tabComposite) {
        Composite contentComposite = new Composite(tabComposite, 0);
        contentComposite.setLayout((Layout)new GridLayout(2, true));
        contentComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite viewerComposite = new Composite(contentComposite, 0);
        viewerComposite.setLayout((Layout)new GridLayout(1, true));
        viewerComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Group configComposite = this.createConfigComposite(contentComposite);
        Text descriptionText = this.createDescriptionComposite(tabComposite);
        return new InteractiveUIContent(descriptionText, viewerComposite, (Composite)configComposite);
    }

    private Composite createTabSkeleton(TabFolder tabFolder, String tabLabel, String introText) {
        TabItem tbtmMain = new TabItem(tabFolder, 0);
        tbtmMain.setText(tabLabel);
        Composite tabComposite = new Composite((Composite)tabFolder, 0);
        tbtmMain.setControl((Control)tabComposite);
        tabComposite.setLayout((Layout)new GridLayout(1, true));
        GridData layoutData = new GridData(4, 4, false, false, 1, 1);
        tabComposite.setLayoutData((Object)layoutData);
        Label introductionText = new Label(tabComposite, 64);
        introductionText.setText(introText);
        return tabComposite;
    }

    private Text createDescriptionComposite(Composite composite) {
        Group descriptionComposite = new Group(composite, 2048);
        descriptionComposite.setText(EMFCompareRCPUIMessages.getString("EnginesPreferencePagestatic.DESCRIPTION_COMPOSITE_LABEL"));
        descriptionComposite.setLayout((Layout)new GridLayout(1, false));
        descriptionComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Text engineDescriptionText = new Text((Composite)descriptionComposite, 66);
        engineDescriptionText.setBackground(Display.getCurrent().getSystemColor(22));
        GridData layoutData = new GridData(4, 4, true, false, 1, 1);
        layoutData.heightHint = 50;
        engineDescriptionText.setLayoutData((Object)layoutData);
        engineDescriptionText.setEditable(false);
        return engineDescriptionText;
    }

    private Group createConfigComposite(Composite composite) {
        Group configurationComposite = new Group(composite, 2048);
        configurationComposite.setText(EMFCompareRCPUIMessages.getString("EnginesPreferencePagestatic.CONFIGURATION_COMPOSITE_LABEL"));
        StackLayout layout = new StackLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        configurationComposite.setLayout((Layout)layout);
        GridData layoutData = new GridData(4, 4, true, true, 1, 1);
        configurationComposite.setLayoutData((Object)layoutData);
        return configurationComposite;
    }

    private <T> void setUpUniqueCheckViewer(IItemRegistry<T> registry, InteractiveUIContent interactiveUI, String preferenceKey, final SingleValueHolder<T> dataObject) {
        final CheckboxTableViewer descriptorViewer = CheckboxTableViewer.newCheckList((Composite)interactiveUI.getViewerComposite(), (int)68100);
        descriptorViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        descriptorViewer.setLabelProvider((IBaseLabelProvider)this.descriptorLabelProvider);
        GridData gd = new GridData(1808);
        descriptorViewer.getControl().setLayoutData((Object)gd);
        descriptorViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (event.getChecked()) {
                    if (element instanceof IItemDescriptor) {
                        IItemDescriptor descriptor = (IItemDescriptor)element;
                        dataObject.setCurrentSelection(descriptor);
                    }
                    descriptorViewer.setCheckedElements(new Object[]{element});
                } else if (descriptorViewer.getCheckedElements().length == 0) {
                    descriptorViewer.setCheckedElements(new Object[]{element});
                    MessageDialog.openWarning((Shell)EnginesPreferencePage.this.getShell(), (String)EMFCompareRCPUIMessages.getString("EnginesPreferencePagestatic.INCORRECT_SELECTION_TITLE"), (String)EMFCompareRCPUIMessages.getString("EnginesPreferencePagestatic.INCORRECT_SELECTION_MESSAGE"));
                }
            }
        });
        List itemDescriptors = registry.getItemDescriptors();
        Collections.sort(itemDescriptors, Collections.reverseOrder());
        descriptorViewer.setInput((Object)itemDescriptors);
        interactiveUI.setViewer(descriptorViewer);
        IItemDescriptor defaultEngine = ItemUtil.getDefaultItemDescriptor(registry, (String)preferenceKey, (IEclipsePreferences)EMFCompareRCPPlugin.getDefault().getEMFComparePreferences());
        interactiveUI.select(defaultEngine);
        interactiveUI.checkElement(defaultEngine);
        dataObject.setCurrentSelection(defaultEngine);
    }

    private <T> void setUpMultipleCheckViewer(IItemRegistry<T> registry, InteractiveUIContent interactiveUI, String preferenceKey, Map<String, IConfigurationUIFactory> configuratorUIRegistry) {
        CheckboxTableViewer descriptorViewer = CheckboxTableViewer.newCheckList((Composite)interactiveUI.getViewerComposite(), (int)68096);
        interactiveUI.setViewer(descriptorViewer);
        descriptorViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        descriptorViewer.setLabelProvider((IBaseLabelProvider)this.descriptorLabelProvider);
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        descriptorViewer.getControl().setLayoutData((Object)gd);
        for (IItemDescriptor item : registry.getItemDescriptors()) {
            String itemId = item.getID();
            IConfigurationUIFactory configuratorFactory = configuratorUIRegistry.get(itemId);
            if (configuratorFactory == null) continue;
            Preferences pref = ItemUtil.getConfigurationPreferenceNode((String)preferenceKey, (String)itemId);
            interactiveUI.addConfigurator(itemId, configuratorFactory, pref);
        }
        List itemDescriptors = registry.getItemDescriptors();
        Collections.sort(itemDescriptors, Collections.reverseOrder());
        descriptorViewer.setInput((Object)itemDescriptors);
    }

    private <T> Set<IItemDescriptor<T>> getActiveItems(IItemRegistry<T> registry, String preferenceKey) {
        List itemsDescriptor = ItemUtil.getItemsDescriptor(registry, (String)preferenceKey, (IEclipsePreferences)EMFCompareRCPPlugin.getDefault().getEMFComparePreferences());
        if (itemsDescriptor == null) {
            itemsDescriptor = Collections.emptyList();
        }
        HashSet disableFactories = Sets.newHashSet(itemsDescriptor);
        HashSet allFactories = Sets.newHashSet((Iterable)registry.getItemDescriptors());
        Sets.SetView activeFactory = Sets.difference((Set)allFactories, (Set)disableFactories);
        return activeFactory;
    }

    private <T> void bindMultipleData(String engineBindingProperty, CheckboxTableViewer descriptorViewer, MultipleValueHolder<T> dataObject) {
        DataBindingContext ctx = new DataBindingContext();
        IViewerObservableSet target = ViewersObservables.observeCheckedElements((CheckboxTableViewer)descriptorViewer, IItemDescriptor.class);
        IObservableSet model = PojoProperties.set(MultipleValueHolder.class, (String)engineBindingProperty).observe(dataObject);
        ctx.bindSet((IObservableSet)target, model);
    }

    public boolean performOk() {
        this.setEnginesPreferences();
        this.storeConfigurations();
        if (TracingConstant.CONFIGURATION_TRACING_ACTIVATED) {
            StringBuilder traceMessage = new StringBuilder("Preference serialization:\n");
            String prefDelimiter = " :\n";
            String new_line = "\n";
            traceMessage.append("org.eclipse.emf.compare.preference.diff.engine").append(prefDelimiter).append(this.getPreferenceStore().getString("org.eclipse.emf.compare.preference.diff.engine")).append(new_line);
            traceMessage.append("org.eclipse.emf.compare.preference.equi.engine").append(prefDelimiter).append(this.getPreferenceStore().getString("org.eclipse.emf.compare.preference.equi.engine")).append(new_line);
            traceMessage.append("org.eclipse.emf.compare.preference.req.engine").append(prefDelimiter).append(this.getPreferenceStore().getString("org.eclipse.emf.compare.preference.req.engine")).append(new_line);
            traceMessage.append("org.eclipse.emf.compare.preference.conflict.detector").append(prefDelimiter).append(this.getPreferenceStore().getString("org.eclipse.emf.compare.preference.conflict.detector")).append(new_line);
            traceMessage.append("org.eclipse.emf.compare.preference.match.engine").append(prefDelimiter).append(this.getPreferenceStore().getString("org.eclipse.emf.compare.preference.match.engine")).append(new_line);
            EMFCompareRCPPlugin.getDefault().log(1, traceMessage.toString());
        }
        return super.performOk();
    }

    private void setEnginesPreferences() {
        this.setEnginePreferences("org.eclipse.emf.compare.preference.diff.engine", this.diffEngineData.getCurrentSelection(), EMFCompareRCPPlugin.getDefault().getDiffEngineDescriptorRegistry().getHighestRankingDescriptor());
        this.setEnginePreferences("org.eclipse.emf.compare.preference.equi.engine", this.equiEngineData.getCurrentSelection(), EMFCompareRCPPlugin.getDefault().getEquiEngineDescriptorRegistry().getHighestRankingDescriptor());
        this.setEnginePreferences("org.eclipse.emf.compare.preference.req.engine", this.reqEngineData.getCurrentSelection(), EMFCompareRCPPlugin.getDefault().getReqEngineDescriptorRegistry().getHighestRankingDescriptor());
        this.setEnginePreferences("org.eclipse.emf.compare.preference.conflict.detector", this.conflictsDetectorData.getCurrentSelection(), EMFCompareRCPPlugin.getDefault().getConflictDetectorDescriptorRegistry().getHighestRankingDescriptor());
        HashSet matchEngineRegsitry = Sets.newHashSet((Iterable)EMFCompareRCPPlugin.getDefault().getMatchEngineFactoryDescriptorRegistry().getItemDescriptors());
        Sets.SetView matchingEngineToDisable = Sets.difference((Set)matchEngineRegsitry, this.matchEnginesData.getCurrentSelection());
        this.setEnginePreferences("org.eclipse.emf.compare.preference.match.engine", (Set)matchingEngineToDisable, new ArrayList());
    }

    private void storeConfigurations() {
        for (Map.Entry<String, InteractiveUIContent> interactiveContentEntry : this.interactiveUis.entrySet()) {
            for (Map.Entry<String, AbstractConfigurationUI> configuratorEntry : interactiveContentEntry.getValue().getConfigurators().entrySet()) {
                AbstractConfigurationUI configurator = configuratorEntry.getValue();
                configurator.storeConfiguration();
            }
        }
        if (TracingConstant.CONFIGURATION_TRACING_ACTIVATED) {
            StringBuilder traceMessage = new StringBuilder("Configuration serialization:\n");
            String prefDelimiter = " :\n";
            String new_line = "\n";
            String node_Label = "Node ";
            String double_dot_label = " : ";
            String empty_label = "EMPTY";
            for (Map.Entry<String, InteractiveUIContent> interactiveContentEntry : this.interactiveUis.entrySet()) {
                String itemTypeId = interactiveContentEntry.getKey();
                for (Map.Entry<String, AbstractConfigurationUI> configuratorEntry : interactiveContentEntry.getValue().getConfigurators().entrySet()) {
                    String itemToConfigureId = configuratorEntry.getKey();
                    Preferences storeNode = ItemUtil.getConfigurationPreferenceNode((String)itemTypeId, (String)itemToConfigureId);
                    traceMessage.append(node_Label).append(storeNode.absolutePath()).append(prefDelimiter);
                    try {
                        String[] stringArray = storeNode.keys();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String propertyKey = stringArray[n2];
                            traceMessage.append(propertyKey).append(double_dot_label).append(storeNode.get(propertyKey, empty_label)).append(new_line);
                            ++n2;
                        }
                    }
                    catch (BackingStoreException e) {
                        e.printStackTrace();
                        traceMessage.append("Error in tracing ").append(storeNode.absolutePath());
                    }
                }
            }
            EMFCompareRCPPlugin.getDefault().log(1, traceMessage.toString());
        }
    }

    protected void performDefaults() {
        this.resetDefaultPreferencesToHighestRank(EMFCompareRCPPlugin.getDefault().getDiffEngineDescriptorRegistry(), "org.eclipse.emf.compare.preference.diff.engine", this.diffEngineData);
        this.resetDefaultPreferencesToHighestRank(EMFCompareRCPPlugin.getDefault().getReqEngineDescriptorRegistry(), "org.eclipse.emf.compare.preference.req.engine", this.reqEngineData);
        this.resetDefaultPreferencesToHighestRank(EMFCompareRCPPlugin.getDefault().getEquiEngineDescriptorRegistry(), "org.eclipse.emf.compare.preference.equi.engine", this.equiEngineData);
        this.resetDefaultPreferencesToHighestRank(EMFCompareRCPPlugin.getDefault().getConflictDetectorDescriptorRegistry(), "org.eclipse.emf.compare.preference.conflict.detector", this.conflictsDetectorData);
        this.resetDefaultPreferencesToAll(EMFCompareRCPPlugin.getDefault().getMatchEngineFactoryDescriptorRegistry(), "org.eclipse.emf.compare.preference.match.engine", this.matchEnginesData);
        this.resetConfigurations();
        super.performDefaults();
    }

    private void resetConfigurations() {
        for (Map.Entry<String, InteractiveUIContent> interactiveContentEntry : this.interactiveUis.entrySet()) {
            for (AbstractConfigurationUI configurator : interactiveContentEntry.getValue().getConfigurators().values()) {
                configurator.resetDefault();
            }
        }
    }

    private <T> void resetDefaultPreferencesToHighestRank(IItemRegistry<T> registry, String preferenceKey, SingleValueHolder<T> dataObject) {
        InteractiveUIContent interactiveContent = this.interactiveUis.get(preferenceKey);
        if (interactiveContent != null) {
            IItemDescriptor defaultEngine = registry.getHighestRankingDescriptor();
            interactiveContent.select(defaultEngine);
            interactiveContent.checkElement(defaultEngine);
            dataObject.setCurrentSelection(defaultEngine);
        }
    }

    private <T> void resetDefaultPreferencesToAll(IItemRegistry<T> registry, String preferenceKey, MultipleValueHolder<T> dataObject) {
        InteractiveUIContent interactiveContent = this.interactiveUis.get(preferenceKey);
        if (interactiveContent != null) {
            IItemDescriptor defaultEngine = registry.getHighestRankingDescriptor();
            interactiveContent.select(defaultEngine);
            List itemDescriptors = registry.getItemDescriptors();
            interactiveContent.checkElements(itemDescriptors.toArray(new IItemDescriptor[itemDescriptors.size()]));
            dataObject.setCurrentSelection(Sets.newHashSet((Iterable)itemDescriptors));
        }
    }

    private <T> void setEnginePreferences(String preferenceKey, IItemDescriptor<T> currentSelectedEngine, IItemDescriptor<T> defaultConf) {
        if (currentSelectedEngine != null && !currentSelectedEngine.equals(defaultConf)) {
            this.getPreferenceStore().setValue(preferenceKey, currentSelectedEngine.getID());
        } else {
            this.getPreferenceStore().setToDefault(preferenceKey);
        }
    }

    private <T> void setEnginePreferences(String preferenceKey, Set<IItemDescriptor<T>> currentSelectedEngine, Collection<IItemDescriptor<T>> defaultConf) {
        if (currentSelectedEngine != null && !currentSelectedEngine.contains(defaultConf)) {
            StringBuilder descriptorsKey = new StringBuilder();
            Iterator<IItemDescriptor<T>> iterator = currentSelectedEngine.iterator();
            while (iterator.hasNext()) {
                IItemDescriptor<T> iItemDescriptor = iterator.next();
                descriptorsKey.append(iItemDescriptor.getID());
                if (!iterator.hasNext()) continue;
                descriptorsKey.append(";");
            }
            this.getPreferenceStore().setValue(preferenceKey, descriptorsKey.toString());
        } else {
            this.getPreferenceStore().setToDefault(preferenceKey);
        }
    }

    private static final class EngineDescriptorLabelProvider
    extends LabelProvider {
        private EngineDescriptorLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IItemDescriptor) {
                IItemDescriptor desc = (IItemDescriptor)element;
                return desc.getLabel();
            }
            return super.getText(element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InteractiveUIContent {
        private final Text descriptionText;
        private final Composite viewerCompsite;
        private final Composite configurationComposite;
        private final Composite defaultComposite;
        private CheckboxTableViewer viewer;
        private final Map<String, AbstractConfigurationUI> configurators = new HashMap<String, AbstractConfigurationUI>();

        public InteractiveUIContent(Text descriptionText, Composite viewerCompsite, Composite configurationComposite) {
            this.descriptionText = descriptionText;
            this.viewerCompsite = viewerCompsite;
            this.configurationComposite = configurationComposite;
            this.defaultComposite = new Composite(configurationComposite, 0);
            this.defaultComposite.setLayout((Layout)new GridLayout(1, true));
            Label text = new Label(this.defaultComposite, 64);
            text.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
            text.setText(EMFCompareRCPUIMessages.getString("InteractiveUIContent.DEFAULT_CONFIGURATION_LABEL"));
        }

        public void addConfigurator(String id, IConfigurationUIFactory configuratorfactory, Preferences pref) {
            AbstractConfigurationUI configurator = configuratorfactory.createUI(this.configurationComposite, 0, pref);
            this.configurators.put(id, configurator);
        }

        public void checkElement(IItemDescriptor<?> descriptor) {
            this.viewer.setCheckedElements(new Object[]{descriptor});
        }

        public void checkElements(IItemDescriptor<?>[] descriptors) {
            this.viewer.setCheckedElements((Object[])descriptors);
        }

        public void setViewer(CheckboxTableViewer inputViewer) {
            this.viewer = inputViewer;
            this.viewer.addSelectionChangedListener((ISelectionChangedListener)new ConfigurationListener());
            this.viewer.addSelectionChangedListener((ISelectionChangedListener)new DescriptionListener());
        }

        public Map<String, AbstractConfigurationUI> getConfigurators() {
            return ImmutableMap.copyOf(this.configurators);
        }

        public void select(IItemDescriptor<?> descriptor) {
            this.viewer.setSelection((ISelection)new StructuredSelection(descriptor), true);
            this.updateLinkedElements(descriptor);
        }

        private void updateLinkedElements(IItemDescriptor<?> descriptor) {
            this.descriptionText.setText(descriptor.getDescription());
            StackLayout stackLayout = (StackLayout)this.configurationComposite.getLayout();
            stackLayout.topControl = this.configurators.containsKey(descriptor.getID()) ? (Control)this.configurators.get(descriptor.getID()) : this.defaultComposite;
            this.configurationComposite.layout();
        }

        public Composite getViewerComposite() {
            return this.viewerCompsite;
        }

        public CheckboxTableViewer getViewer() {
            return this.viewer;
        }

        private final class ConfigurationListener
        implements ISelectionChangedListener {
            private ConfigurationListener() {
            }

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection structSelection;
                Object selected;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (selected = (structSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IItemDescriptor) {
                    InteractiveUIContent.this.updateLinkedElements((IItemDescriptor)selected);
                }
            }
        }

        private final class DescriptionListener
        implements ISelectionChangedListener {
            private DescriptionListener() {
            }

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection structSelection;
                Object selected;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (selected = (structSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IItemDescriptor) {
                    IItemDescriptor desc = (IItemDescriptor)selected;
                    String description = desc.getDescription();
                    InteractiveUIContent.this.descriptionText.setText(description);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MultipleValueHolder<T> {
        private static final String DATA_FIELD_NAME = "currentSelection";
        public Set<IItemDescriptor<T>> currentSelection = new HashSet<IItemDescriptor<T>>();

        private MultipleValueHolder() {
        }

        public Set<IItemDescriptor<T>> getCurrentSelection() {
            return this.currentSelection;
        }

        public void setCurrentSelection(Set<IItemDescriptor<T>> currentSelection) {
            this.currentSelection = currentSelection;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SingleValueHolder<T> {
        public IItemDescriptor<T> currentSelection;

        private SingleValueHolder() {
        }

        public IItemDescriptor<T> getCurrentSelection() {
            return this.currentSelection;
        }

        public void setCurrentSelection(IItemDescriptor<T> currentSelection) {
            this.currentSelection = currentSelection;
        }
    }
}

