/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.equi;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Equivalence;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.equi.IEquiEngine;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;

public class DefaultEquiEngine
implements IEquiEngine {
    public void computeEquivalences(Comparison comparison, Monitor monitor) {
        for (Diff difference : comparison.getDifferences()) {
            this.checkForEquivalences(comparison, difference);
        }
    }

    protected void checkForEquivalences(Comparison comparison, Diff difference) {
        ReferenceChange referenceChange;
        EReference reference;
        EReference eOpposite;
        if (difference instanceof ReferenceChange && (eOpposite = (reference = (referenceChange = (ReferenceChange)difference).getReference()).getEOpposite()) != null && !eOpposite.isContainer() && !eOpposite.isDerived()) {
            this.checkForEquivalences(comparison, referenceChange);
        }
    }

    protected void checkForEquivalences(final Comparison comparison, final ReferenceChange referenceChange) {
        Equivalence equivalence = referenceChange.getEquivalence();
        if (equivalence == null) {
            equivalence = CompareFactory.eINSTANCE.createEquivalence();
            comparison.getEquivalences().add((Object)equivalence);
            equivalence.getDifferences().add((Object)referenceChange);
            Match valueMatch = comparison.getMatch(referenceChange.getValue());
            final EReference eOpposite = referenceChange.getReference().getEOpposite();
            if (eOpposite != null && valueMatch != null) {
                Predicate<Diff> candidateFilter = new Predicate<Diff>(){

                    public boolean apply(Diff input) {
                        if (input instanceof ReferenceChange && ((ReferenceChange)input).getReference() == eOpposite) {
                            Match candidateMatch = comparison.getMatch(((ReferenceChange)input).getValue());
                            return candidateMatch == referenceChange.getMatch();
                        }
                        return false;
                    }
                };
                Iterable candidates = Iterables.filter(valueMatch.getDifferences(), (Predicate)candidateFilter);
                for (Diff candidate : candidates) {
                    equivalence.getDifferences().add((Object)candidate);
                }
                this.addChangesFromOrigin(comparison, referenceChange, equivalence);
            }
        }
    }

    private void addChangesFromOrigin(Comparison comparison, ReferenceChange diff, Equivalence equivalence) {
        EObject originContainer;
        if (!diff.getReference().isMany() && (originContainer = MatchUtil.getOriginContainer(diff.getMatch().getComparison(), diff)) != null) {
            for (Diff referenceChange : comparison.getDifferences(originContainer)) {
                if (!(referenceChange instanceof ReferenceChange) || !diff.getReference().equals(((ReferenceChange)referenceChange).getReference().getEOpposite())) continue;
                equivalence.getDifferences().add((Object)referenceChange);
            }
        }
    }
}

