/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.spec;

import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.AbstractEList;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.impl.ComparisonImpl;
import org.eclipse.emf.compare.internal.DiffCrossReferencer;
import org.eclipse.emf.compare.internal.MatchCrossReferencer;
import org.eclipse.emf.compare.utils.EqualityHelper;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparisonSpec
extends ComparisonImpl {
    private MatchCrossReferencer matchCrossReferencer;
    private DiffCrossReferencer diffCrossReferencer;

    @Override
    public EList<Diff> getDifferences() {
        UnmodifiableIterator diffIterator = Iterators.filter((Iterator)this.eAllContents(), Diff.class);
        BasicEList allDifferences = new BasicEList();
        while (diffIterator.hasNext()) {
            ((AbstractEList)allDifferences).addUnique((Object)((Diff)diffIterator.next()));
        }
        return allDifferences;
    }

    @Override
    public EList<Diff> getDifferences(EObject element) {
        BasicEList result;
        Match match;
        if (element == null) {
            return new BasicEList();
        }
        if (this.diffCrossReferencer == null) {
            this.diffCrossReferencer = new DiffCrossReferencer();
            this.eAdapters().add((Object)this.diffCrossReferencer);
        }
        if ((match = this.getMatch(element)) != null) {
            ArrayList lists = Lists.newArrayList();
            lists.add(this.getInverse(element, this.diffCrossReferencer));
            if (match.getLeft() != null) {
                lists.add(this.getInverse(match.getLeft(), this.diffCrossReferencer));
            }
            if (match.getRight() != null) {
                lists.add(this.getInverse(match.getRight(), this.diffCrossReferencer));
            }
            if (match.getOrigin() != null) {
                lists.add(this.getInverse(match.getOrigin(), this.diffCrossReferencer));
            }
            lists.add(Iterables.filter(match.getDifferences(), ResourceAttachmentChange.class));
            ImmutableSet crossRefs = ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)Iterables.concat((Iterable)lists), Diff.class));
            result = new BasicEList((Collection)crossRefs);
        } else {
            result = new BasicEList((Collection)ImmutableSet.copyOf((Iterable)Iterables.filter(this.getInverse(element, this.diffCrossReferencer), Diff.class)));
        }
        return result;
    }

    @Override
    public Match getMatch(EObject element) {
        if (element != null) {
            if (this.matchCrossReferencer == null) {
                this.matchCrossReferencer = new MatchCrossReferencer();
                this.eAdapters().add((Object)this.matchCrossReferencer);
            }
            Collection<EStructuralFeature.Setting> settings = this.matchCrossReferencer.getInverseReferences(element, false);
            for (EStructuralFeature.Setting setting : settings) {
                if (!(setting.getEObject() instanceof Match)) continue;
                return (Match)setting.getEObject();
            }
        }
        return null;
    }

    private Iterable<EObject> getInverse(EObject element, ECrossReferenceAdapter adapter) {
        Collection settings = adapter.getInverseReferences(element, false);
        ArrayList eObjects = Lists.newArrayList();
        for (EStructuralFeature.Setting setting : settings) {
            eObjects.add(setting.getEObject());
        }
        return eObjects;
    }

    @Override
    public IEqualityHelper getEqualityHelper() {
        IEqualityHelper ret = (IEqualityHelper)EcoreUtil.getExistingAdapter((Notifier)this, IEqualityHelper.class);
        if (ret == null) {
            ret = new EqualityHelper(EqualityHelper.createDefaultCache((CacheBuilder<Object, Object>)CacheBuilder.newBuilder().maximumSize(1024L)));
            this.eAdapters().add((Object)ret);
            ret.setTarget((Notifier)this);
        }
        return ret;
    }
}

