/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.merge;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.compare.utils.DiffUtil;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceChangeMerger
extends AbstractMerger {
    @Override
    public boolean isMergerFor(Diff target) {
        return target instanceof ReferenceChange;
    }

    @Override
    public void copyLeftToRight(Diff target, Monitor monitor) {
        boolean continueMerge;
        if (target.getState() != DifferenceState.UNRESOLVED) {
            return;
        }
        ReferenceChange diff = (ReferenceChange)target;
        diff.setState(DifferenceState.MERGED);
        if (diff.getEquivalence() != null && !(continueMerge = this.handleEquivalences(diff, false, monitor))) {
            return;
        }
        if (diff.getSource() == DifferenceSource.LEFT) {
            this.mergeRequires(diff, false, monitor);
            switch (diff.getKind()) {
                case ADD: {
                    this.addInTarget(diff, false);
                    break;
                }
                case DELETE: {
                    this.removeFromTarget(diff, false);
                    break;
                }
                case MOVE: {
                    this.moveElement(diff, false);
                    break;
                }
                case CHANGE: {
                    if (diff.getMatch().getLeft() != null) {
                        EObject leftValue = (EObject)diff.getMatch().getLeft().eGet((EStructuralFeature)diff.getReference(), false);
                        if (leftValue == null) {
                            this.removeFromTarget(diff, false);
                            break;
                        }
                        this.addInTarget(diff, false);
                        break;
                    }
                    this.removeFromTarget(diff, false);
                    break;
                }
            }
        } else {
            this.mergeRequiredBy(diff, false, monitor);
            switch (diff.getKind()) {
                case ADD: {
                    this.removeFromTarget(diff, false);
                    break;
                }
                case DELETE: {
                    this.addInTarget(diff, false);
                    break;
                }
                case MOVE: {
                    this.moveElement(diff, false);
                    break;
                }
                case CHANGE: {
                    if (diff.getMatch().getRight() != null) {
                        EObject rightValue = (EObject)diff.getMatch().getRight().eGet((EStructuralFeature)diff.getReference(), false);
                        if (rightValue == null) {
                            this.addInTarget(diff, false);
                            break;
                        }
                        this.resetInTarget(diff, false);
                        break;
                    }
                    this.addInTarget(diff, false);
                    break;
                }
            }
        }
    }

    @Override
    public void copyRightToLeft(Diff target, Monitor monitor) {
        boolean continueMerge;
        if (target.getState() != DifferenceState.UNRESOLVED) {
            return;
        }
        ReferenceChange diff = (ReferenceChange)target;
        diff.setState(DifferenceState.MERGED);
        if (diff.getEquivalence() != null && !(continueMerge = this.handleEquivalences(diff, true, monitor))) {
            return;
        }
        if (diff.getSource() == DifferenceSource.LEFT) {
            this.mergeRequiredBy(diff, true, monitor);
            switch (diff.getKind()) {
                case ADD: {
                    this.removeFromTarget(diff, true);
                    break;
                }
                case DELETE: {
                    this.addInTarget(diff, true);
                    break;
                }
                case MOVE: {
                    this.moveElement(diff, true);
                    break;
                }
                case CHANGE: {
                    if (diff.getMatch().getLeft() != null) {
                        EObject leftValue = (EObject)diff.getMatch().getLeft().eGet((EStructuralFeature)diff.getReference(), false);
                        if (leftValue == null) {
                            this.addInTarget(diff, true);
                            break;
                        }
                        this.resetInTarget(diff, true);
                        break;
                    }
                    this.addInTarget(diff, true);
                    break;
                }
            }
        } else {
            this.mergeRequires(diff, true, monitor);
            switch (diff.getKind()) {
                case ADD: {
                    this.addInTarget(diff, true);
                    break;
                }
                case DELETE: {
                    this.removeFromTarget(diff, true);
                    break;
                }
                case MOVE: {
                    this.moveElement(diff, true);
                    break;
                }
                case CHANGE: {
                    if (diff.getMatch().getRight() != null) {
                        EObject rightValue = (EObject)diff.getMatch().getRight().eGet((EStructuralFeature)diff.getReference(), false);
                        if (rightValue == null) {
                            this.removeFromTarget(diff, true);
                            break;
                        }
                        this.addInTarget(diff, true);
                        break;
                    }
                    this.removeFromTarget(diff, true);
                    break;
                }
            }
        }
    }

    protected void moveElement(ReferenceChange diff, boolean rightToLeft) {
        EObject expectedValue;
        EObject expectedContainer;
        Comparison comparison = diff.getMatch().getComparison();
        Match valueMatch = comparison.getMatch(diff.getValue());
        EReference reference = diff.getReference();
        if (reference.isContainment()) {
            Match targetContainerMatch = rightToLeft && valueMatch.getRight() != null ? comparison.getMatch(valueMatch.getRight().eContainer()) : (!rightToLeft && valueMatch.getLeft() != null ? comparison.getMatch(valueMatch.getLeft().eContainer()) : comparison.getMatch(valueMatch.getOrigin().eContainer()));
            expectedContainer = rightToLeft ? targetContainerMatch.getLeft() : targetContainerMatch.getRight();
        } else {
            expectedContainer = rightToLeft ? diff.getMatch().getLeft() : diff.getMatch().getRight();
        }
        if (expectedContainer == null) {
            return;
        }
        if (valueMatch == null) {
            if (reference.isMany()) {
                List targetList = (List)expectedContainer.eGet((EStructuralFeature)reference);
                expectedValue = this.findMatchIn(comparison, targetList, diff.getValue());
            } else {
                expectedValue = (EObject)expectedContainer.eGet((EStructuralFeature)reference);
            }
        } else {
            expectedValue = rightToLeft ? valueMatch.getLeft() : valueMatch.getRight();
        }
        this.doMove(diff, comparison, expectedContainer, expectedValue, rightToLeft);
    }

    protected void doMove(ReferenceChange diff, Comparison comparison, EObject expectedContainer, EObject expectedValue, boolean rightToLeft) {
        EReference reference = diff.getReference();
        if (reference.isMany()) {
            List targetList;
            int currentIndex;
            int insertionIndex = this.findInsertionIndex(comparison, diff, rightToLeft);
            if (insertionIndex > (currentIndex = (targetList = (List)expectedContainer.eGet((EStructuralFeature)reference)).indexOf(expectedValue)) && currentIndex >= 0) {
                --insertionIndex;
            }
            if (currentIndex == -1) {
                if (!reference.isContainment()) {
                    targetList.remove(expectedValue);
                }
                if (insertionIndex < 0 && insertionIndex > targetList.size()) {
                    targetList.add(expectedValue);
                } else {
                    targetList.add(insertionIndex, expectedValue);
                }
            } else if (targetList instanceof EList) {
                if (insertionIndex < 0 && insertionIndex > targetList.size()) {
                    ((EList)targetList).move(targetList.size() - 1, (Object)expectedValue);
                } else {
                    ((EList)targetList).move(insertionIndex, (Object)expectedValue);
                }
            } else {
                targetList.remove(expectedValue);
                if (insertionIndex < 0 && insertionIndex > targetList.size()) {
                    targetList.add(expectedValue);
                } else {
                    targetList.add(insertionIndex, expectedValue);
                }
            }
        } else {
            expectedContainer.eSet((EStructuralFeature)reference, (Object)expectedValue);
        }
    }

    protected void addInTarget(ReferenceChange diff, boolean rightToLeft) {
        EObject expectedValue;
        Match match = diff.getMatch();
        EObject expectedContainer = rightToLeft ? match.getLeft() : match.getRight();
        if (expectedContainer == null) {
            return;
        }
        Comparison comparison = match.getComparison();
        EReference reference = diff.getReference();
        Match valueMatch = comparison.getMatch(diff.getValue());
        if (valueMatch == null) {
            expectedValue = diff.getValue().eIsProxy() ? EcoreUtil.copy((EObject)diff.getValue()) : diff.getValue();
        } else if (rightToLeft) {
            if (reference.isContainment()) {
                expectedValue = this.createCopy(diff.getValue());
                valueMatch.setLeft(expectedValue);
            } else {
                expectedValue = valueMatch.getLeft();
            }
        } else if (reference.isContainment()) {
            expectedValue = this.createCopy(diff.getValue());
            valueMatch.setRight(expectedValue);
        } else {
            expectedValue = valueMatch.getRight();
        }
        if (reference.isMany()) {
            int insertionIndex = this.findInsertionIndex(comparison, diff, rightToLeft);
            List targetList = (List)expectedContainer.eGet((EStructuralFeature)reference);
            this.addAt(targetList, expectedValue, insertionIndex);
        } else {
            expectedContainer.eSet((EStructuralFeature)reference, (Object)expectedValue);
        }
        if (reference.isContainment()) {
            Resource initialResource = diff.getValue().eResource();
            Resource targetResource = expectedValue.eResource();
            if (initialResource instanceof XMIResource && targetResource instanceof XMIResource) {
                ((XMIResource)targetResource).setID(expectedValue, ((XMIResource)initialResource).getID(diff.getValue()));
            }
        }
    }

    protected void removeFromTarget(ReferenceChange diff, boolean rightToLeft) {
        EObject expectedValue;
        List targetList;
        Match match = diff.getMatch();
        EReference reference = diff.getReference();
        EObject currentContainer = rightToLeft ? match.getLeft() : match.getRight();
        Comparison comparison = match.getComparison();
        Match valueMatch = comparison.getMatch(diff.getValue());
        if (currentContainer == null) {
            return;
        }
        if (valueMatch == null) {
            if (reference.isMany()) {
                targetList = (List)currentContainer.eGet((EStructuralFeature)reference);
                expectedValue = this.findMatchIn(comparison, targetList, diff.getValue());
            } else {
                expectedValue = null;
            }
        } else {
            expectedValue = rightToLeft ? valueMatch.getLeft() : valueMatch.getRight();
        }
        if (reference.isContainment() && expectedValue != null) {
            EcoreUtil.remove((EObject)expectedValue);
            if (rightToLeft && valueMatch != null) {
                valueMatch.setLeft(null);
            } else if (valueMatch != null) {
                valueMatch.setRight(null);
            }
        } else if (reference.isMany()) {
            targetList = (List)currentContainer.eGet((EStructuralFeature)reference);
            targetList.remove(expectedValue);
        } else {
            currentContainer.eUnset((EStructuralFeature)reference);
        }
    }

    protected void resetInTarget(ReferenceChange diff, boolean rightToLeft) {
        Match match = diff.getMatch();
        EReference reference = diff.getReference();
        EObject targetContainer = rightToLeft ? match.getLeft() : match.getRight();
        EObject originContainer = match.getComparison().isThreeWay() ? match.getOrigin() : (rightToLeft ? match.getRight() : match.getLeft());
        if (originContainer == null || !ReferenceUtil.safeEIsSet(targetContainer, (EStructuralFeature)reference) || !ReferenceUtil.safeEIsSet(originContainer, (EStructuralFeature)reference)) {
            targetContainer.eUnset((EStructuralFeature)reference);
        } else {
            EObject originalValue = (EObject)originContainer.eGet((EStructuralFeature)reference);
            Match valueMatch = match.getComparison().getMatch(originalValue);
            EObject expectedValue = valueMatch == null ? originalValue : (rightToLeft ? valueMatch.getLeft() : valueMatch.getRight());
            targetContainer.eSet((EStructuralFeature)reference, (Object)expectedValue);
        }
    }

    protected boolean handleEquivalences(ReferenceChange diff, boolean rightToLeft, Monitor monitor) {
        EReference reference = diff.getReference();
        boolean continueMerge = true;
        for (Diff equivalent : diff.getEquivalence().getDifferences()) {
            if (equivalent instanceof ReferenceChange && reference.getEOpposite() == ((ReferenceChange)equivalent).getReference() && equivalent.getState() == DifferenceState.UNRESOLVED) {
                boolean mergeEquivalence;
                boolean bl = mergeEquivalence = !reference.isMany() && ((ReferenceChange)equivalent).getReference().isMany();
                if (mergeEquivalence) {
                    this.mergeDiff(equivalent, rightToLeft, monitor);
                    continueMerge = false;
                }
            } else if (diff.getSource() == DifferenceSource.LEFT) {
                if (rightToLeft && diff.getRequiredBy().contains((Object)equivalent)) {
                    this.mergeDiff(equivalent, rightToLeft, monitor);
                    continueMerge = false;
                } else if (!rightToLeft && diff.getRequires().contains((Object)equivalent)) {
                    this.mergeDiff(equivalent, rightToLeft, monitor);
                    continueMerge = false;
                }
            } else if (diff.getSource() == DifferenceSource.RIGHT) {
                if (rightToLeft && diff.getRequires().contains((Object)equivalent)) {
                    this.mergeDiff(equivalent, rightToLeft, monitor);
                    continueMerge = false;
                } else if (!rightToLeft && diff.getRequiredBy().contains((Object)equivalent)) {
                    this.mergeDiff(equivalent, rightToLeft, monitor);
                    continueMerge = false;
                }
            }
            equivalent.setState(DifferenceState.MERGED);
        }
        return continueMerge;
    }

    protected EObject findMatchIn(Comparison comparison, List<EObject> list, EObject element) {
        IEqualityHelper helper = comparison.getEqualityHelper();
        for (EObject next : list) {
            if (!helper.matchingValues(next, element)) continue;
            return next;
        }
        return null;
    }

    protected int findInsertionIndex(Comparison comparison, Diff diff, boolean rightToLeft) {
        return DiffUtil.findInsertionIndex(comparison, diff, rightToLeft);
    }
}

