/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.ComparePackage;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffCrossReferencer
extends ECrossReferenceAdapter {
    protected boolean isIncluded(EReference eReference) {
        if (super.isIncluded(eReference)) {
            EClass eClass = eReference.getEContainingClass();
            return eClass.getEAllSuperTypes().contains((Object)ComparePackage.Literals.DIFF);
        }
        return false;
    }

    public Collection<EStructuralFeature.Setting> getInverseReferences(EObject eObject, boolean resolve) {
        Collection nonNavigableInverseReferences;
        EObject eContainer;
        ArrayList<EStructuralFeature.Setting> result = new ArrayList<EStructuralFeature.Setting>();
        if (resolve) {
            this.resolveAll(eObject);
        }
        if ((eContainer = eObject.eContainer()) != null && eObject.eContainingFeature() != null) {
            result.add(((InternalEObject)eContainer).eSetting((EStructuralFeature)eObject.eContainmentFeature()));
        }
        if ((nonNavigableInverseReferences = (Collection)this.inverseCrossReferencer.get((Object)eObject)) != null) {
            result.addAll(nonNavigableInverseReferences);
        }
        for (EReference eReference : eObject.eClass().getEAllReferences()) {
            EReference eOpposite = eReference.getEOpposite();
            if (eOpposite == null || eReference.isContainer() || !eObject.eIsSet((EStructuralFeature)eReference)) continue;
            if (eReference.isMany()) {
                Object collection = eObject.eGet((EStructuralFeature)eReference);
                Iterator j = this.resolve() ? ((Collection)collection).iterator() : ((InternalEList)collection).basicIterator();
                while (j.hasNext()) {
                    InternalEObject referencingEObject = (InternalEObject)j.next();
                    result.add(referencingEObject.eSetting((EStructuralFeature)eOpposite));
                }
                continue;
            }
            result.add(((InternalEObject)eObject.eGet((EStructuralFeature)eReference, this.resolve())).eSetting((EStructuralFeature)eOpposite));
        }
        return result;
    }

    protected void handleContainment(Notification notification) {
        super.handleContainment(notification);
        switch (notification.getEventType()) {
            case 4: {
                Notifier oldValue = (Notifier)notification.getOldValue();
                if (oldValue instanceof InternalEObject) {
                    Resource.Internal eDirectResource = ((InternalEObject)oldValue).eDirectResource();
                    if (eDirectResource != null && eDirectResource.eAdapters().contains((Object)this)) break;
                    this.removeAdapter(oldValue);
                    break;
                }
                if (oldValue == null) break;
                this.removeAdapter(oldValue);
                break;
            }
        }
    }

    protected void addAdapter(Notifier notifier) {
        if (notifier instanceof Match || notifier instanceof Diff) {
            super.addAdapter(notifier);
        }
    }
}

