/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.IDifferenceFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.IDifferenceFilterSelectionChangeEvent;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.IDifferenceGroup;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructureMergeViewerFilter
extends ViewerFilter {
    private Set<Predicate<? super EObject>> predicates = Sets.newLinkedHashSet();
    private List<TreeViewer> viewers = Lists.newArrayList();
    private EventBus eventBus;

    public StructureMergeViewerFilter(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.getPredicates().isEmpty()) {
            return true;
        }
        boolean result = false;
        Predicate predicate = Predicates.or(this.getPredicates());
        if (this.getPredicates().isEmpty()) {
            result = true;
        } else if (element instanceof Adapter) {
            Notifier notifier = ((Adapter)element).getTarget();
            if (notifier instanceof Diff) {
                Diff diff = (Diff)notifier;
                result = !predicate.apply((Object)diff);
            } else if (notifier instanceof Match) {
                Match match = (Match)notifier;
                boolean bl = result = !predicate.apply((Object)match);
                if (result && !Iterables.isEmpty((Iterable)match.getAllDifferences())) {
                    Iterator differences = match.getAllDifferences().iterator();
                    return Iterators.any(differences, (Predicate)Predicates.not((Predicate)predicate));
                }
            } else if (notifier instanceof MatchResource) {
                MatchResource matchResource = (MatchResource)notifier;
                result = !predicate.apply((Object)matchResource);
            } else if (notifier instanceof Conflict) {
                Iterator differences = ((Conflict)notifier).getDifferences().iterator();
                result = Iterators.any((Iterator)differences, (Predicate)Predicates.not((Predicate)predicate));
            }
        } else if (element instanceof IDifferenceGroup) {
            Iterator<? extends Diff> differences = ((IDifferenceGroup)element).getDifferences().iterator();
            result = Iterators.any(differences, (Predicate)Predicates.not((Predicate)predicate));
        } else if (element instanceof Adapter && ((Adapter)element).getTarget() instanceof EObject) {
            EObject target = (EObject)((Adapter)element).getTarget();
            result = !predicate.apply((Object)target);
        }
        return result;
    }

    public void addFilter(IDifferenceFilter filter) {
        this.getPredicates().remove(filter.getPredicateWhenUnselected());
        this.addPredicate(filter.getPredicateWhenSelected());
        this.eventBus.post((Object)new IDifferenceFilterSelectionChangeEvent.DefaultFilterSelectionChangeEvent(filter, IDifferenceFilterSelectionChangeEvent.Action.ACTIVATE));
    }

    public void removeFilter(IDifferenceFilter filter) {
        this.getPredicates().add(filter.getPredicateWhenUnselected());
        this.removePredicate(filter.getPredicateWhenSelected());
        this.eventBus.post((Object)new IDifferenceFilterSelectionChangeEvent.DefaultFilterSelectionChangeEvent(filter, IDifferenceFilterSelectionChangeEvent.Action.DEACTIVATE));
    }

    public void addPredicate(Predicate<? super EObject> predicate) {
        boolean changed = this.getPredicates().add(predicate);
        if (changed) {
            this.refreshViewers();
        }
    }

    public void removePredicate(Predicate<? super EObject> predicate) {
        boolean changed = this.getPredicates().remove(predicate);
        if (changed) {
            this.refreshViewers();
        }
    }

    private void refreshViewers() {
        for (TreeViewer viewer : this.viewers) {
            TreePath[] paths = viewer.getExpandedTreePaths();
            viewer.refresh();
            viewer.setExpandedTreePaths(paths);
        }
    }

    public void install(final TreeViewer viewer) {
        viewer.addFilter((ViewerFilter)this);
        viewer.getTree().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                StructureMergeViewerFilter.this.uninstall(viewer);
            }
        });
        this.viewers.add(viewer);
    }

    public void uninstall(TreeViewer viewer) {
        viewer.removeFilter((ViewerFilter)this);
        this.viewers.remove(viewer);
    }

    public Set<Predicate<? super EObject>> getPredicates() {
        return this.predicates;
    }
}

