/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.utils;

import com.google.common.annotations.Beta;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.IAdaptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public class StorageTraversal
implements IAdaptable {
    private Set<? extends IStorage> storages;

    public StorageTraversal(Set<? extends IStorage> storages) {
        this.storages = storages;
    }

    public Set<? extends IStorage> getStorages() {
        return this.storages;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ResourceTraversal.class) {
            ArrayList resources = Lists.newArrayListWithCapacity((int)this.storages.size());
            for (IStorage iStorage : this.storages) {
                if (iStorage instanceof IFile) {
                    resources.add((IFile)iStorage);
                    continue;
                }
                resources.add(ResourcesPlugin.getWorkspace().getRoot().getFile(iStorage.getFullPath()));
            }
            IResource[] iResourceArray = resources.toArray(new IResource[resources.size()]);
            return new ResourceTraversal(iResourceArray, 1, 0);
        }
        return null;
    }
}

