/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.text;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareNavigator;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.ICompareNavigator;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.internal.CompareHandlerService;
import org.eclipse.compare.internal.MergeSourceViewer;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.command.ICompareCopyCommand;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.text.EMFCompareTextMergeViewerContentProvider;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.DynamicObject;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.AttributeChangeNode;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class EMFCompareTextMergeViewer
extends TextMergeViewer {
    private static final String BUNDLE_NAME = EMFCompareTextMergeViewer.class.getName();
    private final ICompareEditingDomain fEditingDomain = (ICompareEditingDomain)this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.ide.ui.EDITING_DOMAIN");
    private DynamicObject fDynamicObject;
    private ActionContributionItem fCopyDiffLeftToRightItem;
    private ActionContributionItem fCopyDiffRightToLeftItem;

    public EMFCompareTextMergeViewer(Composite parent, CompareConfiguration configuration) {
        super(parent, configuration);
        this.setContentProvider((IContentProvider)new EMFCompareTextMergeViewerContentProvider(configuration));
    }

    protected void copy(boolean leftToRight) {
        Object input = this.getInput();
        if (input instanceof AttributeChangeNode) {
            AttributeChange attributeChange = ((AttributeChangeNode)((Object)input)).getTarget();
            Comparison comparison = attributeChange.getMatch().getComparison();
            Command copyCommand = this.fEditingDomain.createCopyAllNonConflictingCommand((List)comparison.getDifferences(), leftToRight, EMFCompareRCPPlugin.getDefault().getMergerRegistry());
            this.fEditingDomain.getCommandStack().execute(copyCommand);
            this.refresh();
        }
    }

    protected void copyDiff(boolean leftToRight) {
        Object input = this.getInput();
        if (input instanceof AttributeChangeNode) {
            AttributeChange attributeChange = ((AttributeChangeNode)((Object)input)).getTarget();
            Command copyCommand = this.fEditingDomain.createCopyCommand(Collections.singletonList(attributeChange), leftToRight, EMFCompareRCPPlugin.getDefault().getMergerRegistry());
            this.fEditingDomain.getCommandStack().execute(copyCommand);
            this.refresh();
        }
    }

    protected boolean doSave(Object newInput, Object oldInput) {
        return false;
    }

    public void setInput(Object newInput) {
        Object oldInput;
        if (newInput == null && (oldInput = this.getInput()) instanceof AttributeChangeNode) {
            AttributeChange diff = ((AttributeChangeNode)((Object)oldInput)).getTarget();
            EAttribute eAttribute = diff.getAttribute();
            Match match = diff.getMatch();
            IEqualityHelper equalityHelper = match.getComparison().getEqualityHelper();
            this.updateModel(diff, eAttribute, equalityHelper, match.getLeft(), true);
            this.updateModel(diff, eAttribute, equalityHelper, match.getRight(), false);
        }
        super.setInput(newInput);
    }

    private void updateModel(AttributeChange diff, EAttribute eAttribute, IEqualityHelper equalityHelper, EObject eObject, boolean isLeft) {
        String oldValue = this.getStringValue(eObject, eAttribute);
        String newValue = new String(this.getContents(isLeft));
        boolean oldAndNewEquals = equalityHelper.matchingAttributeValues((Object)newValue, (Object)oldValue);
        if (eObject != null && !oldAndNewEquals && this.getCompareConfiguration().isLeftEditable()) {
            this.fEditingDomain.getCommandStack().execute((Command)new UpdateModelAndRejectDiffCommand(this.fEditingDomain.getChangeRecorder(), eObject, (EStructuralFeature)eAttribute, newValue, (Diff)diff, isLeft));
        }
    }

    private String getStringValue(EObject eObject, EAttribute eAttribute) {
        EDataType eAttributeType = eAttribute.getEAttributeType();
        Object value = eObject == null ? null : ReferenceUtil.safeEGet((EObject)eObject, (EStructuralFeature)eAttribute);
        return EcoreUtil.convertToString((EDataType)eAttributeType, (Object)value);
    }

    public DynamicObject getDynamicObject() {
        if (this.fDynamicObject == null) {
            this.fDynamicObject = new DynamicObject((Object)this);
        }
        return this.fDynamicObject;
    }

    protected final MergeSourceViewer getLeftSourceViewer() {
        return (MergeSourceViewer)this.getDynamicObject().get("fLeft");
    }

    protected final MergeSourceViewer getRightSourceViewer() {
        return (MergeSourceViewer)this.getDynamicObject().get("fRight");
    }

    protected final void setHandlerService(CompareHandlerService service) {
        this.getDynamicObject().set("fHandlerService", service);
    }

    protected void createToolItems(ToolBarManager toolBarManager) {
        CompareHandlerService handlerService = CompareHandlerService.createFor((ICompareContainer)this.getCompareConfiguration().getContainer(), (Shell)this.getLeftSourceViewer().getSourceViewer().getControl().getShell());
        this.setHandlerService(handlerService);
        CompareConfiguration cc = this.getCompareConfiguration();
        if (cc.isRightEditable()) {
            Action copyLeftToRight = new Action(){

                public void run() {
                    EMFCompareTextMergeViewer.this.copyDiff(true);
                    EMFCompareTextMergeViewer.this.navigate(true);
                }
            };
            Utilities.initAction((IAction)copyLeftToRight, (ResourceBundle)this.getResourceBundle(), (String)"action.CopyDiffLeftToRight.");
            this.fCopyDiffLeftToRightItem = new ActionContributionItem((IAction)copyLeftToRight);
            this.fCopyDiffLeftToRightItem.setVisible(true);
            toolBarManager.appendToGroup("merge", (IContributionItem)this.fCopyDiffLeftToRightItem);
            handlerService.registerAction((IAction)copyLeftToRight, "org.eclipse.compare.copyLeftToRight");
        }
        if (cc.isLeftEditable()) {
            Action copyRightToLeft = new Action(){

                public void run() {
                    EMFCompareTextMergeViewer.this.copyDiff(false);
                    EMFCompareTextMergeViewer.this.navigate(true);
                }
            };
            Utilities.initAction((IAction)copyRightToLeft, (ResourceBundle)this.getResourceBundle(), (String)"action.CopyDiffRightToLeft.");
            this.fCopyDiffRightToLeftItem = new ActionContributionItem((IAction)copyRightToLeft);
            this.fCopyDiffRightToLeftItem.setVisible(true);
            toolBarManager.appendToGroup("merge", (IContributionItem)this.fCopyDiffRightToLeftItem);
            handlerService.registerAction((IAction)copyRightToLeft, "org.eclipse.compare.copyRightToLeft");
        }
        Action nextDiff = new Action(){

            public void run() {
                EMFCompareTextMergeViewer.this.endOfContentReached(true);
            }
        };
        Utilities.initAction((IAction)nextDiff, (ResourceBundle)this.getResourceBundle(), (String)"action.NextDiff.");
        ActionContributionItem contributionNextDiff = new ActionContributionItem((IAction)nextDiff);
        contributionNextDiff.setVisible(true);
        toolBarManager.appendToGroup("navigation", (IContributionItem)contributionNextDiff);
        Action previousDiff = new Action(){

            public void run() {
                EMFCompareTextMergeViewer.this.endOfContentReached(false);
            }
        };
        Utilities.initAction((IAction)previousDiff, (ResourceBundle)this.getResourceBundle(), (String)"action.PrevDiff.");
        ActionContributionItem contributionPreviousDiff = new ActionContributionItem((IAction)previousDiff);
        contributionPreviousDiff.setVisible(true);
        toolBarManager.appendToGroup("navigation", (IContributionItem)contributionPreviousDiff);
    }

    protected void endOfContentReached(boolean next) {
        ICompareNavigator navigator;
        Control control = this.getControl();
        if (control != null && !control.isDisposed() && (navigator = this.getCompareConfiguration().getContainer().getNavigator()) instanceof CompareNavigator && ((CompareNavigator)navigator).hasChange(next)) {
            navigator.selectChange(next);
        }
    }

    protected void navigate(boolean next) {
        ICompareNavigator navigator;
        Control control = this.getControl();
        if (control != null && !control.isDisposed() && (navigator = this.getCompareConfiguration().getContainer().getNavigator()) instanceof CompareNavigator && ((CompareNavigator)navigator).hasChange(next)) {
            navigator.selectChange(next);
        }
    }

    protected ResourceBundle getResourceBundle() {
        return ResourceBundle.getBundle(BUNDLE_NAME);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UpdateModelAndRejectDiffCommand
    extends ChangeCommand
    implements ICompareCopyCommand {
        private boolean isLeft;
        private Diff difference;
        private Object value;
        private EStructuralFeature feature;
        private EObject owner;

        public UpdateModelAndRejectDiffCommand(ChangeRecorder changeRecorder, EObject owner, EStructuralFeature feature, Object value, Diff difference, boolean isLeft) {
            super(changeRecorder, (Collection)ImmutableSet.builder().add((Object)owner).addAll(UpdateModelAndRejectDiffCommand.getAffectedDiff(difference)).build());
            this.owner = owner;
            this.feature = feature;
            this.value = value;
            this.difference = difference;
            this.isLeft = isLeft;
        }

        public void doExecute() {
            this.owner.eSet(this.feature, this.value);
            for (Diff affectedDiff : UpdateModelAndRejectDiffCommand.getAffectedDiff(this.difference)) {
                affectedDiff.setState(DifferenceState.DISCARDED);
            }
        }

        private static Set<Diff> getAffectedDiff(Diff diff) {
            EList conflicts = diff.getMatch().getComparison().getConflicts();
            for (Conflict conflict : conflicts) {
                EList conflictualDifferences = conflict.getDifferences();
                if (!conflictualDifferences.contains((Object)diff)) continue;
                return ImmutableSet.copyOf((Collection)conflictualDifferences);
            }
            return ImmutableSet.of((Object)diff);
        }

        public boolean isLeftToRight() {
            return !this.isLeft;
        }
    }
}

