/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.provider.spec;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.provider.AdapterFactoryUtil;
import org.eclipse.emf.compare.provider.IItemDescriptionProvider;
import org.eclipse.emf.compare.provider.IItemStyledLabelProvider;
import org.eclipse.emf.compare.provider.ResourceAttachmentChangeItemProvider;
import org.eclipse.emf.compare.provider.spec.OverlayImageProvider;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceAttachmentChangeItemProviderSpec
extends ResourceAttachmentChangeItemProvider
implements IItemStyledLabelProvider,
IItemDescriptionProvider {
    private final OverlayImageProvider overlayProvider = new OverlayImageProvider(this.getResourceLocator());

    public ResourceAttachmentChangeItemProviderSpec(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public Collection<?> getChildren(Object object) {
        EObject value;
        Collection superChildren = super.getChildren(object);
        ArrayList ret = Lists.newArrayList((Iterable)superChildren);
        ResourceAttachmentChange resourceAttachmentChange = (ResourceAttachmentChange)object;
        switch (resourceAttachmentChange.getSource()) {
            case LEFT: {
                value = resourceAttachmentChange.getMatch().getLeft();
                break;
            }
            case RIGHT: {
                value = resourceAttachmentChange.getMatch().getRight();
                break;
            }
            default: {
                Object value2 = null;
                throw new IllegalStateException();
            }
        }
        Match matchOfValue = resourceAttachmentChange.getMatch().getComparison().getMatch(value);
        if (matchOfValue != null) {
            Collection<?> children = this.getChildren(matchOfValue);
            children.remove(resourceAttachmentChange);
            ret.addAll(children);
        }
        return ImmutableList.copyOf((Collection)ret);
    }

    private Collection<?> getChildren(Match matchOfValue) {
        Object children;
        ITreeItemContentProvider matchItemContentProvider = (ITreeItemContentProvider)this.adapterFactory.adapt((Notifier)matchOfValue, ITreeItemContentProvider.class);
        if (matchItemContentProvider != null) {
            Collection itemProviderChildren = matchItemContentProvider.getChildren((Object)matchOfValue);
            children = itemProviderChildren instanceof ImmutableCollection ? Lists.newArrayList((Iterable)itemProviderChildren) : itemProviderChildren;
            Iterator childrenIterator = children.iterator();
            while (childrenIterator.hasNext()) {
                Object child = childrenIterator.next();
                if (!(child instanceof Match) || matchItemContentProvider.hasChildren(child)) continue;
                childrenIterator.remove();
            }
        } else {
            children = ImmutableList.of();
        }
        return children;
    }

    @Override
    public Object getImage(Object object) {
        Match match = ((ResourceAttachmentChange)object).getMatch();
        Object ret = AdapterFactoryUtil.getImage(this.getRootAdapterFactory(), match.getLeft());
        if (ret == null) {
            ret = AdapterFactoryUtil.getImage(this.getRootAdapterFactory(), match.getRight());
        }
        if (ret == null) {
            ret = AdapterFactoryUtil.getImage(this.getRootAdapterFactory(), match.getOrigin());
        }
        if (ret == null) {
            ret = super.getImage(object);
        }
        Object matchImage = this.overlayProvider.getComposedImage((Diff)((ResourceAttachmentChange)object), ret);
        ret = this.overlayImage(object, matchImage);
        return ret;
    }

    @Override
    public String getText(Object object) {
        return this.getStyledText(object).getString();
    }

    @Override
    public IStyledString.IComposedStyledString getStyledText(Object object) {
        Match match = ((ResourceAttachmentChange)object).getMatch();
        String value = AdapterFactoryUtil.getText(this.getRootAdapterFactory(), match.getLeft());
        if (value == null) {
            value = AdapterFactoryUtil.getText(this.getRootAdapterFactory(), match.getRight());
        }
        if (value == null) {
            value = AdapterFactoryUtil.getText(this.getRootAdapterFactory(), match.getOrigin());
        }
        if (value == null) {
            value = super.getText(object);
        }
        ComposedStyledString ret = new ComposedStyledString(value);
        DifferenceKind labelValue = ((ResourceAttachmentChange)object).getKind();
        String label = labelValue == null ? "" : labelValue.toString().toLowerCase();
        return ret.append(" [resource contents " + label + "]", IStyledString.Style.DECORATIONS_STYLER);
    }

    @Override
    public String getDescription(Object object) {
        ResourceAttachmentChange rac = (ResourceAttachmentChange)object;
        Match match = rac.getMatch();
        String ret = AdapterFactoryUtil.getText(this.getRootAdapterFactory(), match.getLeft());
        if (ret == null) {
            ret = AdapterFactoryUtil.getText(this.getRootAdapterFactory(), match.getRight());
        }
        if (ret == null) {
            ret = AdapterFactoryUtil.getText(this.getRootAdapterFactory(), match.getOrigin());
        }
        if (ret == null) {
            ret = super.getText(object);
        }
        String remotely = "";
        if (rac.getSource() == DifferenceSource.RIGHT) {
            remotely = "remotely ";
        }
        DifferenceKind labelValue = rac.getKind();
        switch (labelValue) {
            case ADD: {
                ret = String.valueOf(ret) + " has been " + remotely + "added to resource contents";
                break;
            }
            case DELETE: {
                ret = String.valueOf(ret) + " has been " + remotely + "deleted from resource contents";
                break;
            }
            case MOVE: {
                ret = String.valueOf(ret) + " has been " + remotely + "moved in resource contents";
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported " + DifferenceKind.class.getSimpleName() + " value: " + rac.getKind());
            }
        }
        return ret;
    }
}

