/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.eobject.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.match.eobject.EObjectIndex;
import org.eclipse.emf.compare.match.eobject.ProximityEObjectMatcher;
import org.eclipse.emf.compare.match.eobject.ScopeQuery;
import org.eclipse.emf.compare.match.eobject.internal.ProximityMatchStats;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProximityIndex
implements EObjectIndex {
    private ProximityEObjectMatcher.DistanceFunction meter;
    private List<EObject> lefts;
    private List<EObject> rights;
    private List<EObject> origins;
    private ScopeQuery scope;
    private ProximityMatchStats stats = new ProximityMatchStats();

    public ProximityIndex(ProximityEObjectMatcher.DistanceFunction meter, ScopeQuery matcher) {
        this.meter = meter;
        this.lefts = Lists.newArrayList();
        this.rights = Lists.newArrayList();
        this.origins = Lists.newArrayList();
        this.scope = matcher;
    }

    @Override
    public Map<EObjectIndex.Side, EObject> findClosests(Comparison inProgress, EObject eObj, EObjectIndex.Side passedObjectSide) {
        if (!this.readyForThisTest(inProgress, eObj)) {
            return null;
        }
        HashMap<EObjectIndex.Side, EObject> result = new HashMap<EObjectIndex.Side, EObject>(3);
        result.put(passedObjectSide, eObj);
        if (passedObjectSide == EObjectIndex.Side.LEFT) {
            EObject closestRight = this.findTheClosest(inProgress, eObj, EObjectIndex.Side.LEFT, EObjectIndex.Side.RIGHT, true);
            EObject closestOrigin = this.findTheClosest(inProgress, eObj, EObjectIndex.Side.LEFT, EObjectIndex.Side.ORIGIN, true);
            result.put(EObjectIndex.Side.RIGHT, closestRight);
            result.put(EObjectIndex.Side.ORIGIN, closestOrigin);
        } else if (passedObjectSide == EObjectIndex.Side.RIGHT) {
            EObject closestLeft = this.findTheClosest(inProgress, eObj, EObjectIndex.Side.RIGHT, EObjectIndex.Side.LEFT, true);
            EObject closestOrigin = this.findTheClosest(inProgress, eObj, EObjectIndex.Side.RIGHT, EObjectIndex.Side.ORIGIN, true);
            result.put(EObjectIndex.Side.LEFT, closestLeft);
            result.put(EObjectIndex.Side.ORIGIN, closestOrigin);
        } else if (passedObjectSide == EObjectIndex.Side.ORIGIN) {
            EObject closestLeft = this.findTheClosest(inProgress, eObj, EObjectIndex.Side.ORIGIN, EObjectIndex.Side.LEFT, true);
            EObject closestRight = this.findTheClosest(inProgress, eObj, EObjectIndex.Side.ORIGIN, EObjectIndex.Side.RIGHT, true);
            result.put(EObjectIndex.Side.LEFT, closestLeft);
            result.put(EObjectIndex.Side.RIGHT, closestRight);
        }
        return result;
    }

    private EObject findTheClosest(Comparison inProgress, EObject eObj, EObjectIndex.Side originalSide, EObjectIndex.Side sideToFind, boolean shouldDoubleCheck) {
        List<EObject> storageToSearchFor = this.lefts;
        switch (sideToFind) {
            case RIGHT: {
                storageToSearchFor = this.rights;
                break;
            }
            case LEFT: {
                storageToSearchFor = this.lefts;
                break;
            }
            case ORIGIN: {
                storageToSearchFor = this.origins;
                break;
            }
        }
        Candidate best = this.findIdenticMatch(inProgress, eObj, storageToSearchFor);
        if (best.some()) {
            return best.eObject;
        }
        TreeMap candidates = Maps.newTreeMap();
        Iterator<EObject> it = storageToSearchFor.iterator();
        while (best.distance != 0.0 && it.hasNext()) {
            EObject potentialClosest = it.next();
            double dist = this.meter.distance(inProgress, eObj, potentialClosest);
            this.stats.similarityCompare();
            if (!(dist < best.distance)) continue;
            if (shouldDoubleCheck) {
                candidates.put(dist, potentialClosest);
                continue;
            }
            best.distance = dist;
            best.eObject = potentialClosest;
        }
        if (shouldDoubleCheck) {
            for (Map.Entry entry : candidates.entrySet()) {
                EObject doubleCheck = this.findTheClosest(inProgress, (EObject)entry.getValue(), sideToFind, originalSide, false);
                this.stats.doubleCheck();
                if (doubleCheck == eObj) {
                    this.stats.similaritySuccess();
                    best.eObject = (EObject)entry.getValue();
                    best.distance = (Double)entry.getKey();
                    break;
                }
                this.stats.failedDoubleCheck();
            }
        }
        if (!best.some()) {
            this.stats.noMatch();
        }
        return best.eObject;
    }

    private Candidate findIdenticMatch(Comparison inProgress, EObject eObj, List<EObject> candidates) {
        Iterator<EObject> it = candidates.iterator();
        Candidate best = new Candidate();
        while (it.hasNext() && !best.some()) {
            EObject fastCheck = it.next();
            if (!this.readyForThisTest(inProgress, fastCheck)) {
                this.stats.backtrack();
                continue;
            }
            this.stats.identicCompare();
            if (!this.meter.areIdentic(inProgress, eObj, fastCheck)) continue;
            this.stats.identicSuccess();
            best.eObject = fastCheck;
            best.distance = 0.0;
        }
        return best;
    }

    private boolean readyForThisTest(Comparison inProgress, EObject fastCheck) {
        if (fastCheck.eContainer() != null && this.scope.isInScope(fastCheck.eContainer())) {
            return inProgress.getMatch(fastCheck.eContainer()) != null;
        }
        return true;
    }

    @Override
    public void remove(EObject obj, EObjectIndex.Side side) {
        switch (side) {
            case RIGHT: {
                this.rights.remove(obj);
                break;
            }
            case LEFT: {
                this.lefts.remove(obj);
                break;
            }
            case ORIGIN: {
                this.origins.remove(obj);
                break;
            }
        }
    }

    @Override
    public void index(EObject eObject, EObjectIndex.Side side) {
        switch (side) {
            case RIGHT: {
                this.rights.add(eObject);
                break;
            }
            case LEFT: {
                this.lefts.add(eObject);
                break;
            }
            case ORIGIN: {
                this.origins.add(eObject);
                break;
            }
        }
    }

    public Collection<EObject> getValuesStillThere(EObjectIndex.Side side) {
        ImmutableList result = Collections.emptyList();
        switch (side) {
            case RIGHT: {
                result = ImmutableList.copyOf(this.rights);
                break;
            }
            case LEFT: {
                result = ImmutableList.copyOf(this.lefts);
                break;
            }
            case ORIGIN: {
                result = ImmutableList.copyOf(this.origins);
                break;
            }
        }
        return result;
    }

    private static class Candidate {
        protected EObject eObject;
        protected double distance = Double.MAX_VALUE;

        private Candidate() {
        }

        public boolean some() {
            return this.eObject != null;
        }
    }
}

