/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.EventDispatcher;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.compare.diagram.ide.ui.internal.AbstractGraphicalMergeViewer;
import org.eclipse.emf.compare.diagram.ide.ui.internal.accessor.IDiagramDiffAccessor;
import org.eclipse.emf.compare.diagram.ide.ui.internal.accessor.IDiagramNodeAccessor;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.IMergeViewer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.SelectionManager;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.ui.parts.DomainEventDispatcher;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.EditPartService;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

class DiagramMergeViewer
extends AbstractGraphicalMergeViewer {
    private static final double ZOOM_FACTOR = 1.0;
    private DiagramGraphicalViewerForCompare fGraphicalViewer;
    private Diagram currentDiag;
    private DiagramEditDomain editDomain;

    public DiagramMergeViewer(Composite parent, IMergeViewer.MergeViewerSide side) {
        super(parent, side);
        ((FigureCanvas)this.fGraphicalViewer.getControl()).getLightweightSystem().setEventDispatcher((EventDispatcher)new NonEditingEventDispatcher((EditDomain)this.editDomain, (EditPartViewer)this.fGraphicalViewer));
    }

    public Control createControl(Composite parent) {
        this.editDomain = new DiagramEditDomain(null);
        this.editDomain.setCommandStack((CommandStack)new DiagramCommandStack((IDiagramEditDomain)this.editDomain));
        this.createDiagramGraphicalViewer(parent);
        return this.fGraphicalViewer.getControl();
    }

    private void createDiagramGraphicalViewer(Composite composite) {
        this.fGraphicalViewer = new DiagramGraphicalViewerForCompare();
        this.fGraphicalViewer.createControl(composite);
        this.fGraphicalViewer.setEditDomain((EditDomain)this.editDomain);
        this.fGraphicalViewer.setEditPartFactory((EditPartFactory)EditPartService.getInstance());
        this.fGraphicalViewer.getControl().setBackground(ColorConstants.listBackground);
        this.fGraphicalViewer.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)262144), MouseWheelZoomHandler.SINGLETON);
        this.fGraphicalViewer.setSelectionManager(new NonEditingManager());
    }

    public DiagramGraphicalViewerForCompare getGraphicalViewer() {
        return this.fGraphicalViewer;
    }

    public void setInput(Object input) {
        if (input instanceof IDiagramNodeAccessor) {
            Diagram diagram = ((IDiagramNodeAccessor)input).getOwnedDiagram();
            this.initEditingDomain(diagram);
            EditPart editPart = null;
            View view = ((IDiagramNodeAccessor)input).getOwnedView();
            if (view != null) {
                editPart = this.getEditPart((EObject)view);
            }
            this.fGraphicalViewer.deselectAll();
            if (!(input instanceof IDiagramDiffAccessor) && editPart != null) {
                while (editPart != null && !editPart.isSelectable()) {
                    editPart = editPart.getParent();
                }
                if (editPart != null) {
                    this.setSelection((ISelection)new StructuredSelection((Object)editPart));
                    this.fGraphicalViewer.reveal(editPart);
                }
            }
        }
    }

    private void initEditingDomain(Diagram diagram) {
        ResourceSet resourceSet = null;
        if (diagram != null) {
            resourceSet = diagram.eResource().getResourceSet();
        }
        if (resourceSet != null && TransactionalEditingDomain.Factory.INSTANCE.getEditingDomain(resourceSet) == null) {
            TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain(resourceSet);
        }
    }

    public EditPart getEditPart(EObject view) {
        EditPart editPart = (EditPart)this.fGraphicalViewer.getEditPartRegistry().get(view);
        if (editPart == null) {
            Diagram diagram = null;
            if (view instanceof Diagram) {
                diagram = (Diagram)view;
            } else if (view instanceof View) {
                diagram = ((View)view).getDiagram();
            }
            if (diagram != null && !diagram.equals(this.currentDiag)) {
                this.currentDiag = diagram;
                this.fGraphicalViewer.getEditPartRegistry().clear();
                DiagramRootEditPart rootEditPart = new DiagramRootEditPart(diagram.getMeasurementUnit());
                this.fGraphicalViewer.setRootEditPart((RootEditPart)rootEditPart);
                this.fGraphicalViewer.setContents(diagram);
                rootEditPart.getZoomManager().setZoomAnimationStyle(0);
                rootEditPart.getZoomManager().setZoom(1.0);
            }
        }
        return (EditPart)this.fGraphicalViewer.getEditPartRegistry().get(view);
    }

    public void refresh() {
    }

    public class DiagramGraphicalViewerForCompare
    extends DiagramGraphicalViewer {
        public void reveal(IFigure figure) {
            IFigure target = figure;
            Viewport port = this.getFigureCanvas().getViewport();
            Rectangle exposeRegion = target.getBounds().getCopy();
            target = target.getParent();
            while (target != null && target != port) {
                target.translateToParent((Translatable)exposeRegion);
                target = target.getParent();
            }
            exposeRegion.expand(5, 5);
            Dimension viewportSize = port.getClientArea().getSize();
            Point topLeft = exposeRegion.getTopLeft();
            Point bottomRight = exposeRegion.getBottomRight().translate(viewportSize.getNegated());
            Point finalLocation = new Point();
            finalLocation.x = viewportSize.width < exposeRegion.width ? Math.min(bottomRight.x, Math.max(topLeft.x, port.getViewLocation().x)) : Math.min(topLeft.x, Math.max(bottomRight.x, port.getViewLocation().x));
            finalLocation.y = viewportSize.height < exposeRegion.height ? Math.min(bottomRight.y, Math.max(topLeft.y, port.getViewLocation().y)) : Math.min(topLeft.y, Math.max(bottomRight.y, port.getViewLocation().y));
            this.getFigureCanvas().scrollSmoothTo(finalLocation.x, finalLocation.y);
        }

        protected DomainEventDispatcher getEventDispatcher() {
            return new NonEditingEventDispatcher((EditDomain)DiagramMergeViewer.this.editDomain, (EditPartViewer)this);
        }
    }

    protected class NonEditingEventDispatcher
    extends DomainEventDispatcher {
        public NonEditingEventDispatcher(EditDomain d, EditPartViewer v) {
            super(d, v);
        }

        public void dispatchMousePressed(MouseEvent me) {
        }

        public void dispatchMouseReleased(MouseEvent me) {
        }

        public void dispatchMouseDoubleClicked(MouseEvent me) {
        }

        public void dispatchMouseHover(MouseEvent me) {
        }

        public void dispatchMouseMoved(MouseEvent me) {
        }
    }

    protected class NonEditingManager
    extends SelectionManager {
        protected NonEditingManager() {
        }

        public void appendSelection(EditPart editpart) {
        }
    }
}

