/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.emf.compare.rcp.extension.AbstractRegistryEventListener;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.IDifferenceGroupProvider;

public class DifferenceGroupProviderExtensionRegistryListener
extends AbstractRegistryEventListener {
    static final String TAG_GROUP_PROVIDER = "group";
    static final String ATT_CLASS = "class";
    static final String ATT_LABEL = "label";
    static final String ATT_ACTIVE = "activeByDefault";
    private final IDifferenceGroupProvider.Registry groupProviderRegistry;

    public DifferenceGroupProviderExtensionRegistryListener(String pluginID, String extensionPointID, ILog log, IDifferenceGroupProvider.Registry groupProviderRegistry) {
        super(pluginID, extensionPointID, log);
        this.groupProviderRegistry = groupProviderRegistry;
    }

    protected boolean validateExtensionElement(IConfigurationElement element) {
        boolean valid;
        if (element.getName().equals(TAG_GROUP_PROVIDER)) {
            if (element.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(element, ATT_CLASS);
                valid = false;
            } else if (element.getAttribute(ATT_LABEL) == null) {
                this.logMissingAttribute(element, ATT_LABEL);
                valid = false;
            } else if (element.getAttribute(ATT_ACTIVE) == null) {
                this.logMissingAttribute(element, ATT_ACTIVE);
                valid = false;
            } else {
                valid = true;
            }
        } else {
            valid = false;
        }
        return valid;
    }

    protected boolean addedValid(IConfigurationElement element) {
        try {
            IDifferenceGroupProvider provider = (IDifferenceGroupProvider)element.createExecutableExtension(ATT_CLASS);
            provider.setLabel(element.getAttribute(ATT_LABEL));
            if (Boolean.valueOf(element.getAttribute(ATT_ACTIVE)).booleanValue()) {
                provider.setDefaultSelected(true);
            } else {
                provider.setDefaultSelected(false);
            }
            IDifferenceGroupProvider previous = this.groupProviderRegistry.add(provider);
            if (previous != null) {
                this.log(2, element, "The group provider '" + provider.getClass().getName() + "' is registered twice.");
            }
        }
        catch (CoreException e) {
            this.log(element, e);
            return false;
        }
        return true;
    }

    protected boolean removedValid(IConfigurationElement element) {
        this.groupProviderRegistry.remove(element.getAttribute(ATT_CLASS));
        return true;
    }
}

