/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.provider.spec;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.provider.ForwardingItemProvider;
import org.eclipse.emf.compare.provider.spec.Strings;
import org.eclipse.emf.compare.uml2.UMLDiff;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForwardingUMLDiffItemProvider
extends ForwardingItemProvider {
    public ForwardingUMLDiffItemProvider(ItemProviderAdapter delegate) {
        super(delegate);
    }

    public Collection<?> getChildren(Object object) {
        UMLDiff umlDiff = (UMLDiff)object;
        Object ret = umlDiff.getKind() == DifferenceKind.CHANGE ? umlDiff.getRefinedBy() : super.getChildren(object);
        return ret;
    }

    public boolean hasChildren(Object object) {
        return !this.getChildren(object).isEmpty();
    }

    public String getText(Object object) {
        UMLDiff umlDiff = (UMLDiff)object;
        String remotely = "";
        if (umlDiff.getSource() == DifferenceSource.RIGHT) {
            remotely = "remotely ";
        }
        String valueText = this.getValueText(umlDiff);
        String referenceText = this.getReferenceText(umlDiff);
        String ret = "";
        switch (umlDiff.getKind()) {
            case ADD: {
                ret = String.valueOf(valueText) + " has been " + remotely + "added to " + referenceText;
                break;
            }
            case DELETE: {
                ret = String.valueOf(valueText) + " has been " + remotely + "deleted from " + referenceText;
                break;
            }
            case CHANGE: {
                ret = String.valueOf(valueText) + " has been " + remotely + "changed";
                break;
            }
            case MOVE: {
                ret = String.valueOf(valueText) + " has been " + remotely + "moved in " + referenceText;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported " + DifferenceKind.class.getSimpleName() + " value: " + umlDiff.getKind());
            }
        }
        return ret;
    }

    private EObject findNonNullSide(Match match) {
        EObject side = match.getLeft() != null ? match.getLeft() : (match.getRight() != null ? match.getRight() : match.getOrigin());
        return side;
    }

    public Object getImage(Object object) {
        UMLDiff umlDiff = (UMLDiff)object;
        Object image = ForwardingUMLDiffItemProvider.getImage(this.getRootAdapterFactory(), umlDiff.getDiscriminant());
        return image;
    }

    private String getValueText(UMLDiff umlDiff) {
        String value = ForwardingUMLDiffItemProvider.getText(this.getRootAdapterFactory(), umlDiff.getDiscriminant());
        value = value == null ? "<null>" : Strings.elide((String)value, (int)50, (String)"...");
        return value;
    }

    private String getReferenceText(UMLDiff umlDiff) {
        String ret = "";
        switch (umlDiff.getKind()) {
            case ADD: 
            case DELETE: 
            case MOVE: {
                EObject discriminant = umlDiff.getDiscriminant();
                ret = discriminant.eContainingFeature().getName();
                break;
            }
            case CHANGE: {
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported " + DifferenceKind.class.getSimpleName() + " value: " + umlDiff.getKind());
            }
        }
        return ret;
    }

    static String getText(AdapterFactory adapterFactory, Object object) {
        Object adapter;
        Preconditions.checkNotNull((Object)adapterFactory);
        if (object != null && (adapter = adapterFactory.adapt(object, IItemLabelProvider.class)) instanceof IItemLabelProvider) {
            return ((IItemLabelProvider)adapter).getText(object);
        }
        return null;
    }

    static Object getImage(AdapterFactory adapterFactory, Object object) {
        Object adapter;
        Preconditions.checkNotNull((Object)adapterFactory);
        if (object != null && (adapter = adapterFactory.adapt(object, IItemLabelProvider.class)) instanceof IItemLabelProvider) {
            return ((IItemLabelProvider)adapter).getImage(object);
        }
        return null;
    }

    public Object getForeground(Object object) {
        UMLDiff referenceChange = (UMLDiff)object;
        switch (referenceChange.getState()) {
            case MERGED: 
            case DISCARDED: {
                return URI.createURI((String)"color://rgb/156/156/156");
            }
        }
        return super.getForeground(object);
    }
}

