/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.actions.filter;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ide.ui.internal.actions.filter.DifferenceFilter;
import org.eclipse.emf.compare.ide.ui.internal.actions.filter.FilterAction;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class FilterActionMenu
extends Action
implements IMenuCreator {
    private final DifferenceFilter differenceFilter;
    private MenuManager menuManager = new MenuManager();

    public FilterActionMenu(DifferenceFilter differenceFilter) {
        super("", 4);
        this.differenceFilter = differenceFilter;
        this.setMenuCreator(this);
        this.setToolTipText("Filters");
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/filter.gif"));
        this.createActions(this.menuManager);
    }

    public void createActions(MenuManager menu) {
        menu.add((IAction)FilterAction.fromDiffPredicate("Changed Elements", (Predicate<? super Diff>)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE), this.differenceFilter));
        menu.add((IAction)FilterAction.fromDiffPredicate("Added Elements", (Predicate<? super Diff>)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), this.differenceFilter));
        menu.add((IAction)FilterAction.fromDiffPredicate("Removed Elements", (Predicate<? super Diff>)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), this.differenceFilter));
        menu.add((IAction)FilterAction.fromDiffPredicate("Moved Elements", (Predicate<? super Diff>)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), this.differenceFilter));
        FilterAction matchResourceFilter = new FilterAction("Resource Mappings", (Predicate<? super EObject>)Predicates.instanceOf(MatchResource.class), this.differenceFilter);
        matchResourceFilter.setChecked(true);
        matchResourceFilter.run();
        menu.add((IAction)matchResourceFilter);
    }

    public void dispose() {
        this.menuManager.dispose();
    }

    public Menu getMenu(Control parent) {
        return this.menuManager.createContextMenu(parent);
    }

    public Menu getMenu(Menu parent) {
        return this.menuManager.getMenu();
    }
}

