/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.spec;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.impl.ResourceAttachmentChangeImpl;
import org.eclipse.emf.compare.utils.DiffUtil;
import org.eclipse.emf.compare.utils.EMFCompareCopier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.XMIResource;

public class ResourceAttachmentChangeSpec
extends ResourceAttachmentChangeImpl {
    public void copyLeftToRight() {
        if (this.getState() != DifferenceState.UNRESOLVED) {
            return;
        }
        this.setState(DifferenceState.MERGED);
        if (this.getEquivalence() != null) {
            for (Diff equivalent : this.getEquivalence().getDifferences()) {
                equivalent.setState(DifferenceState.MERGED);
            }
        }
        if (this.getSource() == DifferenceSource.LEFT) {
            this.mergeRequires(false);
            switch (this.getKind()) {
                case ADD: {
                    this.addInTarget(false);
                    break;
                }
                case DELETE: {
                    this.removeFromTarget(false);
                    break;
                }
            }
        } else {
            this.mergeRequiredBy(false);
            switch (this.getKind()) {
                case ADD: {
                    this.removeFromTarget(false);
                    break;
                }
                case DELETE: {
                    this.addInTarget(false);
                    break;
                }
            }
        }
    }

    public void copyRightToLeft() {
        if (this.getState() != DifferenceState.UNRESOLVED) {
            return;
        }
        this.setState(DifferenceState.MERGED);
        if (this.getEquivalence() != null) {
            for (Diff equivalent : this.getEquivalence().getDifferences()) {
                equivalent.setState(DifferenceState.MERGED);
            }
        }
        if (this.getSource() == DifferenceSource.LEFT) {
            this.mergeRequiredBy(true);
            switch (this.getKind()) {
                case ADD: {
                    this.removeFromTarget(true);
                    break;
                }
                case DELETE: {
                    this.addInTarget(true);
                    break;
                }
            }
        } else {
            this.mergeRequires(true);
            switch (this.getKind()) {
                case ADD: {
                    this.addInTarget(true);
                    break;
                }
                case DELETE: {
                    this.removeFromTarget(true);
                    break;
                }
            }
        }
    }

    public void discard() {
        this.setState(DifferenceState.DISCARDED);
    }

    protected void mergeRequiredBy(boolean rightToLeft) {
        for (Diff dependency : this.getRequiredBy()) {
            if (rightToLeft) {
                dependency.copyRightToLeft();
                continue;
            }
            dependency.copyLeftToRight();
        }
    }

    protected void mergeRequires(boolean rightToLeft) {
        for (Diff dependency : this.getRequires()) {
            if (rightToLeft) {
                dependency.copyRightToLeft();
                continue;
            }
            dependency.copyLeftToRight();
        }
    }

    protected void addInTarget(boolean rightToLeft) {
        EObject expectedValue;
        Comparison comparison = this.getMatch().getComparison();
        Resource expectedContainer = this.findOrCreateTargetResource(rightToLeft);
        EObject sourceValue = rightToLeft ? this.getMatch().getRight() : this.getMatch().getLeft();
        Match valueMatch = this.getMatch();
        if (rightToLeft) {
            expectedValue = this.createTarget(sourceValue);
            valueMatch.setLeft(expectedValue);
        } else {
            expectedValue = this.createTarget(sourceValue);
            valueMatch.setRight(expectedValue);
        }
        Resource initialResource = sourceValue.eResource();
        EList sourceList = initialResource.getContents();
        EList targetList = expectedContainer.getContents();
        int insertionIndex = DiffUtil.findInsertionIndex(comparison, sourceList, targetList, expectedValue);
        if (targetList instanceof InternalEList) {
            ((InternalEList)targetList).addUnique(insertionIndex, (Object)expectedValue);
        } else {
            targetList.add(insertionIndex, expectedValue);
        }
        if (initialResource instanceof XMIResource && expectedContainer instanceof XMIResource) {
            ((XMIResource)expectedContainer).setID(expectedValue, ((XMIResource)initialResource).getID(sourceValue));
        }
    }

    private Resource findOrCreateTargetResource(boolean rightToLeft) {
        Resource target;
        Comparison comparison = this.getMatch().getComparison();
        Resource reference = rightToLeft ? this.getMatch().getRight().eResource() : this.getMatch().getLeft().eResource();
        EList<MatchResource> matchedResources = comparison.getMatchedResources();
        int size = matchedResources.size();
        MatchResource soughtMatch = null;
        int i = 0;
        while (i < size && soughtMatch == null) {
            MatchResource matchRes = (MatchResource)matchedResources.get(i);
            if (rightToLeft && matchRes.getRight() == reference) {
                soughtMatch = matchRes;
            } else if (!rightToLeft && matchRes.getLeft() == reference) {
                soughtMatch = matchRes;
            }
            ++i;
        }
        if (soughtMatch == null) {
            throw new RuntimeException("Could not locate resource match for " + reference.getURI().lastSegment());
        }
        if (rightToLeft && soughtMatch.getLeft() != null) {
            target = soughtMatch.getLeft();
        } else if (!rightToLeft && soughtMatch.getRight() != null) {
            target = soughtMatch.getRight();
        } else {
            ResourceSet targetSet = null;
            int i2 = 0;
            while (i2 < size && targetSet == null) {
                MatchResource matchRes = (MatchResource)matchedResources.get(i2);
                if (rightToLeft && matchRes.getLeft() != null) {
                    targetSet = matchRes.getLeft().getResourceSet();
                } else if (!rightToLeft && matchRes.getRight() != null) {
                    targetSet = matchRes.getRight().getResourceSet();
                }
                ++i2;
            }
            if (targetSet == null) {
                throw new RuntimeException("Could not locate resource set to create " + reference.getURI().lastSegment());
            }
            target = targetSet.createResource(reference.getURI());
            if (rightToLeft) {
                soughtMatch.setLeft(target);
            } else {
                soughtMatch.setRight(target);
            }
        }
        return target;
    }

    protected EObject createTarget(EObject referenceObject) {
        EMFCompareCopier copier = new EMFCompareCopier();
        return copier.copy(referenceObject);
    }

    protected void removeFromTarget(boolean rightToLeft) {
        Match valueMatch = this.getMatch();
        EObject expectedValue = rightToLeft ? valueMatch.getLeft() : valueMatch.getRight();
        if (expectedValue != null) {
            EcoreUtil.remove((EObject)expectedValue);
            if (rightToLeft) {
                valueMatch.setLeft(null);
            } else {
                valueMatch.setRight(null);
            }
        }
    }
}

