/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.extension;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.emf.compare.extension.IPostProcessor;
import org.eclipse.emf.compare.extension.PostProcessorDescriptor;
import org.eclipse.emf.compare.scope.IComparisonScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostProcessorRegistry {
    private final List<PostProcessorDescriptor> postProcessors = new CopyOnWriteArrayList<PostProcessorDescriptor>();

    public void addPostProcessor(PostProcessorDescriptor postProcessor) {
        this.postProcessors.add(postProcessor);
    }

    public void clearRegistry() {
        this.postProcessors.clear();
    }

    public List<PostProcessorDescriptor> getRegisteredPostProcessors() {
        return this.postProcessors;
    }

    public void removePostProcessor(String postProcessorClassName) {
        for (PostProcessorDescriptor descriptor : this.getRegisteredPostProcessors()) {
            if (!descriptor.getExtensionClassName().equals(postProcessorClassName)) continue;
            this.postProcessors.remove(descriptor);
        }
    }

    public List<IPostProcessor> getPostProcessors(IComparisonScope scope) {
        ArrayList<IPostProcessor> processors = new ArrayList<IPostProcessor>();
        block0: for (PostProcessorDescriptor descriptor : this.postProcessors) {
            if (descriptor.getNsURI() != null && descriptor.getNsURI().trim().length() != 0) {
                Iterator<String> nsUris = scope.getNsURIs().iterator();
                while (nsUris.hasNext()) {
                    if (!nsUris.next().matches(descriptor.getNsURI())) continue;
                    processors.add(descriptor.getPostProcessor());
                    break;
                }
            }
            if (descriptor.getResourceURI() == null || descriptor.getResourceURI().trim().length() == 0) continue;
            Iterator<String> resourceUris = scope.getResourceURIs().iterator();
            while (resourceUris.hasNext()) {
                if (!resourceUris.next().matches(descriptor.getResourceURI())) continue;
                processors.add(descriptor.getPostProcessor());
                continue block0;
            }
        }
        return processors;
    }
}

