/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTBindingHelper;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.cst.ParameterDeclarationCS;
import org.eclipse.m2m.internal.qvt.oml.cst.TypeSpecCS;
import org.eclipse.m2m.internal.qvt.oml.cst.VariableInitializationCS;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.CSTHelper;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.HyperlinkUtil;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.IHyperlinkDetectorHelper;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.QvtFileHyperlink;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.VarParameter;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.SimpleNameCS;
import org.eclipse.ocl.cst.VariableCS;
import org.eclipse.ocl.cst.VariableExpCS;
import org.eclipse.ocl.ecore.TupleLiteralExp;
import org.eclipse.ocl.ecore.VariableExp;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.utilities.ASTNode;

public class VariableHyperlinkDetector
implements IHyperlinkDetectorHelper {
    public IHyperlink detectHyperlink(IHyperlinkDetectorHelper.IDetectionContext context) {
        EObject eContainer;
        CSTNode syntaxElement = context.getSyntaxElement();
        CSTNode targetCS = null;
        if (syntaxElement instanceof SimpleNameCS) {
            SimpleNameCS nameCS = (SimpleNameCS)context.getSyntaxElement();
            CSTNode varDeclElement = VariableHyperlinkDetector.resolveVariableDeclaration(nameCS);
            if (varDeclElement instanceof ParameterDeclarationCS) {
                ParameterDeclarationCS paramDeclCS = (ParameterDeclarationCS)varDeclElement;
                SimpleNameCS paramNameCS = paramDeclCS.getSimpleNameCS();
                if (paramNameCS != null && paramNameCS.getValue() != null) {
                    targetCS = paramNameCS;
                }
            } else if (varDeclElement instanceof VariableInitializationCS) {
                VariableInitializationCS varDecl = (VariableInitializationCS)varDeclElement;
                SimpleNameCS varName = varDecl.getSimpleNameCS();
                if (varName != null && varName.getValue() != null) {
                    targetCS = varName;
                }
            } else if (varDeclElement instanceof VariableCS) {
                targetCS = varDeclElement;
            }
        } else if (syntaxElement instanceof VariableCS && (eContainer = syntaxElement.eContainer()) instanceof TupleLiteralExp) {
            return null;
        }
        if (targetCS != null) {
            IRegion linkRegion = HyperlinkUtil.createRegion(syntaxElement);
            IRegion targetRegion = HyperlinkUtil.createRegion(targetCS);
            return new QvtFileHyperlink(linkRegion, context.getModule().getSource(), targetRegion, targetRegion);
        }
        return null;
    }

    public static CSTNode resolveVariableDeclaration(SimpleNameCS nameCS) {
        if (nameCS.eContainer() instanceof VariableExpCS) {
            VariableExp variableExp;
            Variable var;
            ASTNode varExpNodeAS = ASTBindingHelper.resolveASTNode((CSTNode)nameCS);
            if (varExpNodeAS instanceof VariableExp && (var = (variableExp = (VariableExp)varExpNodeAS).getReferredVariable()) != null) {
                VarParameter varParam;
                CSTNode paramCS;
                EParameter param;
                if (var.getRepresentedParameter() != null && (param = (EParameter)var.getRepresentedParameter()) instanceof VarParameter && (paramCS = ASTBindingHelper.resolveCSTNode((ASTNode)(varParam = (VarParameter)param))) instanceof ParameterDeclarationCS) {
                    ParameterDeclarationCS paramDeclCS = (ParameterDeclarationCS)paramCS;
                    return paramDeclCS;
                }
                CSTNode cstVarNode = ASTBindingHelper.resolveCSTNode((ASTNode)var);
                if (cstVarNode instanceof VariableInitializationCS) {
                    VariableInitializationCS varDecl = (VariableInitializationCS)cstVarNode;
                    return varDecl;
                }
                if (cstVarNode instanceof VariableCS) {
                    return cstVarNode;
                }
            }
        } else {
            if (nameCS.eContainer() instanceof ParameterDeclarationCS) {
                return (ParameterDeclarationCS)nameCS.eContainer();
            }
            if (nameCS.eContainer() instanceof TypeSpecCS) {
                TypeSpecCS typeSpecCS = (TypeSpecCS)nameCS.eContainer();
                if (nameCS != typeSpecCS.getSimpleNameCS()) {
                    return null;
                }
                ModelParameter modelParam = VariableHyperlinkDetector.getEnv((CSTNode)nameCS).lookupModelParameter(nameCS.getValue(), null);
                if (modelParam != null) {
                    return ASTBindingHelper.resolveCSTNode((ASTNode)modelParam, CSTNode.class);
                }
            }
        }
        return null;
    }

    private static QvtOperationalEnv getEnv(CSTNode node) {
        return (QvtOperationalEnv)CSTHelper.getEnvironment(node);
    }
}

