/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui;

import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;

public class QvtReconciler
extends MonoReconciler {
    private final ITextEditor myEditor;
    private PartListener myPartListener;

    public QvtReconciler(ITextEditor textEditor, IReconcilingStrategy strategy, boolean isIncremental) {
        super(strategy, isIncremental);
        this.myEditor = textEditor;
    }

    public void install(ITextViewer textViewer) {
        super.install(textViewer);
        this.myPartListener = new PartListener();
        IWorkbenchPartSite site = this.myEditor.getSite();
        IWorkbenchWindow window = site.getWorkbenchWindow();
        window.getPartService().addPartListener((IPartListener)this.myPartListener);
    }

    public void uninstall() {
        IWorkbenchPartSite site = this.myEditor.getSite();
        IWorkbenchWindow window = site.getWorkbenchWindow();
        window.getPartService().removePartListener((IPartListener)this.myPartListener);
        this.myPartListener = null;
        super.uninstall();
    }

    private class PartListener
    implements IPartListener {
        private PartListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            if (part == QvtReconciler.this.myEditor) {
                QvtReconciler.this.forceReconciling();
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }
}

