/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtb2qvts;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.CompleteModel;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;

public class InheritanceAnalysis {
    protected final @NonNull EnvironmentFactory environmentFactory;
    protected final @NonNull CompleteModel completeModel;
    private final @NonNull Map<@NonNull CompleteClass, @NonNull Set<@NonNull CompleteClass>> class2allSuperClasses = new HashMap<CompleteClass, Set<CompleteClass>>();
    private final @NonNull Map<@NonNull CompleteClass, @NonNull Set<@NonNull CompleteClass>> class2allSelfAndSubClasses = new HashMap<CompleteClass, Set<CompleteClass>>();

    public InheritanceAnalysis(@NonNull EnvironmentFactory environmentFactory) {
        this.environmentFactory = environmentFactory;
        this.completeModel = environmentFactory.getCompleteModel();
        MetamodelManagerInternal metamodelManager = (MetamodelManagerInternal)environmentFactory.getMetamodelManager();
        metamodelManager.getASmetamodel();
        ResourceSet resourceSet = metamodelManager.getASResourceSet();
        for (Resource resource : ClassUtil.nullFree((EList)resourceSet.getResources())) {
            for (EObject root : resource.getContents()) {
                if (!(root instanceof Model)) continue;
                this.computeCompleteSuperClasses(ClassUtil.nullFree((List)((Model)root).getOwnedPackages()));
            }
        }
        for (CompleteClass completeClass : this.class2allSuperClasses.keySet()) {
            this.computeClass2SubClasses(completeClass);
        }
    }

    private void computeCompleteSuperClasses(@NonNull Iterable<@NonNull Package> asPackages) {
        for (Package asPackage : asPackages) {
            CompletePackage completePackage = this.completeModel.getCompletePackage(asPackage);
            for (CompleteClass completeClass : ClassUtil.nullFree((List)completePackage.getOwnedCompleteClasses())) {
                this.class2allSuperClasses.put(completeClass, Sets.newHashSet((Iterable)completeClass.getProperSuperCompleteClasses()));
                this.class2allSelfAndSubClasses.put(completeClass, Sets.newHashSet((Object[])new CompleteClass[]{completeClass}));
            }
            this.computeCompleteSuperClasses(ClassUtil.nullFree((List)asPackage.getOwnedPackages()));
        }
    }

    private void computeClass2SubClasses(@NonNull CompleteClass completeClass) {
        Set<@NonNull CompleteClass> superCompleteClasses = this.class2allSuperClasses.get(completeClass);
        assert (superCompleteClasses != null);
        for (CompleteClass superCompleteClass : superCompleteClasses) {
            Set<@NonNull CompleteClass> allSelfAndSubClasses = this.class2allSelfAndSubClasses.get(superCompleteClass);
            assert (allSelfAndSubClasses != null);
            allSelfAndSubClasses.add(completeClass);
        }
    }

    public @NonNull Set<@NonNull CompleteClass> getAllCompleteClasses() {
        return this.class2allSuperClasses.keySet();
    }

    public @NonNull Set<@NonNull CompleteClass> getAllSelfAndSubClasses(@NonNull CompleteClass completeClass) {
        Set<@NonNull CompleteClass> allSubClasses = this.class2allSelfAndSubClasses.get(completeClass);
        assert (allSubClasses != null);
        return allSubClasses;
    }

    public @NonNull Set<@NonNull CompleteClass> getAllSuperAndSelfAndSubClasses(@NonNull CompleteClass completeClass) {
        HashSet<@NonNull CompleteClass> result = new HashSet<CompleteClass>();
        Set<@NonNull CompleteClass> allSuperClasses = this.class2allSuperClasses.get(completeClass);
        assert (allSuperClasses != null);
        result.addAll(allSuperClasses);
        Set<@NonNull CompleteClass> allSubClasses = this.class2allSelfAndSubClasses.get(completeClass);
        assert (allSubClasses != null);
        result.addAll(allSubClasses);
        return result;
    }

    public @NonNull EnvironmentFactory getEnvironmentFactory() {
        return this.environmentFactory;
    }
}

