/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.m2m.atl.engine.vm.ASM;
import org.eclipse.m2m.atl.engine.vm.ASMExecEnv;
import org.eclipse.m2m.atl.engine.vm.ASMInterpreterException;
import org.eclipse.m2m.atl.engine.vm.ASMOperation;
import org.eclipse.m2m.atl.engine.vm.ASMParameter;
import org.eclipse.m2m.atl.engine.vm.ASMStackFrame;
import org.eclipse.m2m.atl.engine.vm.ASMTextualWriter;
import org.eclipse.m2m.atl.engine.vm.ASMXMLReader;
import org.eclipse.m2m.atl.engine.vm.ASMXMLWriter;
import org.eclipse.m2m.atl.engine.vm.Debugger;
import org.eclipse.m2m.atl.engine.vm.ModelLoader;
import org.eclipse.m2m.atl.engine.vm.NetworkDebugger;
import org.eclipse.m2m.atl.engine.vm.PluginClassLoader;
import org.eclipse.m2m.atl.engine.vm.SimpleDebugger;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModule;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclUndefined;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;

public class ASMInterpreter {
    protected static Logger logger = Logger.getLogger("org.eclipse.m2m.atl");
    private ASMOclAny returnValue;

    public static void realMain(String[] args, PluginClassLoader pcl) throws Exception {
        String reser;
        String modelLoaderName;
        Map params = ASMInterpreter.parseCommandLine(args);
        String plugins = (String)params.get("plugins");
        if (plugins != null) {
            String[] ss = plugins.split(",");
            Iterator<String> i = Arrays.asList(ss).iterator();
            while (i.hasNext()) {
                String plg = i.next();
                logger.info("Loading plugin: " + plg);
                pcl.addLocation(plg);
            }
        }
        if ((modelLoaderName = (String)params.get("ModelLoader")) == null) {
            modelLoaderName = "MDR";
        }
        ModelLoader ml = null;
        ml = modelLoaderName.equals("MDR") ? (ModelLoader)pcl.loadClass("org.eclipse.m2m.atl.drivers.mdr4atl.MDRModelLoader").newInstance() : (ModelLoader)pcl.loadClass("org.eclipse.m2m.atl.drivers.emf4atl.EMFModelLoader").newInstance();
        System.err.println("ATL 0.2 State Machine Interpreter");
        System.err.println();
        long start = new Date().getTime();
        boolean step = "true".equals(params.get("step"));
        boolean showSummary = "true".equals(params.get("summary"));
        boolean profile = "true".equals(params.get("profile"));
        boolean showStackTrace = params.get("showStackTrace") == null || params.get("step").equals("true");
        List stepops = ASMInterpreter.parseOpList(params.get("stepops"));
        List deepstepops = ASMInterpreter.parseOpList(params.get("deepstepops"));
        List nostepops = ASMInterpreter.parseOpList(params.get("nostepops"));
        List deepnostepops = ASMInterpreter.parseOpList(params.get("deepnostepops"));
        logger.info("Loading the ATL State Machine...");
        ASM asm = new ASMXMLReader().read(new BufferedInputStream(new FileInputStream(((String)params.get("ASM")).split(",")[0])));
        ASMModule asmModule = new ASMModule(asm);
        if ("true".equals(params.get("testReserialization"))) {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter("test.asm")));
            new ASMXMLWriter(out, true).print(asm);
            out.close();
            out = new PrintWriter(new BufferedWriter(new FileWriter("test.nodebug.asm")));
            new ASMXMLWriter(out, false).print(asm);
            out.close();
            out = new PrintWriter(new BufferedWriter(new FileWriter("test.tasm")));
            new ASMTextualWriter(out).print(asm);
            out.close();
        }
        Debugger debugger = null;
        debugger = "true".equals(params.get("NetworkDebugger")) ? new NetworkDebugger(6060, true) : new SimpleDebugger(step, stepops, deepstepops, nostepops, deepnostepops, showStackTrace, showSummary, profile, true);
        ASMExecEnv env = new ASMExecEnv(asmModule, debugger, !"false".equals(params.get("cache")));
        env.addModel(ml.getMOF());
        String ATL = (String)params.get("ATL");
        if (ATL == null) {
            throw new ASMInterpreterException("ERROR: ATL meta-model location not given on command line.");
        }
        env.addModel(ml.loadModel("ATL", env.getModel("MOF"), ATL));
        try {
            ml.addInjector("ebnf", pcl.loadClass("org.atl.engine.injectors.ebnf.EBNFInjector"));
            ml.addInjector("ebnf2", pcl.loadClass("org.atl.engine.injectors.ebnf.EBNFInjector2"));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        try {
            ml.addInjector("bin", pcl.loadClass("org.atl.engine.injectors.bin.BINInjector"));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        try {
            ml.addExtractor("ebnf", pcl.loadClass("org.atl.engine.extractors.ebnf.EBNFExtractor"));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        ASMInterpreter.loadModels(env, params, ml);
        env.registerOperations(asm);
        ASMInterpreter.loadLibraries(env, params, asmModule);
        long startProgram = new Date().getTime();
        ASMInterpreter asmi = new ASMInterpreter(asm, asmModule, env, params);
        long endProgram = new Date().getTime();
        if ("true".equals(params.get("inPlace"))) {
            return;
        }
        ASMInterpreter.saveModels(env, params, ml);
        if (asmi.getReturnValue() != null) {
            String storeResultTo = (String)params.get("storeResultTo");
            if (storeResultTo == null) {
                logger.info("Return value = " + asmi.getReturnValue());
            } else {
                FileWriter out = new FileWriter(storeResultTo);
                ASMOclAny retVal = asmi.getReturnValue();
                if (retVal instanceof ASMString) {
                    out.write(((ASMString)retVal).getSymbol());
                } else {
                    out.write(retVal.toString());
                }
                out.close();
            }
        }
        if ((reser = (String)params.get("reserialize")) != null) {
            logger.info("Reserializing:");
            String[] resers = reser.split(",");
            int i = 0;
            while (i < resers.length) {
                String[] t = resers[i].split("=");
                ASMModel m = env.getModel(t[0]);
                String path = t[1];
                if (path.startsWith("as ")) {
                    path = (String)params.get(path.substring(3));
                }
                logger.info("\t" + m + " to " + path);
                ml.save(m, path);
                ++i;
            }
        }
        System.err.println("End of program execution.");
        long end = new Date().getTime();
        System.err.println("Overall execution took " + (double)(end - start) / 1000.0 + "s.");
        System.err.println("Program execution (exclusing model handler startup, program reading, xmi reading and writing) took " + (double)(endProgram - startProgram) / 1000.0 + "s.");
    }

    public ASMInterpreter(ASM asm, ASMModule asmModule, ASMExecEnv env, Map params) throws Exception {
        ArrayList<ASMOclAny> args = new ArrayList<ASMOclAny>();
        ASMOperation op = asm.getOperation("main");
        args.add(asmModule);
        Iterator i = op.getParameters().iterator();
        while (i.hasNext()) {
            ASMParameter p = (ASMParameter)i.next();
            String pname = p.getName();
            pname = op.resolveVariableName(Integer.parseInt(pname), 0);
            String svalue = (String)params.get(pname);
            ASMOclAny value = new ASMOclUndefined();
            if (svalue != null) {
                value = new ASMString(svalue);
            }
            args.add(value);
        }
        this.returnValue = op.exec(ASMStackFrame.rootFrame(env, op, args));
        env.getDebugger().terminated();
    }

    public ASMOclAny getReturnValue() {
        return this.returnValue;
    }

    private static void loadLibraries(ASMExecEnv env, Map params, ASMModule asmModule) throws Exception {
        String libs = (String)params.get("libs");
        if (libs != null) {
            String[] libsa = libs.split(",");
            int i = 0;
            while (i < libsa.length) {
                ASMInterpreter.loadLibrary(env, libsa[i], (String)params.get(libsa[i]), asmModule);
                ++i;
            }
        }
    }

    private static void loadLibrary(ASMExecEnv env, String name, String fileName, ASMModule asmModule) throws Exception {
        logger.info("Loading library " + name + " from " + fileName + ".");
        ASM lib = new ASMXMLReader().read(new BufferedInputStream(new FileInputStream(fileName)));
        env.registerOperations(lib);
        ASMOperation op = lib.getOperation("main");
        if (op != null) {
            op.exec(ASMStackFrame.rootFrame(env, op, Arrays.asList(asmModule)));
        }
    }

    private static void loadModels(ASMExecEnv env, Map params, ModelLoader ml) throws Exception {
        List hashModels = ASMInterpreter.parseOpList(params.get("HashModels"));
        String models = (String)params.get("preload");
        if (models != null) {
            ASMInterpreter.loadModels(env, models, params, false, hashModels, ml);
        }
        if ((models = (String)params.get("source-models")) != null) {
            ASMInterpreter.loadModels(env, models, params, false, hashModels, ml);
        }
        if ((models = (String)params.get("target-models")) != null) {
            ASMInterpreter.loadModels(env, models, params, true, hashModels, ml);
        }
    }

    private static void loadModels(ASMExecEnv env, String models, Map params, boolean isTarget, List hashModels, ModelLoader ml) throws Exception {
        Iterator<String> i = Arrays.asList(models.split(",")).iterator();
        while (i.hasNext()) {
            String model = i.next();
            String[] mAndMm = model.split(":");
            ASMInterpreter.loadModel(env, mAndMm, params, isTarget, ml);
        }
    }

    private static String getURL(Map params, String name) {
        String ret = (String)params.get(name);
        String[] parts = ret.split(",");
        ret = parts[parts.length - 1];
        return ret;
    }

    private static void loadModel(ASMExecEnv env, String[] mAndMm, Map params, boolean isTarget, ModelLoader ml) throws Exception {
        ASMModel m = env.getModel(mAndMm[0]);
        if (m == null) {
            String url;
            ASMModel mm = env.getModel(mAndMm[1]);
            if (mm == null) {
                url = ASMInterpreter.getURL(params, mAndMm[1]);
                logger.info("Loading meta-model " + mAndMm[1] + " from \"" + url + "\".");
                env.addModel(ml.loadModel(mAndMm[1], env.getModel("MOF"), url));
            }
            if (isTarget) {
                url = ASMInterpreter.getURL(params, mAndMm[0]);
                logger.info("Creating model " + mAndMm[0] + " : " + mAndMm[1]);
                env.addModel(ml.newModel(mAndMm[0], url, env.getModel(mAndMm[1])));
            } else {
                url = ASMInterpreter.getURL(params, mAndMm[0]);
                logger.info("Loading model " + mAndMm[0] + " : " + mAndMm[1] + " from \"" + url + "\".");
                env.addModel(ml.loadModel(mAndMm[0], env.getModel(mAndMm[1]), (String)params.get(mAndMm[0])));
            }
        }
    }

    private static void saveModels(ASMExecEnv env, Map params, ModelLoader ml) throws Exception {
        String models = (String)params.get("target-models");
        if (models != null) {
            Iterator<String> i = Arrays.asList(models.split(",")).iterator();
            while (i.hasNext()) {
                String model = i.next();
                String[] mAndMm = model.split(":");
                ASMModel m = env.getModel(mAndMm[0]);
                String url = ASMInterpreter.getURL(params, mAndMm[0]);
                logger.info("Saving model " + mAndMm[0] + " : " + mAndMm[1] + " to \"" + url + "\".");
                ml.save(m, (String)params.get(mAndMm[0]));
            }
        }
    }

    private static Map parseCommandLine(String[] args) throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        int i = 0;
        while (i < args.length) {
            if (args[i].matches("^[^=]*=.*$")) {
                String[] p = args[i].split("=");
                String s = "";
                int j = 1;
                while (j < p.length) {
                    s = String.valueOf(s) + (j != 1 ? "=" : "") + p[j];
                    ++j;
                }
                if (parameters.containsKey(p[0])) {
                    parameters.put(p[0], parameters.get(p[0]) + "," + s);
                } else {
                    parameters.put(p[0], s);
                }
            } else if (new File(args[i]).isFile()) {
                parameters.put("ATLInstance", args[i]);
            }
            ++i;
        }
        return parameters;
    }

    private static List parseOpList(Object s) {
        List<Object> ret = null;
        ret = s == null ? new ArrayList() : Arrays.asList(((String)s).split(","));
        return ret;
    }
}

