/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.am3.tools.tge.outline;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.atl.engine.injectors.ebnf.EBNFInjector2;
import org.eclipse.am3.core.JarClassLoader;
import org.eclipse.am3.tools.tge.editor.TextualGenericEditor;
import org.eclipse.am3.tools.tge.outline.DocumentOffsetCount;
import org.eclipse.am3.tools.tge.outline.LanguageElementMap;
import org.eclipse.am3.tools.tge.outline.NodeLabel;
import org.eclipse.am3.tools.tge.outline.OutlineNode;
import org.eclipse.am3.tools.tge.outline.TextualGenericEditorContentOutlinePage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.m2m.atl.drivers.emf4atl.ASMEMFModel;
import org.eclipse.m2m.atl.engine.AtlModelHandler;
import org.eclipse.m2m.atl.engine.MarkerMaker;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

public class OutlineContent {
    private DocumentOffsetCount help;
    private AtlModelHandler amh = AtlModelHandler.getDefault((String)"EMF");
    private ASMModel metamodel;
    private ASMModel model;
    private HashMap languageElementMapping;
    private TextualGenericEditorContentOutlinePage outline;
    private TextualGenericEditor editor;

    public OutlineContent(DocumentOffsetCount help, TextualGenericEditorContentOutlinePage outline, TextualGenericEditor editor) {
        this.help = help;
        this.outline = outline;
        this.editor = editor;
    }

    public void init() {
        try {
            this.createNodesAssociation();
            File fileMetamodel = new File(this.outline.getLanguageMetamodelUri());
            this.metamodel = this.amh.loadModel(this.outline.getLanguageMetamodelName(), this.amh.getMof(), (InputStream)new FileInputStream(fileMetamodel));
        }
        catch (IOException e) {
            System.err.println("Error during metamodel loading");
            e.printStackTrace();
        }
    }

    private void createNodesAssociation() {
        this.languageElementMapping = new HashMap();
        Set elements = this.outline.getOutlineHandler().getElementsByType("Outline");
        Iterator outline = elements.iterator();
        if (outline.hasNext()) {
            EObject outlineDesc = (EObject)outline.next();
            TreeIterator nodes = outlineDesc.eAllContents();
            while (nodes.hasNext()) {
                EObject node = (EObject)nodes.next();
                if (!node.eClass().getName().equals("Node")) continue;
                EStructuralFeature sf = node.eClass().getEStructuralFeature("name");
                LinkedList node_label = this.getLabel(node);
                sf = node.eClass().getEStructuralFeature("icon");
                String node_icon = (String)node.eGet(sf);
                OutlineNode mapNode = new OutlineNode(node_label, node_icon);
                this.createLanguageElementMapping(node, mapNode);
            }
        }
    }

    private LinkedList getLabel(EObject node) {
        LinkedList<NodeLabel> listLabel = new LinkedList<NodeLabel>();
        EList list = node.eContents();
        int i = 0;
        while (i < list.size()) {
            EObject eoLabel = (EObject)list.get(i);
            if (eoLabel.eClass().getName().equals("Label")) {
                NodeLabel nodeLabel = this.getLabelString(eoLabel);
                if (nodeLabel != null) {
                    listLabel.add(nodeLabel);
                }
                EList listLabelSuit = eoLabel.eContents();
                int j = 0;
                while (j < listLabelSuit.size()) {
                    EObject eoLabelSuite = (EObject)listLabelSuit.get(j);
                    if (eoLabelSuite.eClass().getName().equals("LabelSuite") && (nodeLabel = this.getLabelString(eoLabelSuite)) != null) {
                        listLabel.add(nodeLabel);
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        return listLabel;
    }

    private NodeLabel getLabelString(EObject eo) {
        EStructuralFeature sf = eo.eClass().getEStructuralFeature("label");
        String value = (String)eo.eGet(sf);
        if (value != null) {
            return new NodeLabel("label", value);
        }
        sf = eo.eClass().getEStructuralFeature("methodCall");
        value = (String)eo.eGet(sf);
        if (value != null) {
            return new NodeLabel("methodCall", value);
        }
        return null;
    }

    private void createLanguageElementMapping(EObject eo, OutlineNode node) {
        EList children = eo.eContents();
        if (!children.isEmpty()) {
            int i = 0;
            while (i < children.size()) {
                String languageModelElement;
                EObject eobject = (EObject)children.get(i);
                if (eobject.eClass().getName().equals("Map") && (languageModelElement = (String)eobject.eGet(eobject.eClass().getEStructuralFeature("mapString"))) != null) {
                    LanguageElementMap nodeStruct = new LanguageElementMap(node);
                    this.languageElementMapping.put(languageModelElement, nodeStruct);
                }
                ++i;
            }
        }
    }

    public OutlineNode languageParser(IEditorInput editorInput) {
        OutlineNode noderoot = new OutlineNode("root");
        try {
            JarClassLoader jcl = this.createLoader(this.outline.getEBNFInjectorUri());
            IFile file = ((IFileEditorInput)editorInput).getFile();
            InputStream in = file.getContents();
            ASMModel model = this.amh.newModel("model", file.getLocationURI().toString(), this.metamodel);
            HashMap hyperlinks = new HashMap();
            ASMModel pbmm = this.amh.getBuiltInMetaModel("Problem");
            ASMModel pbs = this.amh.newModel("pbs", "pbs", pbmm);
            String packageName = "org.atl.engine.injectors.ebnf.";
            String classNamePrefix = this.outline.getClassNamePrefix();
            int antlrVersion = this.outline.getAntlrVersion();
            if (antlrVersion == 3) {
                classNamePrefix = String.valueOf(classNamePrefix) + "_ANTLR3";
            }
            String lexerClassName = String.valueOf(packageName) + classNamePrefix + "Lexer";
            String parserClassName = String.valueOf(packageName) + classNamePrefix + "Parser";
            Class lexer = null;
            try {
                lexer = Class.forName(lexerClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {}
            if (lexer == null) {
                lexer = jcl.loadClass2(lexerClassName, true);
            }
            Class parser = null;
            try {
                parser = Class.forName(parserClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {}
            if (parser == null) {
                parser = jcl.loadClass2(parserClassName, true);
            }
            EBNFInjector2 ebnfi = new EBNFInjector2();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("name", classNamePrefix);
            params.put("lexerClass", lexer);
            params.put("parserClass", parser);
            params.put("problems", pbs);
            params.put("parserGenerator", "antlr" + antlrVersion);
            params.put("hyperlinks", hyperlinks);
            ebnfi.inject(model, in, params);
            in.close();
            new MarkerMaker().applyMarkers(file, pbs, 1);
            this.editor.getSourceViewerConfig().setHyperlinks(hyperlinks, this.help, this.editor);
            EList modelContent = ((ASMEMFModel)model).getExtent().getContents();
            int i = 0;
            while (i < modelContent.size()) {
                OutlineNode child = this.listChildren((EObject)modelContent.get(i));
                if (child != null) {
                    noderoot.addChild(child);
                }
                ++i;
            }
        }
        catch (IOException e) {
            return this.outline.createErrorOutline("Error during the creation of outline (IOException: " + e.getMessage() + ")");
        }
        catch (ClassNotFoundException e) {
            return this.outline.createErrorOutline("Error during the creation of outline (class not found: " + e.getMessage() + ")");
        }
        catch (CoreException e) {
            return this.outline.createErrorOutline("Error during the creation of outline (CoreException " + e.getMessage() + ")");
        }
        return noderoot;
    }

    private JarClassLoader createLoader(String uriJar) {
        try {
            return new JarClassLoader(new URL[]{new File(uriJar).toURL()}, Thread.currentThread().getContextClassLoader());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private OutlineNode listChildren(EObject eo) {
        Object map = this.languageElementMapping.get(eo.eClass().getName());
        OutlineNode node = map instanceof LanguageElementMap ? ((LanguageElementMap)map).getNode(eo, this.help) : null;
        EList children = eo.eContents();
        if (!children.isEmpty()) {
            int i = 0;
            while (i < children.size()) {
                OutlineNode child = this.listChildren((EObject)children.get(i));
                if (child != null && node != null) {
                    node.addChild(child);
                }
                ++i;
            }
        }
        return node;
    }

    public ASMModel getMetamodel() {
        return this.metamodel;
    }

    public ASMModel getModel() {
        return this.model;
    }
}

