/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.am3.ui.action;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.eclipse.am3.core.AM3CorePlugin;
import org.eclipse.am3.core.AM3CoreTools;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.m2m.atl.engine.AtlModelHandler;
import org.eclipse.m2m.atl.engine.injectors.xml.XMLInjector;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;

public class ActionXMLInjector
extends Action {
    private AtlModelHandler amh;
    private IFile inFile;
    private String mmUri;
    private String mmName;
    private String modelHandler;

    public ActionXMLInjector(String text, IFile file, EObject metamodel, String modelHandler) {
        super(text);
        this.inFile = file;
        this.modelHandler = modelHandler;
        this.mmUri = (String)AM3CorePlugin.getDefault().getHandler().get(metamodel, "uri");
        this.mmName = (String)AM3CorePlugin.getDefault().getHandler().get(metamodel, "name");
    }

    public void run() {
        this.amh = AtlModelHandler.getDefault((String)this.modelHandler);
        try {
            InputStream in = this.inFile.getContents();
            ASMModel mm = AM3CoreTools.loadMetamodel((AtlModelHandler)this.amh, (String)this.mmName, (String)this.mmUri);
            ASMModel model = this.amh.newModel(this.inFile.getName(), this.inFile.getLocationURI().toString(), mm);
            XMLInjector xmli = new XMLInjector();
            Map parameters = Collections.EMPTY_MAP;
            xmli.inject(model, in, parameters);
            if (model != null) {
                String name = this.inFile.getFullPath().removeFirstSegments(1).toString();
                String extension = this.modelHandler.equals("EMF") ? "ecore" : "xmi";
                name = String.valueOf(name.substring(0, name.length() - 4)) + "-" + this.mmName + "." + extension;
                this.amh.saveModel(model, name, this.inFile.getProject());
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

