/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.drivers.emf4atl;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.m2m.atl.drivers.emf4atl.ASMEMFModel;
import org.eclipse.m2m.atl.engine.vm.ModelLoader;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;

public class EMFModelLoader
extends ModelLoader {
    private ASMModel mofmm = ASMEMFModel.createMOF(this);
    private boolean useIDs = false;
    private boolean removeIDs = false;
    private String encoding = "ISO-8859-1";

    public ASMModel getMOF() {
        return this.mofmm;
    }

    public ASMModel loadModel(String name, ASMModel metamodel, InputStream in) {
        ASMEMFModel ret = null;
        try {
            ret = ASMEMFModel.loadASMEMFModel(name, (ASMEMFModel)metamodel, in, (ModelLoader)this);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return ret;
    }

    protected ASMModel realLoadModel(String name, ASMModel metamodel, String href) {
        ASMEMFModel ret = null;
        try {
            ret = ASMEMFModel.loadASMEMFModel(name, (ASMEMFModel)metamodel, href, (ModelLoader)this);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return ret;
    }

    public ASMModel newModel(String name, ASMModel metamodel) {
        ASMEMFModel ret = null;
        try {
            ret = ASMEMFModel.newASMEMFModel(name, (ASMEMFModel)metamodel, this);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return ret;
    }

    public ASMModel newModel(String name, String uri, ASMModel metamodel) {
        ASMEMFModel ret = null;
        try {
            ret = ASMEMFModel.newASMEMFModel(name, uri, (ASMEMFModel)metamodel, this);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return ret;
    }

    protected void setParameter(String name, Object value) {
        if ("useIDs".equals(name)) {
            if ("true".equals(value)) {
                this.useIDs = true;
            } else if ("true".equals(value)) {
                this.useIDs = false;
            }
        } else if ("removeIDs".equals(name)) {
            if ("true".equals(value)) {
                this.removeIDs = true;
            } else if ("true".equals(value)) {
                this.removeIDs = false;
            }
        } else if ("encoding".equals(name)) {
            this.encoding = (String)value;
        }
    }

    protected void realSave(ASMModel model, String href) {
        Resource r = ((ASMEMFModel)model).getExtent();
        r.setURI(URI.createURI((String)href));
        if (this.useIDs || this.removeIDs) {
            XMIResource xr = (XMIResource)r;
            int id = 1;
            HashSet<EObject> alreadySet = new HashSet<EObject>();
            TreeIterator i = r.getAllContents();
            while (i.hasNext()) {
                EObject eo = (EObject)i.next();
                if (alreadySet.contains(eo)) continue;
                xr.setID(eo, this.removeIDs ? null : "a" + id++);
                alreadySet.add(eo);
            }
        }
        try {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("ENCODING", this.encoding);
            r.save(options);
        }
        catch (IOException e1) {
            logger.log(Level.SEVERE, e1.getLocalizedMessage(), e1);
        }
    }
}

