/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.tck.spi;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.AbstractStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.QuietRuntimeException;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.ReactiveStreamsSpiVerification;
import org.reactivestreams.Publisher;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FromCompletionStageNullableVerification
extends AbstractStageVerification {
    FromCompletionStageNullableVerification(ReactiveStreamsSpiVerification.VerificationDeps deps) {
        super(deps);
    }

    @Test
    public void fromCsNullableStageShouldEmitAnElementWhenAlreadyRedeemed() {
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.fromCompletionStageNullable(CompletableFuture.completedFuture(10)).toList().run(this.getEngine()))), Collections.singletonList(10));
    }

    @Test
    public void fromCsNullableStageShouldEmitAnElementWhenRedeemedLater() throws InterruptedException {
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        CompletionStage result = this.rs.fromCompletionStageNullable(future).toList().run(this.getEngine());
        Thread.sleep(100L);
        Assert.assertFalse((boolean)result.toCompletableFuture().isDone());
        future.complete(10);
        Assert.assertEquals((Collection)((Collection)this.await(result)), Collections.singletonList(10));
    }

    @Test
    public void fromCsNullableStageShouldBeEmptyWhenAlreadyRedeemedWithNull() {
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.fromCompletionStageNullable(CompletableFuture.completedFuture(null)).toList().run(this.getEngine()))), Collections.emptyList());
    }

    @Test
    public void fromCsNullableStageShouldBeEmptyWhenRedeemedWithNullLater() throws InterruptedException {
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        CompletionStage result = this.rs.fromCompletionStageNullable(future).toList().run(this.getEngine());
        Thread.sleep(100L);
        Assert.assertFalse((boolean)result.toCompletableFuture().isDone());
        future.complete(null);
        Assert.assertEquals((Collection)((Collection)this.await(result)), Collections.emptyList());
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void fromCsNullableStageShouldPropagateAlreadyRedeemedExceptions() {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(new QuietRuntimeException("failed"));
        this.await(this.rs.fromCompletionStageNullable(future).toList().run(this.getEngine()));
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void fromCsNullableStageShouldPropagateExceptionsWhenFailedLater() throws InterruptedException {
        CompletableFuture future = new CompletableFuture();
        CompletionStage result = this.rs.fromCompletionStageNullable(future).toList().run(this.getEngine());
        Thread.sleep(100L);
        Assert.assertFalse((boolean)result.toCompletableFuture().isDone());
        future.completeExceptionally(new QuietRuntimeException("failed"));
        this.await(result);
    }

    @Test
    public void fromCsNullableStageShouldBeReusable() {
        PublisherBuilder publisher = this.rs.fromCompletionStageNullable(CompletableFuture.completedFuture(10));
        Assert.assertEquals((Collection)((Collection)this.await(publisher.toList().run(this.getEngine()))), Collections.singletonList(10));
        Assert.assertEquals((Collection)((Collection)this.await(publisher.toList().run(this.getEngine()))), Collections.singletonList(10));
    }

    @Override
    List<Object> reactiveStreamsTckVerifiers() {
        return Collections.singletonList(new PublisherVerification());
    }

    public class PublisherVerification
    extends AbstractStageVerification.StagePublisherVerification<String> {
        public Publisher<String> createPublisher(long elements) {
            return FromCompletionStageNullableVerification.this.rs.fromCompletionStageNullable(CompletableFuture.completedFuture(elements == 0L ? null : "value")).buildRs(FromCompletionStageNullableVerification.this.getEngine());
        }

        public long maxElementsFromPublisher() {
            return 1L;
        }
    }
}

