/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.tck.spi;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.AbstractStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.QuietRuntimeException;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.ReactiveStreamsSpiVerification;
import org.reactivestreams.Subscriber;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FindFirstStageVerification
extends AbstractStageVerification {
    FindFirstStageVerification(ReactiveStreamsSpiVerification.VerificationDeps deps) {
        super(deps);
    }

    @Test
    public void findFirstStageShouldFindTheFirstElement() {
        Assert.assertEquals(this.await(this.rs.of((Object[])new Integer[]{1, 2, 3}).findFirst().run(this.getEngine())), Optional.of(1));
    }

    @Test
    public void findFirstStageShouldFindTheFirstElementInSingleElementStream() {
        Assert.assertEquals(this.await(this.rs.of((Object)1).findFirst().run(this.getEngine())), Optional.of(1));
    }

    @Test
    public void findFirstStageShouldReturnEmptyForEmptyStream() {
        Assert.assertEquals(this.await(this.rs.of(new Object[0]).findFirst().run(this.getEngine())), Optional.empty());
    }

    @Test
    public void findFirstStageShouldCancelUpstream() {
        CompletableFuture cancelled = new CompletableFuture();
        Assert.assertEquals(this.await(this.infiniteStream().onTerminate(() -> cancelled.complete(null)).findFirst().run(this.getEngine())), Optional.of(1));
        this.await(cancelled);
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void findFirstStageShouldPropagateErrors() {
        this.await(this.rs.failed((Throwable)new QuietRuntimeException("failed")).findFirst().run(this.getEngine()));
    }

    @Test
    public void findFirstStageShouldBeReusable() {
        Assert.assertEquals(this.await(this.rs.of((Object[])new Integer[]{1, 2, 3}).findFirst().run(this.getEngine())), Optional.of(1));
    }

    @Override
    List<Object> reactiveStreamsTckVerifiers() {
        return Collections.singletonList(new SubscriberVerification());
    }

    class SubscriberVerification
    extends AbstractStageVerification.StageSubscriberBlackboxVerification<Integer> {
        SubscriberVerification() {
            super(FindFirstStageVerification.this);
        }

        public Subscriber<Integer> createSubscriber() {
            return FindFirstStageVerification.this.rs.builder().findFirst().build(FindFirstStageVerification.this.getEngine());
        }

        public Integer createElement(int element) {
            return element;
        }
    }
}

