/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.messaging.tck.channel.overflow;

import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.OnOverflow;
import org.eclipse.microprofile.reactive.messaging.Outgoing;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;

@ApplicationScoped
public class BeanUsingBufferOverflowStrategy {
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    @Inject
    @Channel(value="hello")
    @OnOverflow(value=OnOverflow.Strategy.BUFFER, bufferSize=300L)
    private Emitter<String> emitter;
    private final List<String> output = new CopyOnWriteArrayList<String>();
    private final List<String> accepted = new CopyOnWriteArrayList<String>();
    private final List<String> rejected = new CopyOnWriteArrayList<String>();
    private volatile Throwable downstreamFailure;

    @PreDestroy
    public void terminate() {
        this.executor.shutdown();
    }

    public List<String> output() {
        return this.output;
    }

    public Throwable failure() {
        return this.downstreamFailure;
    }

    public List<String> accepted() {
        return this.accepted;
    }

    public List<String> rejected() {
        return this.rejected;
    }

    public void tryEmitThree() {
        for (int i = 0; i < 3; ++i) {
            this.tryEmit(Integer.toString(i));
        }
    }

    public void tryEmitThousand() {
        for (int i = 0; i < 1000; ++i) {
            this.tryEmit(Integer.toString(i));
        }
    }

    private void tryEmit(String item) {
        try {
            this.emitter.send((Object)item);
            this.accepted.add(item);
        }
        catch (IllegalStateException e) {
            this.rejected.add(item);
        }
    }

    @Incoming(value="hello")
    @Outgoing(value="out")
    public PublisherBuilder<String> consume(PublisherBuilder<String> values) {
        return values.via(ReactiveStreams.builder().flatMapCompletionStage(s -> CompletableFuture.supplyAsync(() -> {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
            return s;
        }, this.executor))).onError(err -> {
            this.downstreamFailure = err;
        });
    }

    @Incoming(value="out")
    public void out(String s) {
        this.output.add(s);
    }
}

