/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.config;

import jakarta.enterprise.context.ApplicationScoped;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.microprofile.fault.tolerance.tck.config.TestConfigExceptionA;
import org.eclipse.microprofile.fault.tolerance.tck.config.TestConfigExceptionB;
import org.eclipse.microprofile.fault.tolerance.tck.util.TestException;
import org.eclipse.microprofile.faulttolerance.Retry;

@ApplicationScoped
public class RetryConfigBean {
    private long lastStartTime = 0L;

    @Retry(delay=0L, jitter=0L)
    public void serviceMaxRetries(AtomicInteger counter) {
        counter.getAndIncrement();
        throw new TestException();
    }

    @Retry(maxDuration=10000L, durationUnit=ChronoUnit.MILLIS, maxRetries=10000, delay=200L, jitter=0L)
    public void serviceMaxDuration() {
        throw new TestException();
    }

    @Retry(maxRetries=5, delay=2L, delayUnit=ChronoUnit.SECONDS, jitter=0L)
    public void serviceDelay() {
        throw new TestException();
    }

    @Retry(maxRetries=1, delay=0L, jitter=0L)
    public void serviceRetryOn(RuntimeException e, AtomicInteger counter) {
        counter.getAndIncrement();
        throw e;
    }

    @Retry(retryOn={TestConfigExceptionA.class, TestConfigExceptionB.class}, abortOn={RuntimeException.class}, maxRetries=1, delay=0L, jitter=0L)
    public void serviceAbortOn(RuntimeException e, AtomicInteger counter) {
        counter.getAndIncrement();
        throw e;
    }

    @Retry(abortOn={TestConfigExceptionA.class}, delay=0L, jitter=0L, maxRetries=1000, maxDuration=10L, durationUnit=ChronoUnit.SECONDS)
    public void serviceJitter() {
        Duration delay;
        long startTime = System.nanoTime();
        if (this.lastStartTime != 0L && (delay = Duration.ofNanos(startTime - this.lastStartTime)).compareTo(Duration.ofMillis(100L)) > 0) {
            throw new TestConfigExceptionA();
        }
        this.lastStartTime = startTime;
        throw new TestException();
    }
}

