/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;

public enum TelemetryMetricDefinition {
    INVOCATIONS("ft.invocations.total", MetricType.COUNTER, InvocationResult.class, InvocationFallback.class),
    RETRY_CALLS("ft.retry.calls.total", MetricType.COUNTER, RetryRetried.class, RetryResult.class),
    RETRY_RETRIES("ft.retry.retries.total", MetricType.COUNTER, new Class[0]),
    TIMEOUT_CALLS("ft.timeout.calls.total", MetricType.COUNTER, TimeoutTimedOut.class),
    TIMEOUT_EXECUTION_DURATION("ft.timeout.executionDuration", MetricType.HISTOGRAM, "nanoseconds", new Class[0]),
    CIRCUITBREAKER_CALLS("ft.circuitbreaker.calls.total", MetricType.COUNTER, CircuitBreakerResult.class),
    CIRCUITBREAKER_STATE("ft.circuitbreaker.state.total", MetricType.COUNTER, "nanoseconds", CircuitBreakerState.class),
    CIRCUITBREAKER_OPENED("ft.circuitbreaker.opened.total", MetricType.COUNTER, new Class[0]),
    BULKHEAD_CALLS("ft.bulkhead.calls.total", MetricType.COUNTER, BulkheadResult.class),
    BULKHEAD_EXECUTIONS_RUNNING("ft.bulkhead.executionsRunning", MetricType.GAUGE, new Class[0]),
    BULKHEAD_EXECUTIONS_WAITING("ft.bulkhead.executionsWaiting", MetricType.GAUGE, new Class[0]),
    BULKHEAD_RUNNING_DURATION("ft.bulkhead.runningDuration", MetricType.HISTOGRAM, "nanoseconds", new Class[0]),
    BULKHEAD_WAITING_DURATION("ft.bulkhead.waitingDuration", MetricType.HISTOGRAM, "nanoseconds", new Class[0]);

    private String name;
    private String unit;
    private MetricType metricType;
    private Class<? extends AttributeValue>[] getAttributeClasses;

    @SafeVarargs
    private TelemetryMetricDefinition(String name, MetricType metricType, String unit, Class<? extends AttributeValue> ... tagClasses) {
        this.name = name;
        this.unit = unit;
        this.metricType = metricType;
        this.getAttributeClasses = tagClasses;
    }

    @SafeVarargs
    private TelemetryMetricDefinition(String name, MetricType metricType, Class<? extends AttributeValue> ... tagClasses) {
        this(name, metricType, (String)null, tagClasses);
    }

    public String getName() {
        return this.name;
    }

    public String getUnit() {
        return this.unit;
    }

    public MetricType getMetricType() {
        return this.metricType;
    }

    public Class<? extends AttributeValue>[] getAttributeClasses() {
        return this.getAttributeClasses;
    }

    public static enum MetricType {
        COUNTER,
        GAUGE,
        HISTOGRAM;

    }

    public static enum InvocationResult implements AttributeValue
    {
        VALUE_RETURNED("valueReturned"),
        EXCEPTION_THROWN("exceptionThrown");

        private Attributes attribute;

        private InvocationResult(String attributeValue) {
            AttributeKey key = AttributeKey.stringKey((String)"result");
            this.attribute = Attributes.builder().put(key, (Object)attributeValue).build();
        }

        @Override
        public Attributes getAttribute() {
            return this.attribute;
        }
    }

    public static enum InvocationFallback implements AttributeValue
    {
        APPLIED("applied"),
        NOT_APPLIED("notApplied"),
        NOT_DEFINED("notDefined");

        private Attributes attribute;

        private InvocationFallback(String attributeValue) {
            AttributeKey key = AttributeKey.stringKey((String)"fallback");
            this.attribute = Attributes.builder().put(key, (Object)attributeValue).build();
        }

        @Override
        public Attributes getAttribute() {
            return this.attribute;
        }
    }

    public static enum RetryRetried implements AttributeValue
    {
        TRUE("true"),
        FALSE("false");

        private Attributes attribute;

        private RetryRetried(String attributeValue) {
            AttributeKey key = AttributeKey.stringKey((String)"retried");
            this.attribute = Attributes.builder().put(key, (Object)attributeValue).build();
        }

        @Override
        public Attributes getAttribute() {
            return this.attribute;
        }
    }

    public static enum RetryResult implements AttributeValue
    {
        VALUE_RETURNED("valueReturned"),
        EXCEPTION_NOT_RETRYABLE("exceptionNotRetryable"),
        MAX_RETRIES_REACHED("maxRetriesReached"),
        MAX_DURATION_REACHED("maxDurationReached");

        private Attributes attribute;

        private RetryResult(String attributeValue) {
            AttributeKey key = AttributeKey.stringKey((String)"retryResult");
            this.attribute = Attributes.builder().put(key, (Object)attributeValue).build();
        }

        @Override
        public Attributes getAttribute() {
            return this.attribute;
        }
    }

    public static enum TimeoutTimedOut implements AttributeValue
    {
        TRUE("true"),
        FALSE("false");

        private Attributes attribute;

        private TimeoutTimedOut(String attributeValue) {
            AttributeKey key = AttributeKey.stringKey((String)"timedOut");
            this.attribute = Attributes.builder().put(key, (Object)attributeValue).build();
        }

        @Override
        public Attributes getAttribute() {
            return this.attribute;
        }
    }

    public static enum CircuitBreakerResult implements AttributeValue
    {
        SUCCESS("success"),
        FAILURE("failure"),
        CIRCUIT_BREAKER_OPEN("circuitBreakerOpen");

        private Attributes attribute;

        private CircuitBreakerResult(String attributeValue) {
            AttributeKey key = AttributeKey.stringKey((String)"circuitBreakerResult");
            this.attribute = Attributes.builder().put(key, (Object)attributeValue).build();
        }

        @Override
        public Attributes getAttribute() {
            return this.attribute;
        }
    }

    public static enum CircuitBreakerState implements AttributeValue
    {
        OPEN("open"),
        CLOSED("closed"),
        HALF_OPEN("halfOpen");

        private Attributes attribute;

        private CircuitBreakerState(String attributeValue) {
            AttributeKey key = AttributeKey.stringKey((String)"state");
            this.attribute = Attributes.builder().put(key, (Object)attributeValue).build();
        }

        @Override
        public Attributes getAttribute() {
            return this.attribute;
        }
    }

    public static enum BulkheadResult implements AttributeValue
    {
        ACCEPTED("accepted"),
        REJECTED("rejected");

        private Attributes attributes;

        private BulkheadResult(String attributeValue) {
            AttributeKey key = AttributeKey.stringKey((String)"bulkheadResult");
            this.attributes = Attributes.builder().put(key, (Object)attributeValue).build();
        }

        @Override
        public Attributes getAttribute() {
            return this.attributes;
        }
    }

    public static interface AttributeValue {
        public Attributes getAttribute();
    }
}

