/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.clientserver;

import jakarta.enterprise.context.RequestScoped;
import java.io.Serializable;
import java.sql.Connection;
import org.eclipse.microprofile.fault.tolerance.tck.util.TestException;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Retry;

@RequestScoped
@CircuitBreaker(successThreshold=2, requestVolumeThreshold=4, failureRatio=0.75, delay=50000L)
@Retry(retryOn={RuntimeException.class}, maxRetries=7)
public class CircuitBreakerClassLevelClientWithRetry
implements Serializable {
    private int counterForInvokingServiceA = 0;
    private int counterForInvokingServiceB = 0;

    public int getCounterForInvokingServiceA() {
        return this.counterForInvokingServiceA;
    }

    public int getCounterForInvokingServiceB() {
        return this.counterForInvokingServiceB;
    }

    public Connection serviceA() {
        Connection conn = null;
        ++this.counterForInvokingServiceA;
        conn = this.connectionService();
        return conn;
    }

    @CircuitBreaker(successThreshold=2, requestVolumeThreshold=4, failureRatio=0.75, delay=50000L)
    @Retry(retryOn={RuntimeException.class}, maxRetries=2)
    public Connection serviceB() {
        Connection conn = null;
        ++this.counterForInvokingServiceB;
        conn = this.connectionService();
        return conn;
    }

    private Connection connectionService() {
        throw new TestException("Connection failed");
    }
}

