/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.config.tck.profile;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class DevConfigProfileTest
extends Arquillian {
    @Deployment
    public static WebArchive deployment() {
        WebArchive war = (WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"DevConfigProfileTest.war")).addClasses(new Class[]{DevConfigProfileTest.class, ProfilePropertyBean.class})).addAsResource((Asset)new StringAsset("mp.config.profile=dev\n%dev.vehicle.name=bike\n%prod.vehicle.name=bus\n%test.vehicle.name=van\nvehicle.name=car"), "META-INF/microprofile-config.properties")).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return war;
    }

    @Test
    public void testConfigProfileWithDev() {
        ProfilePropertyBean bean = (ProfilePropertyBean)CDI.current().select(ProfilePropertyBean.class, new Annotation[0]).get();
        MatcherAssert.assertThat((Object)bean.getConfigProperty(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"bike")));
        MatcherAssert.assertThat((Object)((String)ConfigProvider.getConfig().getValue("vehicle.name", String.class)), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"bike")));
    }

    @Dependent
    public static class ProfilePropertyBean {
        @Inject
        @ConfigProperty(name="vehicle.name")
        private String vehicleName;

        public String getConfigProperty() {
            return this.vehicleName;
        }
    }
}

