/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Map;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.mandas.docker.client.messages.ImmutableRegistryConfigs;
import org.mandas.docker.client.messages.RegistryAuth;

@Value.Immutable
public interface RegistryConfigs {
    public static RegistryConfigs empty() {
        return RegistryConfigs.builder().build();
    }

    public Map<String, RegistryAuth> configs();

    @JsonCreator
    public static RegistryConfigs create(Map<String, RegistryAuth> configs) {
        if (configs == null) {
            return RegistryConfigs.empty();
        }
        Map<String, RegistryAuth> transformedMap = configs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            RegistryAuth value = (RegistryAuth)entry.getValue();
            if (value == null) {
                return null;
            }
            if (value.serverAddress() == null) {
                return value.toBuilder().serverAddress((String)entry.getKey()).build();
            }
            return value;
        }));
        return RegistryConfigs.builder().configs(transformedMap).build();
    }

    public static Builder builder() {
        return ImmutableRegistryConfigs.builder();
    }

    public static interface Builder {
        public Builder configs(Map<String, ? extends RegistryAuth> var1);

        public Builder addConfig(String var1, RegistryAuth var2);

        public RegistryConfigs build();
    }
}

