/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.linuxtools.docker.ui.Activator;

public class ResourceInfoUtils {
    public static boolean exists(String pathName) {
        IFileInfo info = ResourceInfoUtils.getFileInfo(pathName);
        if (info == null) {
            return false;
        }
        return info.exists();
    }

    public static IFileInfo getFileInfo(String pathName) {
        IFileStore store = ResourceInfoUtils.getFileStore(pathName);
        if (store == null) {
            return null;
        }
        return store.fetchInfo();
    }

    public static IFileInfo getFileInfo(URI location) {
        if (location.getScheme() == null) {
            return null;
        }
        IFileStore store = ResourceInfoUtils.getFileStore(location);
        if (store == null) {
            return null;
        }
        return store.fetchInfo();
    }

    public static IFileStore getFileStore(String string) {
        Path location = new Path(string);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)location);
        if (file != null) {
            return ResourceInfoUtils.getFileStore(file.getLocationURI());
        }
        return ResourceInfoUtils.getFileStore(location.toFile().toURI());
    }

    public static IFileStore getFileStore(URI uri) {
        try {
            return EFS.getStore((URI)uri);
        }
        catch (CoreException e) {
            Activator.log(e);
            return null;
        }
    }
}

