/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.eclipse.kura.wire.WireComponent;
import org.eclipse.kura.wire.WireEnvelope;
import org.eclipse.kura.wire.WireReceiver;
import org.eclipse.kura.wire.WireRecord;
import org.eclipse.kura.wire.WireSupport;
import org.eclipse.kura.wire.graph.Constants;
import org.eclipse.kura.wire.graph.EmitterPort;
import org.eclipse.kura.wire.graph.MultiportWireSupport;
import org.eclipse.kura.wire.graph.Port;
import org.eclipse.kura.wire.graph.ReceiverPort;
import org.osgi.service.wireadmin.Wire;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WireSupportImpl
implements WireSupport,
MultiportWireSupport {
    private static final Logger logger = LoggerFactory.getLogger(WireSupportImpl.class);
    private final List<ReceiverPort> receiverPorts;
    private final List<EmitterPort> emitterPorts;
    private final WireComponent wireComponent;
    private final String servicePid;
    private final String kuraServicePid;
    private final Map<Wire, ReceiverPortImpl> receiverPortByWire;

    WireSupportImpl(WireComponent wireComponent, String servicePid, String kuraServicePid, int inputPortCount, int outputPortCount) {
        Objects.requireNonNull(wireComponent, "Wire component cannot be null");
        Objects.requireNonNull(servicePid, "service pid cannot be null");
        Objects.requireNonNull(kuraServicePid, "kura service pid cannot be null");
        this.servicePid = servicePid;
        this.kuraServicePid = kuraServicePid;
        this.wireComponent = wireComponent;
        if (inputPortCount < 0) {
            throw new IllegalArgumentException("Input port count must be greater or equal than zero");
        }
        if (outputPortCount < 0) {
            throw new IllegalArgumentException("Output port count must be greater or equal than zero");
        }
        this.receiverPorts = new ArrayList<ReceiverPort>(inputPortCount);
        this.emitterPorts = new ArrayList<EmitterPort>(outputPortCount);
        this.receiverPortByWire = new HashMap<Wire, ReceiverPortImpl>();
        int i = 0;
        while (i < inputPortCount) {
            this.receiverPorts.add(new ReceiverPortImpl());
            ++i;
        }
        i = 0;
        while (i < outputPortCount) {
            this.emitterPorts.add(new EmitterPortImpl());
            ++i;
        }
    }

    private void clearReceiverPorts() {
        this.receiverPortByWire.clear();
        for (ReceiverPort port : this.receiverPorts) {
            ((PortImpl)port).connectedWires.clear();
        }
    }

    private void clearEmitterPorts() {
        for (EmitterPort port : this.emitterPorts) {
            ((PortImpl)port).connectedWires.clear();
        }
    }

    public synchronized void consumersConnected(Wire[] wires) {
        this.clearEmitterPorts();
        if (wires == null) {
            return;
        }
        Wire[] wireArray = wires;
        int n = wires.length;
        int n2 = 0;
        while (n2 < n) {
            Wire w = wireArray[n2];
            try {
                int outputPort = (Integer)w.getProperties().get(Constants.WIRE_EMITTER_PORT_PROP_NAME.value());
                ((PortImpl)this.emitterPorts.get((int)outputPort)).connectedWires.add(w);
            }
            catch (Exception e) {
                logger.warn("Failed to assign outgoing wire to port", (Throwable)e);
            }
            ++n2;
        }
    }

    public synchronized void emit(List<WireRecord> wireRecords) {
        Objects.requireNonNull(wireRecords, "Wire Records cannot be null");
        WireEnvelope envelope = this.createWireEnvelope(wireRecords);
        for (EmitterPort emitterPort : this.emitterPorts) {
            emitterPort.emit(envelope);
        }
    }

    public synchronized Object polled(Wire wire) {
        return wire.getLastValue();
    }

    public synchronized void producersConnected(Wire[] wires) {
        this.clearReceiverPorts();
        if (wires == null) {
            return;
        }
        Wire[] wireArray = wires;
        int n = wires.length;
        int n2 = 0;
        while (n2 < n) {
            Wire w = wireArray[n2];
            try {
                int receiverPortIndex = (Integer)w.getProperties().get(Constants.WIRE_RECEIVER_PORT_PROP_NAME.value());
                ReceiverPortImpl receiverPort = (ReceiverPortImpl)this.receiverPorts.get(receiverPortIndex);
                receiverPort.connectedWires.add(w);
                this.receiverPortByWire.put(w, receiverPort);
            }
            catch (Exception e) {
                logger.warn("Failed to assign incomimg wire to port", (Throwable)e);
            }
            ++n2;
        }
    }

    public void updated(Wire wire, Object value) {
        if (wire == null) {
            logger.warn("Wire cannot be null");
            return;
        }
        WireEnvelope envelope = (WireEnvelope)value;
        if (this.wireComponent instanceof WireReceiver) {
            ((WireReceiver)this.wireComponent).onWireReceive(envelope);
        } else {
            ReceiverPortImpl receiverPort = this.receiverPortByWire.get(wire);
            receiverPort.consumer.accept(envelope);
        }
    }

    public List<EmitterPort> getEmitterPorts() {
        return Collections.unmodifiableList(this.emitterPorts);
    }

    public List<ReceiverPort> getReceiverPorts() {
        return Collections.unmodifiableList(this.receiverPorts);
    }

    public WireEnvelope createWireEnvelope(List<WireRecord> records) {
        return new WireEnvelope(this.servicePid, records);
    }

    private class EmitterPortImpl
    extends PortImpl
    implements EmitterPort {
        private EmitterPortImpl() {
        }

        public void emit(WireEnvelope envelope) {
            for (Wire wire : this.connectedWires) {
                wire.update((Object)envelope);
            }
        }
    }

    private abstract class PortImpl
    implements Port {
        List<Wire> connectedWires = new CopyOnWriteArrayList<Wire>();

        private PortImpl() {
        }

        public List<Wire> listConnectedWires() {
            return Collections.unmodifiableList(this.connectedWires);
        }
    }

    private class ReceiverPortImpl
    extends PortImpl
    implements ReceiverPort {
        Consumer<WireEnvelope> consumer = envelope -> {};

        private ReceiverPortImpl() {
        }

        public void onWireReceive(Consumer<WireEnvelope> consumer) {
            Objects.requireNonNull(consumer);
            this.consumer = consumer;
        }
    }
}

