/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.ai.inference;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.kura.ai.inference.TensorDescriptor;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class TensorDescriptorBuilder {
    private final String name;
    private final String type;
    private Optional<String> format;
    private final List<Long> shape;
    private final Map<String, Object> parameters;

    TensorDescriptorBuilder(String name, String type, List<Long> shape) {
        this.name = name;
        this.type = type;
        this.format = Optional.empty();
        this.shape = shape;
        this.parameters = new HashMap<String, Object>();
    }

    public static TensorDescriptorBuilder fromTensorDescriptor(TensorDescriptor descriptor) {
        TensorDescriptorBuilder result = new TensorDescriptorBuilder(descriptor.getName(), descriptor.getType(), descriptor.getShape());
        result.parameters.putAll(descriptor.getParameters());
        result.format = descriptor.getFormat();
        return result;
    }

    public TensorDescriptorBuilder format(String format) {
        if (Objects.nonNull(format) && !format.isEmpty()) {
            this.format = Optional.of(format);
        }
        return this;
    }

    public TensorDescriptorBuilder addParameter(String name, Object parameter) {
        this.parameters.put(name, parameter);
        return this;
    }

    public TensorDescriptorBuilder removeParameter(String name) {
        this.parameters.remove(name);
        return this;
    }

    public TensorDescriptor build() {
        if (Objects.isNull(this.name) || this.name.isEmpty()) {
            throw new IllegalArgumentException("The name of the tensor cannot be empty or null");
        }
        if (Objects.isNull(this.type) || this.type.isEmpty()) {
            throw new IllegalArgumentException("The type of the tensor cannot be empty or null");
        }
        if (Objects.isNull(this.shape) || this.shape.isEmpty()) {
            throw new IllegalArgumentException("The shape of the tensor cannot be empty or null");
        }
        return new TensorDescriptor(this.name, this.type, this.format, this.shape, this.parameters);
    }
}

