/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.timer;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.eclipse.kura.internal.wire.timer.Timer;
import org.eclipse.kura.internal.wire.timer.TimerExecutor;
import org.eclipse.kura.internal.wire.timer.TimerOptions;
import org.eclipse.kura.wire.WireSupport;

public class SimpleTimerExecutor
implements TimerExecutor {
    private final ScheduledExecutorService executor;

    public SimpleTimerExecutor(TimerOptions options, WireSupport wireSupport) {
        this.executor = Executors.newSingleThreadScheduledExecutor(SimpleTimerExecutor.getThreadFactory(options.getOwnPid()));
        long firstTickInterval = (long)options.getSimpleInterval() * options.getSimpleTimeUnitMultiplier();
        if (!options.isDefaultFirstTickBehavior()) {
            firstTickInterval = (long)options.firstTickInterval() * options.getSimpleTimeUnitMultiplier();
        }
        this.executor.scheduleAtFixedRate(() -> Timer.emit(wireSupport), firstTickInterval, (long)options.getSimpleInterval() * options.getSimpleTimeUnitMultiplier(), TimeUnit.MILLISECONDS);
    }

    private static ThreadFactory getThreadFactory(String pid) {
        ThreadFactory defaultFactory = Executors.defaultThreadFactory();
        return runnable -> {
            Thread result = defaultFactory.newThread(runnable);
            result.setName("WiresTimer_" + pid + "_" + System.identityHashCode(result));
            return result;
        };
    }

    @Override
    public void shutdown() {
        this.executor.shutdownNow();
    }
}

