/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.ble;

import com.github.hypfvieh.bluetooth.wrapper.BluetoothGattCharacteristic;
import com.github.hypfvieh.bluetooth.wrapper.BluetoothGattService;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.eclipse.kura.KuraBluetoothResourceNotFoundException;
import org.eclipse.kura.bluetooth.le.BluetoothLeDevice;
import org.eclipse.kura.bluetooth.le.BluetoothLeGattCharacteristic;
import org.eclipse.kura.bluetooth.le.BluetoothLeGattService;
import org.eclipse.kura.internal.ble.BluetoothLeDeviceImpl;
import org.eclipse.kura.internal.ble.BluetoothLeGattCharacteristicImpl;

public class BluetoothLeGattServiceImpl
implements BluetoothLeGattService {
    private final BluetoothGattService service;

    public BluetoothLeGattServiceImpl(BluetoothGattService service) {
        this.service = service;
    }

    public BluetoothLeGattCharacteristic findCharacteristic(UUID uuid) throws KuraBluetoothResourceNotFoundException {
        BluetoothGattCharacteristic characteristic = this.service.getGattCharacteristicByUuid(uuid.toString());
        if (characteristic != null) {
            return new BluetoothLeGattCharacteristicImpl(characteristic);
        }
        throw new KuraBluetoothResourceNotFoundException((Object)"Gatt characteristic not found");
    }

    public BluetoothLeGattCharacteristic findCharacteristic(UUID uuid, long timeout) throws KuraBluetoothResourceNotFoundException {
        return this.findCharacteristic(uuid);
    }

    public List<BluetoothLeGattCharacteristic> findCharacteristics() throws KuraBluetoothResourceNotFoundException {
        List characteristicList = this.service.getGattCharacteristics();
        ArrayList<BluetoothLeGattCharacteristic> characteristics = new ArrayList<BluetoothLeGattCharacteristic>();
        if (characteristicList != null) {
            for (BluetoothGattCharacteristic characteristic : characteristicList) {
                characteristics.add(new BluetoothLeGattCharacteristicImpl(characteristic));
            }
        } else {
            throw new KuraBluetoothResourceNotFoundException((Object)"Gatt characteristics not found");
        }
        return characteristics;
    }

    public UUID getUUID() {
        String uuid = this.service.getUuid();
        if (uuid == null) {
            return null;
        }
        return UUID.fromString(uuid);
    }

    public BluetoothLeDevice getDevice() {
        return new BluetoothLeDeviceImpl(this.service.getDevice());
    }

    public boolean isPrimary() {
        Boolean primary = this.service.isPrimary();
        if (primary != null) {
            return primary;
        }
        return false;
    }
}

