/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.gpsd4java.backend;

import com.google.gson.JsonObject;
import de.taimos.gpsd4java.backend.AbstractResultParser;
import de.taimos.gpsd4java.types.ATTObject;
import de.taimos.gpsd4java.types.DeviceObject;
import de.taimos.gpsd4java.types.DevicesObject;
import de.taimos.gpsd4java.types.ENMEAMode;
import de.taimos.gpsd4java.types.EParity;
import de.taimos.gpsd4java.types.GSTObject;
import de.taimos.gpsd4java.types.IGPSObject;
import de.taimos.gpsd4java.types.ParseException;
import de.taimos.gpsd4java.types.PollObject;
import de.taimos.gpsd4java.types.SATObject;
import de.taimos.gpsd4java.types.SKYObject;
import de.taimos.gpsd4java.types.TPVObject;
import de.taimos.gpsd4java.types.VersionObject;
import de.taimos.gpsd4java.types.WatchObject;
import de.taimos.gpsd4java.types.subframes.ALMANACObject;
import de.taimos.gpsd4java.types.subframes.EPHEM1Object;
import de.taimos.gpsd4java.types.subframes.EPHEM2Object;
import de.taimos.gpsd4java.types.subframes.EPHEM3Object;
import de.taimos.gpsd4java.types.subframes.ERDObject;
import de.taimos.gpsd4java.types.subframes.HEALTH2Object;
import de.taimos.gpsd4java.types.subframes.HEALTHObject;
import de.taimos.gpsd4java.types.subframes.IONOObject;
import de.taimos.gpsd4java.types.subframes.SUBFRAMEObject;
import java.util.Collections;

public class ResultParser
extends AbstractResultParser {
    @Override
    public IGPSObject parse(JsonObject json) throws ParseException {
        IGPSObject gps = null;
        String clazz = this.optString(json, "class");
        if ("TPV".equals(clazz)) {
            gps = this.parseTPV(json);
        } else if ("SKY".equals(clazz)) {
            gps = this.parseSKY(json);
        } else if ("GST".equals(clazz)) {
            gps = this.parseGST(json);
        } else if ("ATT".equals(clazz)) {
            gps = this.parseATT(json);
        } else if ("SUBFRAME".equals(clazz)) {
            gps = this.parseSUBFRAME(json);
        } else if ("VERSION".equals(clazz)) {
            gps = this.parseVERSION(json);
        } else if ("DEVICES".equals(clazz)) {
            gps = this.parseDEVICES(json);
        } else if ("DEVICE".equals(clazz)) {
            gps = this.parseDEVICE(json);
        } else if ("WATCH".equals(clazz)) {
            gps = this.parseWATCH(json);
        } else if ("POLL".equals(clazz)) {
            gps = this.parsePOLL(json);
        } else if (json.has("PRN")) {
            gps = this.parsePRN(json);
        } else if (json.has("deltai")) {
            gps = this.parseALMANAC(json);
        } else if (json.has("IODC")) {
            gps = this.parseEPHEM1(json);
        } else if (json.has("Crs")) {
            gps = this.parseEPHEM2(json);
        } else if (json.has("IDOT")) {
            gps = this.parseEPHEM3(json);
        } else if (json.has("ERD30")) {
            gps = this.parseERD(json);
        } else if (json.has("SVH32")) {
            gps = this.parseHEALTH(json);
        } else if (json.has("WNa")) {
            gps = this.parseHEALTH2(json);
        } else if (json.has("WNlsf")) {
            gps = this.parseIONO(json);
        } else {
            throw new ParseException("Invalid object class: " + clazz);
        }
        return gps;
    }

    protected IGPSObject parseIONO(JsonObject json) {
        IONOObject iono = new IONOObject();
        iono.setAlpha0(this.optDouble(json, "a0", Double.NaN));
        iono.setAlpha1(this.optDouble(json, "a1", Double.NaN));
        iono.setAlpha2(this.optDouble(json, "a2", Double.NaN));
        iono.setAlpha3(this.optDouble(json, "a3", Double.NaN));
        iono.setBeta0(this.optDouble(json, "b0", Double.NaN));
        iono.setBeta1(this.optDouble(json, "b1", Double.NaN));
        iono.setBeta2(this.optDouble(json, "b2", Double.NaN));
        iono.setBeta3(this.optDouble(json, "b3", Double.NaN));
        iono.setA0(this.optDouble(json, "A0", Double.NaN));
        iono.setA1(this.optDouble(json, "A1", Double.NaN));
        iono.setTot(this.optDouble(json, "tot", Double.NaN));
        iono.setWNt(this.optInt(json, "WNt"));
        iono.setLeap(this.optInt(json, "ls"));
        iono.setWNlsf(this.optInt(json, "WNlsf"));
        iono.setDN(this.optInt(json, "DN"));
        iono.setLsf(this.optInt(json, "lsf"));
        IONOObject gps = iono;
        return gps;
    }

    protected IGPSObject parseHEALTH2(JsonObject json) {
        HEALTH2Object health2 = new HEALTH2Object();
        health2.setToa(this.optInt(json, "toa"));
        health2.setWNa(this.optInt(json, "WNa"));
        for (int index = 1; index <= 24; ++index) {
            health2.setSVbyIndex(index - 1, this.optInt(json, "SV" + index));
        }
        HEALTH2Object gps = health2;
        return gps;
    }

    protected IGPSObject parseHEALTH(JsonObject json) {
        int index;
        HEALTHObject health = new HEALTHObject();
        health.setData_id(this.optInt(json, "data_id"));
        for (index = 1; index <= 32; ++index) {
            health.setSVbyIndex(index - 1, this.optInt(json, "SV" + index));
        }
        for (index = 0; index <= 7; ++index) {
            health.setSVHbyIndex(index, this.optInt(json, "SVH" + (index + 25)));
        }
        HEALTHObject gps = health;
        return gps;
    }

    protected IGPSObject parseERD(JsonObject json) {
        ERDObject erd = new ERDObject();
        erd.setAi(this.optInt(json, "ai"));
        for (int index = 1; index <= 30; ++index) {
            erd.setERDbyIndex(index - 1, this.optInt(json, "ERD" + index));
        }
        ERDObject gps = erd;
        return gps;
    }

    protected IGPSObject parseEPHEM3(JsonObject json) {
        EPHEM3Object emphem3 = new EPHEM3Object();
        emphem3.setIODE(this.optInt(json, "IODE"));
        emphem3.setIDOT(this.optDouble(json, "IDOT", Double.NaN));
        emphem3.setCic(this.optDouble(json, "Cic", Double.NaN));
        emphem3.setOmega0(this.optDouble(json, "Omega0", Double.NaN));
        emphem3.setCis(this.optDouble(json, "Cis", Double.NaN));
        emphem3.setI0(this.optDouble(json, "i0", Double.NaN));
        emphem3.setCrc(this.optDouble(json, "Crc", Double.NaN));
        emphem3.setOmega(this.optDouble(json, "omega", Double.NaN));
        emphem3.setOmegad(this.optDouble(json, "Omegad", Double.NaN));
        EPHEM3Object gps = emphem3;
        return gps;
    }

    protected IGPSObject parseEPHEM2(JsonObject json) {
        EPHEM2Object emphem2 = new EPHEM2Object();
        emphem2.setIODE(this.optInt(json, "IODE"));
        emphem2.setCrs(this.optDouble(json, "Crs", Double.NaN));
        emphem2.setDeltan(this.optDouble(json, "deltan", Double.NaN));
        emphem2.setM0(this.optDouble(json, "M0", Double.NaN));
        emphem2.setCuc(this.optDouble(json, "Cuc", Double.NaN));
        emphem2.setE(this.optDouble(json, "e", Double.NaN));
        emphem2.setCus(this.optDouble(json, "Cus", Double.NaN));
        emphem2.setSqrtA(this.optInt(json, "sqrtA"));
        emphem2.setToe(this.optInt(json, "toe"));
        emphem2.setFIT(this.optInt(json, "FIT"));
        emphem2.setAODO(this.optInt(json, "AODO"));
        EPHEM2Object gps = emphem2;
        return gps;
    }

    protected IGPSObject parseEPHEM1(JsonObject json) {
        EPHEM1Object emphem1 = new EPHEM1Object();
        emphem1.setWN(this.optInt(json, "WN"));
        emphem1.setIODC(this.optInt(json, "IODC"));
        emphem1.setL2(this.optInt(json, "L2"));
        emphem1.setUra(this.optDouble(json, "ura", Double.NaN));
        emphem1.setHlth(this.optDouble(json, "hlth", Double.NaN));
        emphem1.setL2P(this.optInt(json, "L2P"));
        emphem1.setTgd(this.optDouble(json, "Tgd", Double.NaN));
        emphem1.setToc(this.optInt(json, "toc"));
        emphem1.setAf2(this.optDouble(json, "af2", Double.NaN));
        emphem1.setAf1(this.optDouble(json, "af1", Double.NaN));
        emphem1.setAf0(this.optDouble(json, "af0", Double.NaN));
        EPHEM1Object gps = emphem1;
        return gps;
    }

    protected IGPSObject parseALMANAC(JsonObject json) {
        ALMANACObject almanac = new ALMANACObject();
        almanac.setID(this.optInt(json, "ID"));
        almanac.setHealth(this.optInt(json, "Health"));
        almanac.setE(this.optDouble(json, "e", Double.NaN));
        almanac.setToa(this.optInt(json, "toa"));
        almanac.setDeltai(this.optDouble(json, "deltai", Double.NaN));
        almanac.setOmegad(this.optDouble(json, "Omegad", Double.NaN));
        almanac.setSqrtA(this.optDouble(json, "sqrtA", Double.NaN));
        almanac.setOmega0(this.optDouble(json, "Omega0", Double.NaN));
        almanac.setOmega(this.optDouble(json, "omega", Double.NaN));
        almanac.setM0(this.optDouble(json, "M0", Double.NaN));
        almanac.setAf0(this.optDouble(json, "af0", Double.NaN));
        almanac.setAf1(this.optDouble(json, "af1", Double.NaN));
        ALMANACObject gps = almanac;
        return gps;
    }

    protected IGPSObject parsePRN(JsonObject json) {
        SATObject sat = new SATObject();
        sat.setPRN(this.optInt(json, "PRN", -1));
        sat.setAzimuth(this.optInt(json, "az", -1));
        sat.setElevation(this.optInt(json, "el", -1));
        sat.setSignalStrength(this.optInt(json, "ss", -1));
        sat.setUsed(this.optBoolean(json, "used", false));
        SATObject gps = sat;
        return gps;
    }

    protected IGPSObject parsePOLL(JsonObject json) throws ParseException {
        PollObject poll = new PollObject();
        if (json.has("time")) {
            poll.setTimestamp(this.parseTimestamp(json, "time"));
        } else if (json.has("timestamp")) {
            poll.setTimestamp(this.optDouble(json, "timestamp", Double.NaN));
        } else {
            poll.setTimestamp(System.currentTimeMillis());
        }
        poll.setActive(this.optInt(json, "active", 0));
        if (json.has("tpv")) {
            poll.setFixes(this.parseObjectArray(json.getAsJsonArray("tpv"), TPVObject.class));
        } else if (json.has("fixes")) {
            poll.setFixes(this.parseObjectArray(json.getAsJsonArray("fixes"), TPVObject.class));
        } else {
            poll.setFixes(Collections.emptyList());
        }
        if (json.has("sky")) {
            poll.setSkyviews(this.parseObjectArray(json.getAsJsonArray("sky"), SKYObject.class));
        } else if (json.has("skyviews")) {
            poll.setSkyviews(this.parseObjectArray(json.getAsJsonArray("skyviews"), SKYObject.class));
        } else {
            poll.setSkyviews(Collections.emptyList());
        }
        if (json.has("gst")) {
            poll.setGst(this.parseObjectArray(json.getAsJsonArray("gst"), GSTObject.class));
        } else {
            poll.setGst(Collections.emptyList());
        }
        PollObject gps = poll;
        return gps;
    }

    protected IGPSObject parseWATCH(JsonObject json) {
        WatchObject watch = new WatchObject();
        watch.setEnable(this.optBoolean(json, "enable", true));
        watch.setDump(this.optBoolean(json, "json", false));
        WatchObject gps = watch;
        return gps;
    }

    protected IGPSObject parseDEVICE(JsonObject json) {
        DeviceObject dev = new DeviceObject();
        dev.setPath(this.optString(json, "path", null));
        dev.setActivated(this.parseTimestamp(json, "activated"));
        dev.setDriver(this.optString(json, "driver", null));
        dev.setBps(this.optInt(json, "bps", 0));
        dev.setParity(EParity.fromString(this.optString(json, "parity")));
        dev.setStopbit(this.optInt(json, "stopbit"));
        dev.setNativeMode(this.optInt(json, "native", 0) == 1);
        dev.setCycle(this.optInt(json, "cycle"));
        dev.setMincycle(this.optInt(json, "mincycle"));
        DeviceObject gps = dev;
        return gps;
    }

    protected IGPSObject parseDEVICES(JsonObject json) throws ParseException {
        DevicesObject devs = new DevicesObject();
        devs.setDevices(this.parseObjectArray(json.getAsJsonArray("devices"), DeviceObject.class));
        DevicesObject gps = devs;
        return gps;
    }

    protected IGPSObject parseVERSION(JsonObject json) {
        VersionObject ver = new VersionObject();
        ver.setRelease(this.optString(json, "release", null));
        ver.setRev(this.optString(json, "rev", null));
        ver.setProtocolMajor(this.optDouble(json, "proto_major", 0.0));
        ver.setProtocolMinor(this.optDouble(json, "proto_minor", 0.0));
        VersionObject gps = ver;
        return gps;
    }

    protected IGPSObject parseSUBFRAME(JsonObject json) throws ParseException {
        SUBFRAMEObject subframe = new SUBFRAMEObject();
        subframe.setDevice(this.optString(json, "device", null));
        subframe.setMSBs(this.optInt(json, "TOW17"));
        subframe.setSatelliteNumber(this.optInt(json, "tSV"));
        subframe.setSubframeNumber(this.optInt(json, "frame"));
        subframe.setScaled(this.optBoolean(json, "scaled", false));
        subframe.setPageid(this.optInt(json, "pageid"));
        if (json.has("system_message")) {
            subframe.setSystemMessage(this.optString(json, "system_message"));
        } else if (json.has("ALMANAC")) {
            subframe.setAlmanac((ALMANACObject)this.parse(json.getAsJsonObject("ALMANAC")));
        } else if (json.has("EPHEM1")) {
            subframe.setEphem1((EPHEM1Object)this.parse(json.getAsJsonObject("EPHEM1")));
        } else if (json.has("EPHEM2")) {
            subframe.setEphem2((EPHEM2Object)this.parse(json.getAsJsonObject("EPHEM2")));
        } else if (json.has("EPHEM3")) {
            subframe.setEphem3((EPHEM3Object)this.parse(json.getAsJsonObject("EPHEM3")));
        } else if (json.has("ERD")) {
            subframe.setErd((ERDObject)this.parse(json.getAsJsonObject("ERD")));
        } else if (json.has("HEALTH")) {
            subframe.setHealth((HEALTHObject)this.parse(json.getAsJsonObject("HEALTH")));
        } else if (json.has("HEALTH2")) {
            subframe.setHealth2((HEALTH2Object)this.parse(json.getAsJsonObject("HEALTH2")));
        } else if (json.has("IONO")) {
            subframe.setIono((IONOObject)this.parse(json.getAsJsonObject("IONO")));
        } else {
            AbstractResultParser.LOG.error("Unknown subframe: {}", (Object)json.toString());
        }
        SUBFRAMEObject gps = subframe;
        return gps;
    }

    protected IGPSObject parseATT(JsonObject json) {
        ATTObject att = new ATTObject();
        att.setTag(this.optString(json, "tag", null));
        att.setDevice(this.optString(json, "device", null));
        att.setTimestamp(this.parseTimestamp(json, "time"));
        att.setHeading(this.optDouble(json, "heading", Double.NaN));
        att.setPitch(this.optDouble(json, "pitch", Double.NaN));
        att.setYaw(this.optDouble(json, "yaw", Double.NaN));
        att.setRoll(this.optDouble(json, "roll", Double.NaN));
        att.setDip(this.optDouble(json, "dip", Double.NaN));
        att.setMag_len(this.optDouble(json, "mag_len", Double.NaN));
        att.setMag_x(this.optDouble(json, "mag_x", Double.NaN));
        att.setMag_y(this.optDouble(json, "mag_y", Double.NaN));
        att.setMag_z(this.optDouble(json, "mag_z", Double.NaN));
        att.setAcc_len(this.optDouble(json, "acc_len", Double.NaN));
        att.setAcc_x(this.optDouble(json, "acc_x", Double.NaN));
        att.setAcc_y(this.optDouble(json, "acc_y", Double.NaN));
        att.setAcc_z(this.optDouble(json, "acc_z", Double.NaN));
        att.setGyro_x(this.optDouble(json, "gyro_x", Double.NaN));
        att.setGyro_y(this.optDouble(json, "gyro_y", Double.NaN));
        att.setDepth(this.optDouble(json, "depth", Double.NaN));
        att.setTemperature(this.optDouble(json, "temperature", Double.NaN));
        att.setMagState(this.optString(json, "mag_st", null));
        att.setRollState(this.optString(json, "roll_st", null));
        att.setPitchState(this.optString(json, "pitch_st", null));
        att.setYawState(this.optString(json, "yaw_st", null));
        ATTObject gps = att;
        return gps;
    }

    protected IGPSObject parseGST(JsonObject json) {
        GSTObject gst = new GSTObject();
        gst.setTag(this.optString(json, "tag", null));
        gst.setDevice(this.optString(json, "device", null));
        gst.setTimestamp(this.parseTimestamp(json, "time"));
        gst.setRms(this.optDouble(json, "rms", Double.NaN));
        gst.setMajor(this.optDouble(json, "major", Double.NaN));
        gst.setMinor(this.optDouble(json, "minor", Double.NaN));
        gst.setOrient(this.optDouble(json, "orient", Double.NaN));
        gst.setLat(this.optDouble(json, "lat", Double.NaN));
        gst.setLon(this.optDouble(json, "lon", Double.NaN));
        gst.setAlt(this.optDouble(json, "alt", Double.NaN));
        GSTObject gps = gst;
        return gps;
    }

    protected IGPSObject parseSKY(JsonObject json) throws ParseException {
        SKYObject sky = new SKYObject();
        sky.setTag(this.optString(json, "tag", null));
        sky.setDevice(this.optString(json, "device", null));
        sky.setTimestamp(this.parseTimestamp(json, "time"));
        sky.setLongitudeDOP(this.optDouble(json, "xdop", Double.NaN));
        sky.setLatitudeDOP(this.optDouble(json, "ydop", Double.NaN));
        sky.setAltitudeDOP(this.optDouble(json, "vdop", Double.NaN));
        sky.setTimestampDOP(this.optDouble(json, "tdop", Double.NaN));
        sky.setHorizontalDOP(this.optDouble(json, "hdop", Double.NaN));
        sky.setSphericalDOP(this.optDouble(json, "pdop", Double.NaN));
        sky.setHypersphericalDOP(this.optDouble(json, "gdop", Double.NaN));
        sky.setSatellites(this.parseObjectArray(json.getAsJsonArray("satellites"), SATObject.class));
        SKYObject gps = sky;
        return gps;
    }

    protected IGPSObject parseTPV(JsonObject json) {
        TPVObject tpv = new TPVObject();
        tpv.setTag(this.optString(json, "tag", null));
        tpv.setDevice(this.optString(json, "device", null));
        tpv.setTimestamp(this.parseTimestamp(json, "time"));
        tpv.setTimestampError(this.optDouble(json, "ept", Double.NaN));
        tpv.setLatitude(this.optDouble(json, "lat", Double.NaN));
        tpv.setLongitude(this.optDouble(json, "lon", Double.NaN));
        tpv.setAltitude(this.optDouble(json, "alt", Double.NaN));
        tpv.setLongitudeError(this.optDouble(json, "epx", Double.NaN));
        tpv.setLatitudeError(this.optDouble(json, "epy", Double.NaN));
        tpv.setAltitudeError(this.optDouble(json, "epv", Double.NaN));
        tpv.setCourse(this.optDouble(json, "track", Double.NaN));
        tpv.setSpeed(this.optDouble(json, "speed", Double.NaN));
        tpv.setClimbRate(this.optDouble(json, "climb", Double.NaN));
        tpv.setCourseError(this.optDouble(json, "epd", Double.NaN));
        tpv.setSpeedError(this.optDouble(json, "eps", Double.NaN));
        tpv.setClimbRateError(this.optDouble(json, "epc", Double.NaN));
        tpv.setMode(ENMEAMode.fromInt(this.optInt(json, "mode", 0)));
        TPVObject gps = tpv;
        return gps;
    }
}

