/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl.dependencies;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.felix.dm.ComponentDependencyDeclaration;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyService;
import org.apache.felix.dm.InvocationUtil;
import org.apache.felix.dm.ServiceDependency;
import org.apache.felix.dm.impl.DefaultNullObject;
import org.apache.felix.dm.impl.Logger;
import org.apache.felix.dm.impl.dependencies.DependencyBase;
import org.apache.felix.dm.tracker.ServiceTracker;
import org.apache.felix.dm.tracker.ServiceTrackerCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ServiceDependencyImpl
extends DependencyBase
implements ServiceDependency,
ServiceTrackerCustomizer,
ComponentDependencyDeclaration {
    protected List m_services = new ArrayList();
    protected volatile ServiceTracker m_tracker;
    protected BundleContext m_context;
    protected volatile Class m_trackedServiceName;
    private Object m_nullObject;
    private volatile String m_trackedServiceFilter;
    private volatile String m_trackedServiceFilterUnmodified;
    private volatile ServiceReference m_trackedServiceReference;
    private volatile boolean m_isStarted;
    private Object m_callbackInstance;
    private String m_callbackAdded;
    private String m_callbackChanged;
    private String m_callbackRemoved;
    private boolean m_autoConfig;
    protected ServiceReference m_reference;
    protected Object m_serviceInstance;
    private String m_autoConfigInstance;
    private boolean m_autoConfigInvoked;
    private Object m_defaultImplementation;
    private Object m_defaultImplementationInstance;
    private boolean m_isAvailable;
    private boolean m_propagate;
    private Object m_propagateCallbackInstance;
    private String m_propagateCallbackMethod;
    private final Map m_sr = new HashMap();
    private static final Comparator COMPARATOR = new Comparator(){

        public int getRank(ServiceReference ref) {
            Object ranking = ref.getProperty("service.ranking");
            if (ranking != null && ranking instanceof Integer) {
                return (Integer)ranking;
            }
            return 0;
        }

        public int compare(Object a, Object b) {
            int rankb;
            ServiceReference ra = (ServiceReference)a;
            ServiceReference rb = (ServiceReference)b;
            int ranka = this.getRank(ra);
            if (ranka < (rankb = this.getRank(rb))) {
                return -1;
            }
            if (ranka > rankb) {
                return 1;
            }
            return 0;
        }
    };
    static /* synthetic */ Class class$org$apache$felix$dm$Component;
    static /* synthetic */ Class class$org$osgi$framework$ServiceReference;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$Map;

    public ServiceDependencyImpl(BundleContext context, Logger logger) {
        super(logger);
        this.m_context = context;
        this.m_autoConfig = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceDependencyImpl(ServiceDependencyImpl prototype) {
        super(prototype);
        ServiceDependencyImpl serviceDependencyImpl = prototype;
        synchronized (serviceDependencyImpl) {
            this.m_context = prototype.m_context;
            this.m_autoConfig = prototype.m_autoConfig;
            this.m_trackedServiceName = prototype.m_trackedServiceName;
            this.m_nullObject = prototype.m_nullObject;
            this.m_trackedServiceFilter = prototype.m_trackedServiceFilter;
            this.m_trackedServiceFilterUnmodified = prototype.m_trackedServiceFilterUnmodified;
            this.m_trackedServiceReference = prototype.m_trackedServiceReference;
            this.m_callbackInstance = prototype.m_callbackInstance;
            this.m_callbackAdded = prototype.m_callbackAdded;
            this.m_callbackChanged = prototype.m_callbackChanged;
            this.m_callbackRemoved = prototype.m_callbackRemoved;
            this.m_autoConfigInstance = prototype.m_autoConfigInstance;
            this.m_defaultImplementation = prototype.m_defaultImplementation;
        }
    }

    public Dependency createCopy() {
        return new ServiceDependencyImpl(this);
    }

    public synchronized boolean isAutoConfig() {
        return this.m_autoConfig;
    }

    public synchronized boolean isAvailable() {
        return this.m_isAvailable;
    }

    public synchronized Object getService() {
        Object service = null;
        if (this.m_isStarted) {
            service = this.m_tracker.getService();
        }
        if (service == null && this.isAutoConfig() && (service = this.getDefaultImplementation()) == null) {
            service = this.getNullObject();
        }
        return service;
    }

    /*
     * Unable to fully structure code
     */
    public Object lookupService() {
        service = null;
        if (this.m_isStarted) {
            service = this.getService();
        } else {
            refs = null;
            ref = null;
            if (this.m_trackedServiceName != null) {
                if (this.m_trackedServiceFilter != null) {
                    try {
                        refs = this.m_context.getServiceReferences(this.m_trackedServiceName.getName(), this.m_trackedServiceFilter);
                        if (refs == null) ** GOTO lbl18
                        Arrays.sort(refs, ServiceDependencyImpl.COMPARATOR);
                        ref = refs[0];
                    }
                    catch (InvalidSyntaxException e) {
                        throw new IllegalStateException("Invalid filter definition for dependency.");
                    }
                } else {
                    ref = this.m_trackedServiceReference != null ? this.m_trackedServiceReference : this.m_context.getServiceReference(this.m_trackedServiceName.getName());
                }
lbl18:
                // 3 sources

                if (ref != null) {
                    service = this.m_context.getService(ref);
                }
            } else {
                throw new IllegalStateException("Could not lookup dependency, no service name specified.");
            }
        }
        if (service == null && this.isAutoConfig() && (service = this.getDefaultImplementation()) == null) {
            service = this.getNullObject();
        }
        return service;
    }

    /*
     * Unable to fully structure code
     */
    public ServiceReference lookupServiceReference() {
        service = null;
        if (this.m_isStarted) {
            service = this.m_tracker.getServiceReference();
        } else {
            refs = null;
            ref = null;
            if (this.m_trackedServiceName != null) {
                if (this.m_trackedServiceFilter != null) {
                    try {
                        refs = this.m_context.getServiceReferences(this.m_trackedServiceName.getName(), this.m_trackedServiceFilter);
                        if (refs == null) ** GOTO lbl18
                        Arrays.sort(refs, ServiceDependencyImpl.COMPARATOR);
                        ref = refs[0];
                    }
                    catch (InvalidSyntaxException e) {
                        throw new IllegalStateException("Invalid filter definition for dependency.");
                    }
                } else {
                    ref = this.m_trackedServiceReference != null ? this.m_trackedServiceReference : this.m_context.getServiceReference(this.m_trackedServiceName.getName());
                }
lbl18:
                // 3 sources

                if (ref != null) {
                    service = ref;
                }
            } else {
                throw new IllegalStateException("Could not lookup dependency, no service name specified.");
            }
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getNullObject() {
        if (this.m_nullObject == null) {
            Class trackedServiceName;
            ServiceDependencyImpl serviceDependencyImpl = this;
            synchronized (serviceDependencyImpl) {
                trackedServiceName = this.m_trackedServiceName;
            }
            try {
                this.m_nullObject = Proxy.newProxyInstance(trackedServiceName.getClassLoader(), new Class[]{trackedServiceName}, (InvocationHandler)new DefaultNullObject());
            }
            catch (Exception e) {
                this.m_logger.log(1, "Could not create null object for " + trackedServiceName + ".", e);
            }
        }
        return this.m_nullObject;
    }

    private Object getDefaultImplementation() {
        if (this.m_defaultImplementation != null) {
            if (this.m_defaultImplementation instanceof Class) {
                try {
                    this.m_defaultImplementationInstance = ((Class)this.m_defaultImplementation).newInstance();
                }
                catch (Exception e) {
                    this.m_logger.log(1, "Could not create default implementation instance of class " + this.m_defaultImplementation + ".", e);
                }
            } else {
                this.m_defaultImplementationInstance = this.m_defaultImplementation;
            }
        }
        return this.m_defaultImplementationInstance;
    }

    public synchronized Class getInterface() {
        return this.m_trackedServiceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(DependencyService service) {
        boolean needsStarting = false;
        ServiceDependencyImpl serviceDependencyImpl = this;
        synchronized (serviceDependencyImpl) {
            this.m_services.add(service);
            if (!this.m_isStarted) {
                if (this.m_trackedServiceName != null) {
                    if (this.m_trackedServiceFilter != null) {
                        try {
                            this.m_tracker = new ServiceTracker(this.m_context, this.m_context.createFilter(this.m_trackedServiceFilter), (ServiceTrackerCustomizer)this);
                        }
                        catch (InvalidSyntaxException e) {
                            throw new IllegalStateException("Invalid filter definition for dependency: " + this.m_trackedServiceFilter);
                        }
                    } else {
                        this.m_tracker = this.m_trackedServiceReference != null ? new ServiceTracker(this.m_context, this.m_trackedServiceReference, (ServiceTrackerCustomizer)this) : new ServiceTracker(this.m_context, this.m_trackedServiceName.getName(), (ServiceTrackerCustomizer)this);
                    }
                } else {
                    throw new IllegalStateException("Could not create tracker for dependency, no service name specified.");
                }
                this.m_isStarted = true;
                needsStarting = true;
            }
        }
        if (needsStarting) {
            this.m_tracker.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(DependencyService service) {
        boolean needsStopping = false;
        ServiceDependencyImpl serviceDependencyImpl = this;
        synchronized (serviceDependencyImpl) {
            if (this.m_services.size() == 1 && this.m_services.contains(service)) {
                this.m_isStarted = false;
                needsStopping = true;
            }
        }
        if (needsStopping) {
            this.m_tracker.close();
            this.m_tracker = null;
        }
        serviceDependencyImpl = this;
        synchronized (serviceDependencyImpl) {
            this.m_services.remove(service);
        }
    }

    public Object addingService(ServiceReference ref) {
        Object service = this.m_context.getService(ref);
        if (!this.m_trackedServiceName.isInstance(service)) {
            return null;
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addedService(ServiceReference ref, Object service) {
        Object[] services;
        boolean makeAvailable = this.makeAvailable();
        ServiceDependencyImpl serviceDependencyImpl = this;
        synchronized (serviceDependencyImpl) {
            services = this.m_services.toArray();
        }
        for (int i = 0; i < services.length; ++i) {
            DependencyService ds = (DependencyService)services[i];
            if (makeAvailable) {
                if (ds.isInstantiated() && this.isInstanceBound() && this.isRequired()) {
                    this.invokeAdded(ds, ref, service);
                }
                ds.dependencyAvailable(this);
                if (this.isRequired()) continue;
                this.invokeAdded(ds, ref, service);
                continue;
            }
            ds.dependencyChanged(this);
            if (!ds.isInstantiated() || ds.getCompositionInstances().length <= 0) continue;
            this.invokeAdded(ds, ref, service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifiedService(ServiceReference ref, Object service) {
        Object[] services;
        ServiceDependencyImpl serviceDependencyImpl = this;
        synchronized (serviceDependencyImpl) {
            services = this.m_services.toArray();
        }
        for (int i = 0; i < services.length; ++i) {
            DependencyService ds = (DependencyService)services[i];
            ds.dependencyChanged(this);
            if (!ds.isRegistered()) continue;
            this.invokeChanged(ds, ref, service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference ref, Object service) {
        Object[] services;
        boolean makeUnavailable = this.makeUnavailable();
        ServiceDependencyImpl serviceDependencyImpl = this;
        synchronized (serviceDependencyImpl) {
            services = this.m_services.toArray();
        }
        for (int i = 0; i < services.length; ++i) {
            DependencyService ds = (DependencyService)services[i];
            if (makeUnavailable) {
                ds.dependencyUnavailable(this);
                if (this.isRequired() && (!ds.isInstantiated() || !this.isInstanceBound())) continue;
                this.invokeRemoved(ds, ref, service);
                continue;
            }
            ds.dependencyChanged(this);
            this.invokeRemoved(ds, ref, service);
        }
        this.m_context.ungetService(ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAdded(DependencyService dependencyService, ServiceReference reference, Object service) {
        boolean added = false;
        Map map = this.m_sr;
        synchronized (map) {
            HashSet<Tuple> set = (HashSet<Tuple>)this.m_sr.get(dependencyService);
            if (set == null) {
                set = new HashSet<Tuple>();
                this.m_sr.put(dependencyService, set);
            }
            added = set.add(new Tuple(reference, service));
        }
        if (added) {
            this.invoke(dependencyService, reference, service, this.m_callbackAdded);
        }
    }

    public void invokeChanged(DependencyService dependencyService, ServiceReference reference, Object service) {
        this.invoke(dependencyService, reference, service, this.m_callbackChanged);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeRemoved(DependencyService dependencyService, ServiceReference reference, Object service) {
        boolean removed = false;
        Map map = this.m_sr;
        synchronized (map) {
            Set set = (Set)this.m_sr.get(dependencyService);
            removed = set != null && set.remove(new Tuple(reference, service));
        }
        if (removed) {
            this.invoke(dependencyService, reference, service, this.m_callbackRemoved);
        }
    }

    public void invoke(DependencyService dependencyService, ServiceReference reference, Object service, String name) {
        if (name != null) {
            dependencyService.invokeCallbackMethod(this.getCallbackInstances(dependencyService), name, new Class[][]{{class$org$apache$felix$dm$Component == null ? (class$org$apache$felix$dm$Component = ServiceDependencyImpl.class$("org.apache.felix.dm.Component")) : class$org$apache$felix$dm$Component, class$org$osgi$framework$ServiceReference == null ? (class$org$osgi$framework$ServiceReference = ServiceDependencyImpl.class$("org.osgi.framework.ServiceReference")) : class$org$osgi$framework$ServiceReference, this.m_trackedServiceName}, {class$org$apache$felix$dm$Component == null ? (class$org$apache$felix$dm$Component = ServiceDependencyImpl.class$("org.apache.felix.dm.Component")) : class$org$apache$felix$dm$Component, class$org$osgi$framework$ServiceReference == null ? (class$org$osgi$framework$ServiceReference = ServiceDependencyImpl.class$("org.osgi.framework.ServiceReference")) : class$org$osgi$framework$ServiceReference, class$java$lang$Object == null ? (class$java$lang$Object = ServiceDependencyImpl.class$("java.lang.Object")) : class$java$lang$Object}, {class$org$apache$felix$dm$Component == null ? (class$org$apache$felix$dm$Component = ServiceDependencyImpl.class$("org.apache.felix.dm.Component")) : class$org$apache$felix$dm$Component, class$org$osgi$framework$ServiceReference == null ? (class$org$osgi$framework$ServiceReference = ServiceDependencyImpl.class$("org.osgi.framework.ServiceReference")) : class$org$osgi$framework$ServiceReference}, {class$org$apache$felix$dm$Component == null ? (class$org$apache$felix$dm$Component = ServiceDependencyImpl.class$("org.apache.felix.dm.Component")) : class$org$apache$felix$dm$Component, this.m_trackedServiceName}, {class$org$apache$felix$dm$Component == null ? (class$org$apache$felix$dm$Component = ServiceDependencyImpl.class$("org.apache.felix.dm.Component")) : class$org$apache$felix$dm$Component, class$java$lang$Object == null ? (class$java$lang$Object = ServiceDependencyImpl.class$("java.lang.Object")) : class$java$lang$Object}, {class$org$apache$felix$dm$Component == null ? (class$org$apache$felix$dm$Component = ServiceDependencyImpl.class$("org.apache.felix.dm.Component")) : class$org$apache$felix$dm$Component}, {class$org$apache$felix$dm$Component == null ? (class$org$apache$felix$dm$Component = ServiceDependencyImpl.class$("org.apache.felix.dm.Component")) : class$org$apache$felix$dm$Component, class$java$util$Map == null ? (class$java$util$Map = ServiceDependencyImpl.class$("java.util.Map")) : class$java$util$Map, this.m_trackedServiceName}, {class$org$osgi$framework$ServiceReference == null ? (class$org$osgi$framework$ServiceReference = ServiceDependencyImpl.class$("org.osgi.framework.ServiceReference")) : class$org$osgi$framework$ServiceReference, this.m_trackedServiceName}, {class$org$osgi$framework$ServiceReference == null ? (class$org$osgi$framework$ServiceReference = ServiceDependencyImpl.class$("org.osgi.framework.ServiceReference")) : class$org$osgi$framework$ServiceReference, class$java$lang$Object == null ? (class$java$lang$Object = ServiceDependencyImpl.class$("java.lang.Object")) : class$java$lang$Object}, {class$org$osgi$framework$ServiceReference == null ? (class$org$osgi$framework$ServiceReference = ServiceDependencyImpl.class$("org.osgi.framework.ServiceReference")) : class$org$osgi$framework$ServiceReference}, {this.m_trackedServiceName}, {class$java$lang$Object == null ? (class$java$lang$Object = ServiceDependencyImpl.class$("java.lang.Object")) : class$java$lang$Object}, new Class[0], {class$java$util$Map == null ? (class$java$util$Map = ServiceDependencyImpl.class$("java.util.Map")) : class$java$util$Map, this.m_trackedServiceName}}, new Object[][]{{dependencyService, reference, service}, {dependencyService, reference, service}, {dependencyService, reference}, {dependencyService, service}, {dependencyService, service}, {dependencyService}, {dependencyService, new ServicePropertiesMap(reference), service}, {reference, service}, {reference, service}, {reference}, {service}, {service}, new Object[0], {new ServicePropertiesMap(reference), service}});
        }
    }

    protected synchronized boolean makeAvailable() {
        if (!this.isAvailable()) {
            this.m_isAvailable = true;
            return true;
        }
        return false;
    }

    private synchronized boolean makeUnavailable() {
        if (this.isAvailable() && this.m_tracker.getServiceReference() == null) {
            this.m_isAvailable = false;
            return true;
        }
        return false;
    }

    private synchronized Object[] getCallbackInstances(DependencyService dependencyService) {
        if (this.m_callbackInstance == null) {
            return dependencyService.getCompositionInstances();
        }
        return new Object[]{this.m_callbackInstance};
    }

    public synchronized ServiceDependency setService(Class serviceName) {
        this.setService(serviceName, null, null);
        return this;
    }

    public synchronized ServiceDependency setService(Class serviceName, String serviceFilter) {
        this.setService(serviceName, null, serviceFilter);
        return this;
    }

    public synchronized ServiceDependency setService(String serviceFilter) {
        if (serviceFilter == null) {
            throw new IllegalArgumentException("Service filter cannot be null.");
        }
        this.setService(null, null, serviceFilter);
        return this;
    }

    public synchronized ServiceDependency setService(Class serviceName, ServiceReference serviceReference) {
        this.setService(serviceName, serviceReference, null);
        return this;
    }

    private void setService(Class serviceName, ServiceReference serviceReference, String serviceFilter) {
        this.ensureNotActive();
        this.m_trackedServiceName = serviceName == null ? (class$java$lang$Object == null ? (class$java$lang$Object = ServiceDependencyImpl.class$("java.lang.Object")) : class$java$lang$Object) : serviceName;
        if (serviceFilter != null) {
            this.m_trackedServiceFilterUnmodified = serviceFilter;
            this.m_trackedServiceFilter = serviceName == null ? serviceFilter : "(&(objectClass=" + serviceName.getName() + ")" + serviceFilter + ")";
        } else {
            this.m_trackedServiceFilterUnmodified = null;
            this.m_trackedServiceFilter = null;
        }
        if (serviceReference != null) {
            this.m_trackedServiceReference = serviceReference;
            if (serviceFilter != null) {
                throw new IllegalArgumentException("Cannot specify both a filter and a service reference.");
            }
        } else {
            this.m_trackedServiceReference = null;
        }
    }

    public synchronized ServiceDependency setDefaultImplementation(Object implementation) {
        this.ensureNotActive();
        this.m_defaultImplementation = implementation;
        return this;
    }

    public synchronized ServiceDependency setRequired(boolean required) {
        this.ensureNotActive();
        this.setIsRequired(required);
        return this;
    }

    public ServiceDependency setInstanceBound(boolean isInstanceBound) {
        this.setIsInstanceBound(isInstanceBound);
        return this;
    }

    public synchronized ServiceDependency setAutoConfig(boolean autoConfig) {
        this.ensureNotActive();
        this.m_autoConfig = autoConfig;
        this.m_autoConfigInvoked = true;
        return this;
    }

    public synchronized ServiceDependency setAutoConfig(String instanceName) {
        this.ensureNotActive();
        this.m_autoConfig = instanceName != null;
        this.m_autoConfigInstance = instanceName;
        this.m_autoConfigInvoked = true;
        return this;
    }

    public synchronized ServiceDependency setCallbacks(String added, String removed) {
        return this.setCallbacks(null, added, null, removed);
    }

    public synchronized ServiceDependency setCallbacks(String added, String changed, String removed) {
        return this.setCallbacks(null, added, changed, removed);
    }

    public synchronized ServiceDependency setCallbacks(Object instance, String added, String removed) {
        return this.setCallbacks(instance, added, null, removed);
    }

    public synchronized ServiceDependency setCallbacks(Object instance, String added, String changed, String removed) {
        this.ensureNotActive();
        if (!(added == null && removed == null && changed == null || this.m_autoConfigInvoked)) {
            this.setAutoConfig(false);
        }
        this.m_callbackInstance = instance;
        this.m_callbackAdded = added;
        this.m_callbackChanged = changed;
        this.m_callbackRemoved = removed;
        return this;
    }

    private void ensureNotActive() {
        if (this.m_tracker != null) {
            throw new IllegalStateException("Cannot modify state while active.");
        }
    }

    public synchronized String toString() {
        return "ServiceDependency[" + this.m_trackedServiceName + " " + this.m_trackedServiceFilterUnmodified + "]";
    }

    public String getAutoConfigName() {
        return this.m_autoConfigInstance;
    }

    public Object getAutoConfigInstance() {
        return this.lookupService();
    }

    public Class getAutoConfigType() {
        return this.getInterface();
    }

    public String getName() {
        StringBuilder sb = new StringBuilder();
        if (this.m_trackedServiceName != null) {
            sb.append(this.m_trackedServiceName.getName());
            if (this.m_trackedServiceFilterUnmodified != null) {
                sb.append(' ');
                sb.append(this.m_trackedServiceFilterUnmodified);
            }
        }
        if (this.m_trackedServiceReference != null) {
            sb.append("{service.id=" + this.m_trackedServiceReference.getProperty("service.id") + "}");
        }
        return sb.toString();
    }

    public int getState() {
        return (this.isAvailable() ? 1 : 0) + (this.isRequired() ? 2 : 0);
    }

    public String getType() {
        return "service";
    }

    public void invokeAdded(DependencyService service) {
        ServiceReference[] refs = this.m_tracker.getServiceReferences();
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                ServiceReference sr = refs[i];
                Object svc = this.m_context.getService(sr);
                this.invokeAdded(service, sr, svc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeRemoved(DependencyService service) {
        Set references = null;
        Map map = this.m_sr;
        synchronized (map) {
            references = (Set)this.m_sr.get(service);
        }
        Tuple[] refs = references != null ? references.toArray(new Tuple[references.size()]) : new Tuple[]{};
        for (int i = 0; i < refs.length; ++i) {
            ServiceReference sr = refs[i].getServiceReference();
            Object svc = refs[i].getService();
            this.invokeRemoved(service, sr, svc);
        }
        if (references != null) {
            references.clear();
        }
    }

    public Dictionary getProperties() {
        ServiceReference reference = this.lookupServiceReference();
        Object service = this.lookupService();
        if (reference != null) {
            if (this.m_propagateCallbackInstance != null && this.m_propagateCallbackMethod != null) {
                try {
                    return (Dictionary)InvocationUtil.invokeCallbackMethod(this.m_propagateCallbackInstance, this.m_propagateCallbackMethod, new Class[][]{{class$org$osgi$framework$ServiceReference == null ? (class$org$osgi$framework$ServiceReference = ServiceDependencyImpl.class$("org.osgi.framework.ServiceReference")) : class$org$osgi$framework$ServiceReference, class$java$lang$Object == null ? (class$java$lang$Object = ServiceDependencyImpl.class$("java.lang.Object")) : class$java$lang$Object}, {class$org$osgi$framework$ServiceReference == null ? (class$org$osgi$framework$ServiceReference = ServiceDependencyImpl.class$("org.osgi.framework.ServiceReference")) : class$org$osgi$framework$ServiceReference}}, new Object[][]{{reference, service}, {reference}});
                }
                catch (InvocationTargetException e) {
                    this.m_logger.log(2, "Exception while invoking callback method", e.getCause());
                }
                catch (Exception e) {
                    this.m_logger.log(2, "Exception while trying to invoke callback method", e);
                }
                throw new IllegalStateException("Could not invoke callback");
            }
            Properties props = new Properties();
            String[] keys = reference.getPropertyKeys();
            for (int i = 0; i < keys.length; ++i) {
                if (keys[i].equals("service.id") || keys[i].equals("service.pid")) continue;
                props.put(keys[i], reference.getProperty(keys[i]));
            }
            return props;
        }
        throw new IllegalStateException("cannot find service reference");
    }

    public boolean isPropagated() {
        return this.m_propagate;
    }

    public ServiceDependency setPropagate(boolean propagate) {
        this.ensureNotActive();
        this.m_propagate = propagate;
        return this;
    }

    public ServiceDependency setPropagate(Object instance, String method) {
        this.setPropagate(instance != null && method != null);
        this.m_propagateCallbackInstance = instance;
        this.m_propagateCallbackMethod = method;
        return this;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class ServicePropertiesMap
    extends AbstractMap {
        private final ServiceReference m_ref;

        public ServicePropertiesMap(ServiceReference ref) {
            this.m_ref = ref;
        }

        public Object get(Object key) {
            return this.m_ref.getProperty(key.toString());
        }

        public int size() {
            return this.m_ref.getPropertyKeys().length;
        }

        public Set entrySet() {
            HashSet<ServicePropertiesMapEntry> set = new HashSet<ServicePropertiesMapEntry>();
            String[] keys = this.m_ref.getPropertyKeys();
            for (int i = 0; i < keys.length; ++i) {
                set.add(new ServicePropertiesMapEntry(keys[i], this.m_ref.getProperty(keys[i])));
            }
            return set;
        }
    }

    private static final class ServicePropertiesMapEntry
    implements Map.Entry {
        private final String m_key;
        private Object m_value;

        public ServicePropertiesMapEntry(String key, Object value) {
            this.m_key = key;
            this.m_value = value;
        }

        public Object getKey() {
            return this.m_key;
        }

        public Object getValue() {
            return this.m_value;
        }

        public String toString() {
            return this.m_key + "=" + this.m_value;
        }

        public Object setValue(Object value) {
            Object oldValue = this.m_value;
            this.m_value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return ServicePropertiesMapEntry.eq(this.m_key, e.getKey()) && ServicePropertiesMapEntry.eq(this.m_value, e.getValue());
        }

        public int hashCode() {
            return (this.m_key == null ? 0 : this.m_key.hashCode()) ^ (this.m_value == null ? 0 : this.m_value.hashCode());
        }

        private static final boolean eq(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }
    }

    private static final class Tuple {
        private final ServiceReference m_serviceReference;
        private final Object m_service;

        public Tuple(ServiceReference first, Object last) {
            this.m_serviceReference = first;
            this.m_service = last;
        }

        public ServiceReference getServiceReference() {
            return this.m_serviceReference;
        }

        public Object getService() {
            return this.m_service;
        }

        public boolean equals(Object obj) {
            return ((Tuple)obj).getServiceReference().equals(this.getServiceReference());
        }

        public int hashCode() {
            return this.m_serviceReference.hashCode();
        }
    }
}

