/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.data;

import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import org.eclipse.kura.KuraConnectException;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.KuraNotConnectedException;
import org.eclipse.kura.KuraStoreCapacityReachedException;
import org.eclipse.kura.KuraStoreException;
import org.eclipse.kura.KuraTooManyInflightMessagesException;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.connection.listener.ConnectionListener;
import org.eclipse.kura.core.data.AlwaysConnectedStrategy;
import org.eclipse.kura.core.data.AutoConnectStrategy;
import org.eclipse.kura.core.data.DataServiceListenerS;
import org.eclipse.kura.core.data.DataServiceOptions;
import org.eclipse.kura.core.data.ScheduleStrategy;
import org.eclipse.kura.core.data.store.MessageStoreState;
import org.eclipse.kura.core.db.H2DbMessageStoreImpl;
import org.eclipse.kura.core.internal.data.TokenBucket;
import org.eclipse.kura.data.DataService;
import org.eclipse.kura.data.DataTransportService;
import org.eclipse.kura.data.DataTransportToken;
import org.eclipse.kura.data.listener.DataServiceListener;
import org.eclipse.kura.data.transport.listener.DataTransportListener;
import org.eclipse.kura.db.H2DbService;
import org.eclipse.kura.message.store.StoredMessage;
import org.eclipse.kura.message.store.provider.MessageStore;
import org.eclipse.kura.message.store.provider.MessageStoreProvider;
import org.eclipse.kura.status.CloudConnectionStatusComponent;
import org.eclipse.kura.status.CloudConnectionStatusEnum;
import org.eclipse.kura.status.CloudConnectionStatusService;
import org.eclipse.kura.util.jdbc.ConnectionProvider;
import org.eclipse.kura.util.jdbc.SQLFunction;
import org.eclipse.kura.watchdog.CriticalComponent;
import org.eclipse.kura.watchdog.WatchdogService;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentException;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.quartz.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataServiceImpl
implements DataService,
DataTransportListener,
ConfigurableComponent,
CloudConnectionStatusComponent,
CriticalComponent,
AutoConnectStrategy.ConnectionManager,
ConnectionListener {
    private static final String MESSAGE_STORE_NOT_CONNECTED_MESSAGE = "Message store instance not connected, not connecting";
    public static final String MESSAGE_STORE_NOT_PRESENT_MESSAGE = "Message store instance not configured properly, not connecting";
    private static final int RECONNECTION_MIN_DELAY = 1;
    private static final Logger logger = LoggerFactory.getLogger(DataServiceImpl.class);
    private static final int TRANSPORT_TASK_TIMEOUT = 1;
    private DataServiceOptions dataServiceOptions;
    private DataTransportService dataTransportService;
    private DataServiceListenerS dataServiceListeners;
    protected ScheduledExecutorService connectionMonitorExecutor;
    private ScheduledFuture<?> connectionMonitorFuture;
    private ExecutorService publisherExecutor;
    private Optional<MessageStoreState> storeState = Optional.empty();
    private Map<DataTransportToken, Integer> inFlightMsgIds = new ConcurrentHashMap<DataTransportToken, Integer>();
    private ScheduledExecutorService congestionExecutor;
    private ScheduledFuture<?> congestionFuture;
    private CloudConnectionStatusService cloudConnectionStatusService;
    private CloudConnectionStatusEnum notificationStatus = CloudConnectionStatusEnum.OFF;
    private TokenBucket throttle;
    private final Lock lock = new ReentrantLock();
    private boolean notifyPending;
    private final Condition lockCondition = this.lock.newCondition();
    private final AtomicBoolean publisherEnabled = new AtomicBoolean();
    private ServiceTracker<Object, Object> dbServiceTracker;
    private ComponentContext componentContext;
    private WatchdogService watchdogService;
    private AtomicInteger connectionAttempts;
    private Optional<AutoConnectStrategy> autoConnectStrategy = Optional.empty();
    private final Random random = new SecureRandom();
    private AtomicBoolean disconnectionGuard = new AtomicBoolean();

    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        String pid = (String)properties.get("kura.service.pid");
        logger.info("Activating {}...", (Object)pid);
        this.componentContext = componentContext;
        this.dataServiceOptions = new DataServiceOptions(properties);
        this.connectionMonitorExecutor = Executors.newSingleThreadScheduledExecutor();
        this.publisherExecutor = Executors.newSingleThreadExecutor();
        this.congestionExecutor = Executors.newSingleThreadScheduledExecutor();
        this.createThrottle();
        this.submitPublishingWork();
        this.restartDbServiceTracker(this.dataServiceOptions.getDbServiceInstancePid());
        this.dataServiceListeners = new DataServiceListenerS(componentContext);
        this.cloudConnectionStatusService.register((CloudConnectionStatusComponent)this);
        this.dataTransportService.addDataTransportListener((DataTransportListener)this);
        this.createAutoConnectStrategy();
    }

    private void restartDbServiceTracker(String kuraServicePid) {
        this.stopDbServiceTracker();
        try {
            Filter filter = FrameworkUtil.createFilter((String)("(kura.service.pid=" + kuraServicePid + ")"));
            this.dbServiceTracker = new ServiceTracker(this.componentContext.getBundleContext(), filter, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<Object, Object>(){

                public Object addingService(ServiceReference<Object> reference) {
                    logger.info("Message store instance found");
                    Object service = DataServiceImpl.this.componentContext.getBundleContext().getService(reference);
                    if (service instanceof MessageStoreProvider) {
                        DataServiceImpl.this.setMessageStoreProvider((MessageStoreProvider)service);
                    } else if (service instanceof H2DbService) {
                        DataServiceImpl.this.setH2DbService((H2DbService)service);
                    } else {
                        DataServiceImpl.this.componentContext.getBundleContext().ungetService(reference);
                        return null;
                    }
                    return service;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void modifiedService(ServiceReference<Object> reference, Object service) {
                    if (service instanceof MessageStoreProvider) {
                        return;
                    }
                    logger.info("Message store instance updated, recreating table if needed...");
                    DataServiceImpl dataServiceImpl = DataServiceImpl.this;
                    synchronized (dataServiceImpl) {
                        if (DataServiceImpl.this.storeState.isPresent()) {
                            ((MessageStoreState)DataServiceImpl.this.storeState.get()).update(DataServiceImpl.this.dataServiceOptions);
                        }
                    }
                }

                public void removedService(ServiceReference<Object> reference, Object service) {
                    logger.info("Message store instance removed");
                    DataServiceImpl.this.unsetMessageStoreProvider();
                    DataServiceImpl.this.componentContext.getBundleContext().ungetService(reference);
                }
            });
            this.dbServiceTracker.open();
        }
        catch (InvalidSyntaxException e) {
            throw new ComponentException((Throwable)e);
        }
    }

    private void stopDbServiceTracker() {
        if (this.dbServiceTracker != null) {
            this.dbServiceTracker.close();
            this.dbServiceTracker = null;
        }
    }

    private synchronized void startDbStore() {
        try {
            List inFlightMsgs = Collections.emptyList();
            if (this.storeState.isPresent()) {
                inFlightMsgs = this.storeState.get().getOrOpenMessageStore().getInFlightMessages();
            }
            this.inFlightMsgIds = new ConcurrentHashMap<DataTransportToken, Integer>();
            if (inFlightMsgs != null) {
                for (StoredMessage message : inFlightMsgs) {
                    Optional token = message.getDataTransportToken();
                    if (!token.isPresent()) {
                        logger.warn("In-flight message has no associated DataTransportToken");
                        continue;
                    }
                    this.inFlightMsgIds.put((DataTransportToken)token.get(), message.getId());
                    logger.debug("Restored in-fligh messages from store. Topic: {}, ID: {}, MQTT message ID: {}", new Object[]{message.getTopic(), message.getId(), ((DataTransportToken)token.get()).getMessageId()});
                }
            }
        }
        catch (KuraStoreException e) {
            logger.error("Failed to start store", (Throwable)e);
            this.disconnectDataTransportAndLog(e);
        }
    }

    public synchronized void updated(Map<String, Object> properties) {
        logger.info("Updating {}...", properties.get("kura.service.pid"));
        this.shutdownAutoConnectStrategy();
        String oldDbServicePid = this.dataServiceOptions.getDbServiceInstancePid();
        this.dataServiceOptions = new DataServiceOptions(properties);
        this.createThrottle();
        String currentDbServicePid = this.dataServiceOptions.getDbServiceInstancePid();
        if (oldDbServicePid.equals(currentDbServicePid)) {
            if (this.storeState.isPresent()) {
                this.storeState.get().update(this.dataServiceOptions);
            }
        } else {
            this.restartDbServiceTracker(currentDbServicePid);
        }
        this.createAutoConnectStrategy();
    }

    protected void deactivate(ComponentContext componentContext) {
        logger.info("Deactivating {}...", (Object)this.dataServiceOptions.getKuraServicePid());
        this.shutdownAutoConnectStrategy();
        this.connectionMonitorExecutor.shutdownNow();
        this.congestionExecutor.shutdownNow();
        this.disconnect();
        try {
            Thread.sleep(1000L);
            this.publisherEnabled.set(false);
            this.signalPublisher();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.info("Interrupted", (Throwable)e);
        }
        this.publisherExecutor.shutdownNow();
        this.dataTransportService.removeDataTransportListener((DataTransportListener)this);
        if (this.storeState.isPresent()) {
            this.storeState.get().shutdown();
        }
        this.stopDbServiceTracker();
    }

    public void setDataTransportService(DataTransportService dataTransportService) {
        this.dataTransportService = dataTransportService;
    }

    public void unsetDataTransportService(DataTransportService dataTransportService) {
        this.dataTransportService = null;
    }

    public synchronized void setMessageStoreProvider(MessageStoreProvider messageStoreProvider) {
        this.storeState = Optional.of(new MessageStoreState(messageStoreProvider, this.dataServiceOptions));
        messageStoreProvider.addListener((ConnectionListener)this);
        this.startDbStore();
        this.signalPublisher();
    }

    public synchronized void unsetMessageStoreProvider() {
        this.disconnect();
        if (this.storeState.isPresent()) {
            this.storeState.get().getMessageStoreProvider().removeListener((ConnectionListener)this);
            this.storeState.get().shutdown();
            this.storeState = Optional.empty();
        }
    }

    public synchronized void setH2DbService(final H2DbService dbService) {
        this.setMessageStoreProvider(new MessageStoreProvider(){

            public MessageStore openMessageStore(String name) throws KuraStoreException {
                return new H2DbMessageStoreImpl(new ConnectionProvider(){

                    public <T> T withConnection(SQLFunction<Connection, T> task) throws SQLException {
                        return (T)dbService.withConnection(arg_0 -> task.call(arg_0));
                    }
                }, name);
            }

            public void addListener(ConnectionListener listener) {
            }

            public void removeListener(ConnectionListener listener) {
            }
        });
    }

    public synchronized void unsetH2DbService(H2DbService dbService) {
        this.unsetMessageStoreProvider();
    }

    public void setCloudConnectionStatusService(CloudConnectionStatusService cloudConnectionStatusService) {
        this.cloudConnectionStatusService = cloudConnectionStatusService;
    }

    public void unsetCloudConnectionStatusService(CloudConnectionStatusService cloudConnectionStatusService) {
        this.cloudConnectionStatusService = null;
    }

    public void setWatchdogService(WatchdogService watchdogService) {
        this.watchdogService = watchdogService;
    }

    public void unsetWatchdogService(WatchdogService watchdogService) {
        this.watchdogService = null;
    }

    public void addDataServiceListener(DataServiceListener listener) {
        this.dataServiceListeners.add(listener);
    }

    public void removeDataServiceListener(DataServiceListener listener) {
        this.dataServiceListeners.remove(listener);
    }

    public void onConnectionEstablished(boolean newSession) {
        logger.info("Notified connected");
        this.cloudConnectionStatusService.updateStatus((CloudConnectionStatusComponent)this, CloudConnectionStatusEnum.ON);
        if (newSession) {
            this.unpublishOrDropInFlightMessages(this.dataServiceOptions.isPublishInFlightMessages());
        }
        this.dataServiceListeners.onConnectionEstablished();
        this.signalPublisher();
    }

    private void unpublishOrDropInFlightMessages(boolean publishInFlightMessages) {
        if (publishInFlightMessages && this.storeState.isPresent()) {
            logger.info("New session established. Unpublishing all in-flight messages. Disregarding the QoS level, this may cause duplicate messages.");
            try {
                this.storeState.get().getOrOpenMessageStore().unpublishAllInFlighMessages();
                this.inFlightMsgIds.clear();
            }
            catch (KuraStoreException e) {
                logger.error("Failed to unpublish in-flight messages", (Throwable)e);
                this.disconnectDataTransportAndLog(e);
            }
        } else if (this.storeState.isPresent()) {
            logger.info("New session established. Dropping all in-flight messages.");
            try {
                this.storeState.get().getOrOpenMessageStore().dropAllInFlightMessages();
                this.inFlightMsgIds.clear();
            }
            catch (KuraStoreException e) {
                logger.error("Failed to drop in-flight messages", (Throwable)e);
                this.disconnectDataTransportAndLog(e);
            }
        }
    }

    public void onDisconnecting() {
        logger.info("Notified disconnecting");
        this.dataServiceListeners.onDisconnecting();
    }

    public void onDisconnected() {
        logger.info("Notified disconnected");
        this.cloudConnectionStatusService.updateStatus((CloudConnectionStatusComponent)this, CloudConnectionStatusEnum.OFF);
        this.dataServiceListeners.onDisconnected();
    }

    public void onConfigurationUpdating(boolean wasConnected) {
        logger.info("Notified DataTransportService configuration updating...");
        this.dataTransportService.disconnect(0L);
    }

    public void onConfigurationUpdated(boolean wasConnected) {
        logger.info("Notified DataTransportService configuration updated.");
        this.shutdownAutoConnectStrategy();
        this.createAutoConnectStrategy();
        if (!this.autoConnectStrategy.isPresent() && wasConnected) {
            try {
                this.connect();
            }
            catch (KuraConnectException e) {
                logger.error("Error during re-connect after configuration update.", (Throwable)e);
            }
        }
    }

    public void onConnectionLost(Throwable cause) {
        logger.info("connectionLost");
        this.dataServiceListeners.onConnectionLost(cause);
    }

    public void onMessageArrived(String topic, byte[] payload, int qos, boolean retained) {
        logger.debug("Message arrived on topic: {}", (Object)topic);
        this.dataServiceListeners.onMessageArrived(topic, payload, qos, retained);
        this.signalPublisher();
    }

    public synchronized void onMessageConfirmed(DataTransportToken token) {
        logger.debug("Confirmed message with MQTT message ID: {} on session ID: {}", (Object)token.getMessageId(), (Object)token.getSessionId());
        Integer messageId = this.inFlightMsgIds.remove(token);
        if (messageId == null) {
            logger.info("Confirmed message published with MQTT message ID: {} not tracked in the map of in-flight messages", (Object)token.getMessageId());
        } else {
            Optional confirmedMessage = Optional.empty();
            try {
                logger.info("Confirmed message ID: {} to store", (Object)messageId);
                if (this.storeState.isPresent()) {
                    this.storeState.get().getOrOpenMessageStore().markAsConfirmed(messageId.intValue());
                    confirmedMessage = this.storeState.get().getOrOpenMessageStore().get(messageId.intValue());
                }
            }
            catch (KuraStoreException e) {
                logger.error("Cannot confirm message to store", (Throwable)e);
                this.disconnectDataTransportAndLog(e);
            }
            if (confirmedMessage.isPresent()) {
                String topic = ((StoredMessage)confirmedMessage.get()).getTopic();
                this.dataServiceListeners.onMessageConfirmed(messageId, topic);
            } else {
                logger.error("Confirmed Message with ID {} could not be loaded from the DataStore.", (Object)messageId);
            }
        }
        if (this.inFlightMsgIds.size() < this.dataServiceOptions.getMaxInFlightMessages()) {
            this.handleInFlightDecongestion();
        }
        this.signalPublisher();
    }

    private void disconnectDataTransportAndLog(Throwable e) {
        if (e instanceof KuraStoreCapacityReachedException) {
            return;
        }
        if (this.disconnectionGuard.compareAndSet(false, true)) {
            logger.error("Disconnecting the DataTransportService, cause: {}", (Object)e.getMessage());
            this.disconnect();
            this.disconnectionGuard.set(false);
        }
    }

    public void connect() throws KuraConnectException {
        this.shutdownAutoConnectStrategy();
        if (!this.storeState.isPresent()) {
            throw new KuraConnectException((Object)MESSAGE_STORE_NOT_CONNECTED_MESSAGE);
        }
        try {
            this.storeState.get().getOrOpenMessageStore();
        }
        catch (KuraStoreException e) {
            throw new KuraConnectException((Throwable)e, (Object)MESSAGE_STORE_NOT_CONNECTED_MESSAGE);
        }
        if (!this.dataTransportService.isConnected()) {
            this.dataTransportService.connect();
        }
    }

    @Override
    public boolean isConnected() {
        return this.dataTransportService.isConnected();
    }

    public boolean isAutoConnectEnabled() {
        return this.dataServiceOptions.isAutoConnect();
    }

    public int getRetryInterval() {
        return this.dataServiceOptions.getConnectDelay();
    }

    public void disconnect(long quiesceTimeout) {
        this.shutdownAutoConnectStrategy();
        this.dataTransportService.disconnect(quiesceTimeout);
    }

    public void subscribe(String topic, int qos) throws KuraException {
        this.dataTransportService.subscribe(topic, qos);
    }

    public void unsubscribe(String topic) throws KuraException {
        this.dataTransportService.unsubscribe(topic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int publish(String topic, byte[] payload, int qos, boolean retain, int priority) throws KuraStoreException {
        if (priority < 0) {
            throw new IllegalArgumentException("Priority cannot be negative");
        }
        if (payload != null && (long)payload.length > this.dataServiceOptions.getMaximumPayloadSizeBytes()) {
            throw new KuraStoreException((Object)"Payload size exceeds configured limit");
        }
        if (this.autoConnectStrategy.isPresent()) {
            this.autoConnectStrategy.get().onPublishRequested(topic, payload, qos, retain, priority);
        }
        if (this.storeState.isPresent()) {
            try {
                int messageId;
                MessageStore currentStore;
                logger.info("Storing message on topic: {}, priority: {}", (Object)topic, (Object)priority);
                MessageStore messageStore = currentStore = this.storeState.get().getOrOpenMessageStore();
                synchronized (messageStore) {
                    if (priority != 0 && priority != 1) {
                        int count = currentStore.getMessageCount();
                        logger.debug("Store message count: {}", (Object)count);
                        if (count >= this.dataServiceOptions.getStoreCapacity()) {
                            logger.error("Store capacity exceeded");
                            throw new KuraStoreCapacityReachedException((Object)"Store capacity exceeded");
                        }
                    }
                    messageId = currentStore.store(topic, payload, qos, retain, priority);
                    logger.info("Stored message on topic: {}, priority: {}", (Object)topic, (Object)priority);
                }
                this.signalPublisher();
                return messageId;
            }
            catch (KuraStoreException e) {
                this.disconnectDataTransportAndLog(e);
                throw e;
            }
        }
        KuraStoreException e = new KuraStoreException((Object)MESSAGE_STORE_NOT_PRESENT_MESSAGE);
        this.disconnectDataTransportAndLog(e);
        throw e;
    }

    public List<Integer> getUnpublishedMessageIds(String topicRegex) throws KuraStoreException {
        if (this.storeState.isPresent()) {
            List messages = this.storeState.get().getOrOpenMessageStore().getUnpublishedMessages();
            return this.buildMessageIds(messages, topicRegex);
        }
        KuraStoreException e = new KuraStoreException((Object)MESSAGE_STORE_NOT_CONNECTED_MESSAGE);
        this.disconnectDataTransportAndLog(e);
        throw e;
    }

    public List<Integer> getInFlightMessageIds(String topicRegex) throws KuraStoreException {
        if (this.storeState.isPresent()) {
            List messages = this.storeState.get().getOrOpenMessageStore().getInFlightMessages();
            return this.buildMessageIds(messages, topicRegex);
        }
        KuraStoreException e = new KuraStoreException((Object)MESSAGE_STORE_NOT_CONNECTED_MESSAGE);
        this.disconnectDataTransportAndLog(e);
        throw e;
    }

    public List<Integer> getDroppedInFlightMessageIds(String topicRegex) throws KuraStoreException {
        if (this.storeState.isPresent()) {
            List messages = this.storeState.get().getOrOpenMessageStore().getDroppedMessages();
            return this.buildMessageIds(messages, topicRegex);
        }
        KuraStoreException e = new KuraStoreException((Object)MESSAGE_STORE_NOT_CONNECTED_MESSAGE);
        this.disconnectDataTransportAndLog(e);
        throw e;
    }

    private void signalPublisher() {
        this.lock.lock();
        this.notifyPending = true;
        this.lockCondition.signal();
        this.lock.unlock();
    }

    private void createAutoConnectStrategy() {
        if (!this.dataServiceOptions.isAutoConnect()) {
            return;
        }
        Optional<AutoConnectStrategy> currentStrategy = this.autoConnectStrategy;
        if (currentStrategy.isPresent()) {
            return;
        }
        Optional<CronExpression> schedule = this.dataServiceOptions.getConnectionScheduleExpression();
        AutoConnectStrategy strategy = !this.dataServiceOptions.isConnectionScheduleEnabled() || !schedule.isPresent() ? new AlwaysConnectedStrategy(this) : new ScheduleStrategy(schedule.get(), this.dataServiceOptions, this);
        this.autoConnectStrategy = Optional.of(strategy);
        this.dataServiceListeners.prepend(strategy);
    }

    private void shutdownAutoConnectStrategy() {
        Optional<AutoConnectStrategy> currentStrategy = this.autoConnectStrategy;
        if (currentStrategy.isPresent()) {
            currentStrategy.get().shutdown();
            this.dataServiceListeners.remove(currentStrategy.get());
            this.autoConnectStrategy = Optional.empty();
        }
    }

    private void startConnectionMonitorTask() {
        if (this.connectionMonitorFuture != null && !this.connectionMonitorFuture.isDone()) {
            logger.info("Reconnect task already running");
        }
        boolean autoConnect = this.dataServiceOptions.isAutoConnect();
        int reconnectInterval = this.dataServiceOptions.getConnectDelay();
        if (autoConnect) {
            if (this.dataServiceOptions.isConnectionRecoveryEnabled()) {
                this.watchdogService.registerCriticalComponent((CriticalComponent)this);
                this.watchdogService.checkin((CriticalComponent)this);
                this.connectionAttempts = new AtomicInteger(0);
            }
            this.cloudConnectionStatusService.updateStatus((CloudConnectionStatusComponent)this, CloudConnectionStatusEnum.SLOW_BLINKING);
            int maxDelay = reconnectInterval / 5;
            maxDelay = maxDelay > 0 ? maxDelay : 1;
            int initialDelay = Math.max(this.random.nextInt(maxDelay), 1);
            logger.info("Starting reconnect task with initial delay {}", (Object)initialDelay);
            this.connectionMonitorFuture = this.connectionMonitorExecutor.scheduleAtFixedRate(new ReconnectTask(), initialDelay, reconnectInterval, TimeUnit.SECONDS);
        } else {
            this.cloudConnectionStatusService.updateStatus((CloudConnectionStatusComponent)this, CloudConnectionStatusEnum.OFF);
            this.unregisterAsCriticalComponent();
        }
    }

    private void createThrottle() {
        if (this.dataServiceOptions.isRateLimitEnabled()) {
            int publishRate = this.dataServiceOptions.getRateLimitAverageRate();
            int burstLength = this.dataServiceOptions.getRateLimitBurstSize();
            long publishPeriod = this.dataServiceOptions.getRateLimitTimeUnit() / (long)publishRate;
            logger.info("Get Throttle with burst length {} and send a message every {} nanoseconds", (Object)burstLength, (Object)publishPeriod);
            this.throttle = new TokenBucket(burstLength, publishPeriod);
        }
    }

    private void stopConnectionMonitorTask() {
        if (this.connectionMonitorFuture != null && !this.connectionMonitorFuture.isDone()) {
            logger.info("Reconnect task running. Stopping it");
            this.connectionMonitorFuture.cancel(true);
        }
        this.unregisterAsCriticalComponent();
    }

    private void unregisterAsCriticalComponent() {
        this.watchdogService.unregisterCriticalComponent((CriticalComponent)this);
    }

    @Override
    public void disconnect() {
        long millis = (long)this.dataServiceOptions.getDisconnectDelay() * 1000L;
        this.dataTransportService.disconnect(millis);
    }

    private void submitPublishingWork() {
        this.publisherEnabled.set(true);
        this.publisherExecutor.execute(new PublishManager());
    }

    private List<Integer> buildMessageIds(List<StoredMessage> messages, String topicRegex) {
        Pattern topicPattern = Pattern.compile(topicRegex);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        if (messages != null) {
            for (StoredMessage message : messages) {
                String topic = message.getTopic();
                if (!topicPattern.matcher(topic).matches()) continue;
                ids.add(message.getId());
            }
        }
        return ids;
    }

    private void handleInFlightDecongestion() {
        if (this.congestionFuture != null && !this.congestionFuture.isDone()) {
            this.congestionFuture.cancel(true);
        }
    }

    public int getNotificationPriority() {
        return 100;
    }

    public CloudConnectionStatusEnum getNotificationStatus() {
        return this.notificationStatus;
    }

    public void setNotificationStatus(CloudConnectionStatusEnum status) {
        this.notificationStatus = status;
    }

    public String getCriticalComponentName() {
        return "DataServiceImpl";
    }

    public int getCriticalComponentTimeout() {
        return this.dataServiceOptions.getCriticalComponentTimeout();
    }

    public Map<String, String> getConnectionInfo() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("Broker URL", this.dataTransportService.getBrokerUrl());
        result.put("Account", this.dataTransportService.getAccountName());
        result.put("Username", this.dataTransportService.getUsername());
        result.put("Client ID", this.dataTransportService.getClientId());
        return result;
    }

    @Override
    public void startConnectionTask() {
        this.startConnectionMonitorTask();
    }

    @Override
    public void stopConnectionTask() {
        this.stopConnectionMonitorTask();
    }

    @Override
    public boolean hasInFlightMessages() {
        return !this.inFlightMsgIds.isEmpty();
    }

    @Override
    public Optional<StoredMessage> getNextMessage() {
        Optional message = Optional.empty();
        try {
            if (!this.storeState.isPresent()) {
                throw new KuraStoreException((Object)MESSAGE_STORE_NOT_CONNECTED_MESSAGE);
            }
            message = this.storeState.get().getOrOpenMessageStore().getNextMessage();
        }
        catch (Exception e) {
            this.disconnectDataTransportAndLog(e);
            logger.error("Probably an unrecoverable exception", (Throwable)e);
        }
        return message;
    }

    public void connected() {
        logger.info("Message store with PID {} connected.", (Object)this.dataServiceOptions.getDbServiceInstancePid());
        if (this.connectionMonitorFuture != null && !this.connectionMonitorFuture.isDone()) {
            this.stopConnectionTask();
            this.startConnectionTask();
        }
    }

    public void disconnected() {
        logger.info("Message store with PID {} disconnected.", (Object)this.dataServiceOptions.getDbServiceInstancePid());
        if (this.storeState.isPresent()) {
            this.storeState.get().shutdown();
        }
        if (this.dataTransportService.isConnected()) {
            this.disconnect();
            logger.info("Message store disconnected. Trying to shutdown the DataTransportService.");
        }
    }

    private final class PublishManager
    implements Runnable {
        private PublishManager() {
        }

        @Override
        public void run() {
            Thread.currentThread().setName("DataServiceImpl:Submit");
            while (DataServiceImpl.this.publisherEnabled.get()) {
                boolean messagePublished;
                long sleepingTime;
                block8: {
                    sleepingTime = -1L;
                    messagePublished = false;
                    if (DataServiceImpl.this.dataTransportService.isConnected()) {
                        try {
                            Optional message;
                            if (!DataServiceImpl.this.storeState.isPresent() || !(message = ((MessageStoreState)DataServiceImpl.this.storeState.get()).getOrOpenMessageStore().getNextMessage()).isPresent()) break block8;
                            this.checkInFlightMessages((StoredMessage)message.get());
                            if (DataServiceImpl.this.dataServiceOptions.isRateLimitEnabled() && ((StoredMessage)message.get()).getPriority() >= 5) {
                                messagePublished = this.publishMessageTokenBucket((StoredMessage)message.get());
                                sleepingTime = DataServiceImpl.this.throttle.getTokenWaitTime();
                                break block8;
                            }
                            this.publishMessageUnbound((StoredMessage)message.get());
                            messagePublished = true;
                        }
                        catch (KuraNotConnectedException kuraNotConnectedException) {
                            logger.info("DataPublisherService is not connected");
                        }
                        catch (KuraTooManyInflightMessagesException kuraTooManyInflightMessagesException) {
                            logger.info("Too many in-flight messages");
                            this.handleInFlightCongestion();
                        }
                        catch (Exception e) {
                            logger.error("Probably an unrecoverable exception", (Throwable)e);
                        }
                    } else {
                        logger.info("DataPublisherService not connected");
                    }
                }
                if (messagePublished) continue;
                this.suspendPublisher(sleepingTime, TimeUnit.NANOSECONDS);
            }
            logger.debug("Exited publisher loop.");
        }

        private void checkInFlightMessages(StoredMessage message) throws KuraTooManyInflightMessagesException {
            if (message.getQos() > 0 && DataServiceImpl.this.inFlightMsgIds.size() >= DataServiceImpl.this.dataServiceOptions.getMaxInFlightMessages()) {
                logger.warn("The configured maximum number of in-flight messages has been reached");
                throw new KuraTooManyInflightMessagesException((Object)"Too many in-flight messages");
            }
        }

        private void suspendPublisher(long timeout, TimeUnit timeUnit) {
            if (!DataServiceImpl.this.publisherEnabled.get()) {
                return;
            }
            try {
                try {
                    DataServiceImpl.this.lock.lock();
                    if (!DataServiceImpl.this.notifyPending) {
                        if (timeout == -1L) {
                            logger.debug("Suspending publishing thread indefinitely");
                            DataServiceImpl.this.lockCondition.await();
                        } else {
                            logger.debug("Suspending publishing thread for {} nanoseconds", (Object)timeout);
                            DataServiceImpl.this.lockCondition.await(timeout, timeUnit);
                        }
                    }
                    DataServiceImpl.this.notifyPending = false;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    DataServiceImpl.this.lock.unlock();
                }
            }
            finally {
                DataServiceImpl.this.lock.unlock();
            }
        }

        private void publishMessageUnbound(StoredMessage message) throws KuraException {
            this.publishInternal(message);
            DataServiceImpl.this.dataServiceListeners.onMessagePublished(message.getId(), message.getTopic());
        }

        private boolean publishMessageTokenBucket(StoredMessage message) throws KuraException {
            boolean tokenAvailable = DataServiceImpl.this.throttle.getToken();
            if (tokenAvailable) {
                this.publishMessageUnbound(message);
                return true;
            }
            return false;
        }

        private void handleInFlightCongestion() {
            int timeout = DataServiceImpl.this.dataServiceOptions.getInFlightMessagesCongestionTimeout();
            if (timeout != 0 && (DataServiceImpl.this.congestionFuture == null || DataServiceImpl.this.congestionFuture.isDone())) {
                logger.warn("In-flight message congestion timeout started");
                DataServiceImpl.this.congestionFuture = DataServiceImpl.this.congestionExecutor.schedule(() -> {
                    Thread.currentThread().setName("DataServiceImpl:InFlightCongestion");
                    logger.warn("In-flight message congestion timeout elapsed. Disconnecting and reconnecting again");
                    DataServiceImpl.this.disconnect();
                    DataServiceImpl.this.startConnectionMonitorTask();
                }, (long)timeout, TimeUnit.SECONDS);
            }
        }

        private synchronized void publishInternal(StoredMessage message) throws KuraException {
            block6: {
                String topic = message.getTopic();
                byte[] payload = message.getPayload();
                int qos = message.getQos();
                boolean retain = message.isRetain();
                int msgId = message.getId();
                logger.debug("Publishing message with ID: {} on topic: {}, priority: {}", new Object[]{msgId, topic, message.getPriority()});
                DataTransportToken token = DataServiceImpl.this.dataTransportService.publish(topic, payload, qos, retain);
                if (DataServiceImpl.this.storeState.isPresent()) {
                    try {
                        if (token == null) {
                            ((MessageStoreState)DataServiceImpl.this.storeState.get()).getOrOpenMessageStore().markAsPublished(msgId);
                            logger.debug("Published message with ID: {}", (Object)msgId);
                            break block6;
                        }
                        Integer trackedMsgId = (Integer)DataServiceImpl.this.inFlightMsgIds.get(token);
                        if (trackedMsgId != null) {
                            logger.error("Token already tracked: {} - {}", (Object)token.getSessionId(), (Object)token.getMessageId());
                        }
                        DataServiceImpl.this.inFlightMsgIds.put(token, msgId);
                        ((MessageStoreState)DataServiceImpl.this.storeState.get()).getOrOpenMessageStore().markAsPublished(msgId, token);
                        logger.debug("Published message with ID: {} and MQTT message ID: {}", (Object)msgId, (Object)token.getMessageId());
                    }
                    catch (KuraStoreException e) {
                        DataServiceImpl.this.disconnectDataTransportAndLog(e);
                    }
                } else {
                    throw new KuraStoreException((Object)DataServiceImpl.MESSAGE_STORE_NOT_CONNECTED_MESSAGE);
                }
            }
        }
    }

    private final class ReconnectTask
    implements Runnable {
        private ReconnectTask() {
        }

        @Override
        public void run() {
            Thread.currentThread().setName("DataServiceImpl:ReconnectTask:" + DataServiceImpl.this.dataServiceOptions.getKuraServicePid());
            boolean connected = false;
            try {
                try {
                    if (!DataServiceImpl.this.storeState.isPresent()) {
                        logger.warn(DataServiceImpl.MESSAGE_STORE_NOT_CONNECTED_MESSAGE);
                        throw new KuraStoreException((Object)DataServiceImpl.MESSAGE_STORE_NOT_CONNECTED_MESSAGE);
                    }
                    ((MessageStoreState)DataServiceImpl.this.storeState.get()).getOrOpenMessageStore();
                    logger.info("Connecting...");
                    if (DataServiceImpl.this.dataTransportService.isConnected()) {
                        logger.info("Already connected. Reconnect task will be terminated.");
                    } else {
                        DataServiceImpl.this.dataTransportService.connect();
                        logger.info("Connected. Reconnect task will be terminated.");
                    }
                    connected = true;
                }
                catch (KuraConnectException | KuraStoreException e) {
                    logger.warn("Connection attempt failed with exception {}", (Object)e.getClass().getSimpleName(), (Object)e);
                    if (DataServiceImpl.this.dataServiceOptions.isConnectionRecoveryEnabled()) {
                        if (this.isAuthenticationException((KuraException)e) || e instanceof KuraStoreException || DataServiceImpl.this.connectionAttempts.getAndIncrement() < DataServiceImpl.this.dataServiceOptions.getRecoveryMaximumAllowedFailures()) {
                            logger.info("Checkin done.");
                            DataServiceImpl.this.watchdogService.checkin((CriticalComponent)DataServiceImpl.this);
                        } else {
                            logger.info("Maximum number of connection attempts reached. Requested reboot...");
                        }
                    }
                    if (connected) {
                        DataServiceImpl.this.unregisterAsCriticalComponent();
                        throw new RuntimeException("Connected. Reconnect task will be terminated.");
                    }
                }
            }
            finally {
                if (connected) {
                    DataServiceImpl.this.unregisterAsCriticalComponent();
                    throw new RuntimeException("Connected. Reconnect task will be terminated.");
                }
            }
        }

        private boolean isAuthenticationException(KuraException e) {
            MqttException mqttException;
            boolean authenticationException = false;
            if (e.getCause() instanceof MqttException && ((mqttException = (MqttException)e.getCause()).getReasonCode() == 4 || mqttException.getReasonCode() == 2 || mqttException.getReasonCode() == 5)) {
                logger.info("Authentication exception encountered.");
                authenticationException = true;
            }
            return authenticationException;
        }
    }
}

