/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.usb;

import org.eclipse.kura.usb.AbstractUsbDevice;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class UsbTtyDevice
extends AbstractUsbDevice {
    private final String deviceNode;
    private final Integer interfaceNumber;

    public UsbTtyDevice(String vendorId, String productId, String manufacturerName, String productName, String usbBusNumber, String usbDevicePath, String deviceNode) {
        super(vendorId, productId, manufacturerName, productName, usbBusNumber, usbDevicePath);
        this.deviceNode = deviceNode;
        this.interfaceNumber = null;
    }

    public UsbTtyDevice(String vendorId, String productId, String manufacturerName, String productName, String usbBusNumber, String usbDevicePath, String deviceNode, Integer interfaceNumber) {
        super(vendorId, productId, manufacturerName, productName, usbBusNumber, usbDevicePath);
        this.deviceNode = deviceNode;
        this.interfaceNumber = interfaceNumber;
    }

    public String getDeviceNode() {
        return this.deviceNode;
    }

    public Integer getInterfaceNumber() {
        return this.interfaceNumber;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.deviceNode == null ? 0 : this.deviceNode.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UsbTtyDevice other = (UsbTtyDevice)obj;
        return !(this.deviceNode == null ? other.deviceNode != null : !this.deviceNode.equals(other.deviceNode));
    }

    public String toString() {
        String number = this.getInterfaceNumber() != null ? this.getInterfaceNumber().toString() : "null";
        return "UsbTtyDevice [getDeviceNode()=" + this.getDeviceNode() + ", getVendorId()=" + this.getVendorId() + ", getProductId()=" + this.getProductId() + ", getManufacturerName()=" + this.getManufacturerName() + ", getProductName()=" + this.getProductName() + ", getUsbBusNumber()=" + this.getUsbBusNumber() + ", getUsbDevicePath()=" + this.getUsbDevicePath() + ", getUsbPort()=" + this.getUsbPort() + ", getInterfaceNumber()=" + number + "]";
    }
}

