/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.system;

import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.eclipse.kura.KuraProcessExecutionErrorException;
import org.eclipse.kura.system.ExtendedProperties;
import org.eclipse.kura.system.SystemResourceInfo;
import org.osgi.annotation.versioning.ProviderType;
import org.osgi.framework.Bundle;

@ProviderType
public interface SystemService {
    public static final String KURA_CONFIG = "kura.configuration";
    public static final String KURA_PROPS_FILE = "kura.properties";
    public static final String KURA_CUSTOM_CONFIG = "kura.custom.configuration";
    public static final String KURA_CUSTOM_PROPS_FILE = "kura_custom.properties";
    public static final String OS_CLOUDBEES = "Linux (Cloudbees)";
    public static final String OS_LINUX = "Linux";
    public static final String OS_MAC_OSX = "Mac OS X";
    public static final String UNKNOWN = "UNKNOWN";
    public static final String UNSUPPORTED = "UNSUPPORTED";
    public static final String KEY_KURA_NAME = "kura.name";
    public static final String KEY_KURA_VERSION = "kura.version";
    public static final String KEY_KURA_NET_VIRTUAL_DEVICES_CONFIG = "kura.net.virtual.devices.config";
    public static final String KEY_KURA_FRAMEWORK_CONFIG_DIR = "kura.framework.config";
    public static final String KEY_KURA_USER_CONFIG_DIR = "kura.user.config";
    public static final String KEY_KURA_MARKETPLACE_COMPATIBILITY_VERSION = "kura.marketplace.compatibility.version";
    public static final String KEY_DEVICE_NAME = "kura.device.name";
    public static final String KEY_PLATFORM = "kura.platform";
    public static final String KEY_MODEL_ID = "kura.model.id";
    public static final String KEY_MODEL_NAME = "kura.model.name";
    public static final String KEY_PART_NUMBER = "kura.partNumber";
    public static final String KEY_SERIAL_NUM = "kura.serialNumber";
    public static final String KEY_BIOS_VERSION = "kura.bios.version";
    public static final String KEY_FIRMWARE_VERSION = "kura.firmware.version";
    public static final String KEY_PRIMARY_NET_IFACE = "kura.primary.network.interface";
    public static final String KEY_KURA_HOME_DIR = "kura.home";
    public static final String KEY_KURA_PLUGINS_DIR = "kura.plugins";
    public static final String KEY_KURA_PACKAGES_DIR = "kura.packages";
    public static final String KEY_KURA_DATA_DIR = "kura.data";
    public static final String KEY_KURA_TMP_DIR = "kura.tmp";
    public static final String KEY_KURA_SNAPSHOTS_DIR = "kura.snapshots";
    public static final String KEY_KURA_SNAPSHOTS_COUNT = "kura.snapshots.count";
    public static final String KEY_KURA_HAVE_NET_ADMIN = "kura.have.net.admin";
    public static final String KEY_KURA_HAVE_WEB_INTER = "kura.have.web.inter";
    public static final String KEY_KURA_STYLE_DIR = "kura.style.dir";
    public static final String KEY_KURA_WIFI_TOP_CHANNEL = "kura.wifi.top.channel";
    public static final String KEY_KURA_KEY_STORE_PWD = "kura.ssl.keyStorePassword";
    public static final String KEY_KURA_TRUST_STORE_PWD = "kura.ssl.trustStorePassword";
    public static final String KEY_FILE_COMMAND_ZIP_MAX_SIZE = "file.command.zip.max.size";
    public static final String KEY_FILE_COMMAND_ZIP_MAX_NUMBER = "file.command.zip.max.number";
    public static final String KEY_OS_ARCH = "os.arch";
    public static final String KEY_OS_NAME = "os.name";
    public static final String KEY_OS_VER = "os.version";
    public static final String KEY_OS_DISTRO = "os.distribution";
    public static final String KEY_OS_DISTRO_VER = "os.distribution.version";
    public static final String KEY_JAVA_VERSION = "java.runtime.version";
    public static final String KEY_JAVA_VENDOR = "java.runtime.name";
    public static final String KEY_JAVA_VM_NAME = "java.vm.name";
    public static final String KEY_JAVA_VM_VERSION = "java.vm.version";
    public static final String KEY_JAVA_VM_INFO = "java.vm.info";
    public static final String KEY_OSGI_FW_NAME = "org.osgi.framework.vendor";
    public static final String KEY_OSGI_FW_VERSION = "org.osgi.framework.version";
    public static final String KEY_JAVA_HOME = "java.home";
    public static final String KEY_FILE_SEP = "file.separator";
    public static final String CONFIG_CONSOLE_DEVICE_MANAGE_SERVICE_IGNORE = "console.device.management.service.ignore";
    public static final String KEY_COMMAND_USER = "kura.command.user";
    public static final String KEY_CPU_VERSION = "cpu.version";
    public static final String KEY_LEGACY_BT_BEACON_SCAN = "kura.legacy.bluetooth.beacon.scan";
    public static final String KEY_LEGACY_PPP_LOGGING = "kura.legacy.ppp.logging.enabled";
    public static final String KEY_JAVA_VM_VENDOR = "java.vm.vendor";
    public static final String KEY_JDK_VENDOR_VERSION = "jdk.vendor.version";
    @Deprecated
    public static final String DB_URL_PROPNAME = "db.service.hsqldb.url";
    @Deprecated
    public static final String DB_WRITE_DELAY_MILLIES_PROPNAME = "db.service.hsqldb.write_delay_millis";
    @Deprecated
    public static final String DB_LOG_DATA_PROPNAME = "db.service.hsqldb.log_data";
    @Deprecated
    public static final String DB_CACHE_ROWS_PROPNAME = "db.service.hsqldb.cache_rows";
    @Deprecated
    public static final String DB_LOB_FILE_PROPNAME = "db.service.hsqldb.lob_file_scale";
    @Deprecated
    public static final String DB_DEFRAG_LIMIT_PROPNAME = "db.service.hsqldb.defrag_limit";
    @Deprecated
    public static final String DB_LOG_SIZE_PROPNAME = "db.service.hsqldb.log_size";
    @Deprecated
    public static final String DB_NIO_PROPNAME = "db.service.hsqldb.nio_data_file";

    public String getPrimaryMacAddress();

    public String getPrimaryNetworkInterfaceName();

    public String getPlatform();

    public String getModelId();

    public String getModelName();

    public String getPartNumber();

    public String getSerialNumber();

    public String getDeviceName();

    public String getBiosVersion();

    public String getFirmwareVersion();

    public String getOsArch();

    public String getOsName();

    public String getOsVersion();

    public String getOsDistro();

    public String getOsDistroVersion();

    public String getJavaVendor();

    public String getJavaVersion();

    public String getJavaVmName();

    public String getJavaVmVersion();

    public String getJavaVmInfo();

    public String getOsgiFwName();

    public String getOsgiFwVersion();

    public String getFileSeparator();

    public String getJavaHome();

    public String getKuraVersion();

    public String getKuraFrameworkConfigDirectory();

    public String getKuraUserConfigDirectory();

    public String getKuraMarketplaceCompatibilityVersion();

    public String getKuraHome();

    public String getKuraTemporaryConfigDirectory();

    public String getKuraSnapshotsDirectory();

    public int getKuraSnapshotsCount();

    public String getKuraStyleDirectory();

    public int getKuraWifiTopChannel();

    public String getKuraWebEnabled();

    public String getKuraDataDirectory();

    public int getFileCommandZipMaxUploadSize();

    public int getFileCommandZipMaxUploadNumber();

    public Properties getProperties();

    public Bundle[] getBundles();

    public List<SystemResourceInfo> getSystemPackages() throws KuraProcessExecutionErrorException;

    public int getNumberOfProcessors();

    public long getTotalMemory();

    public long getFreeMemory();

    public char[] getJavaKeyStorePassword();

    public char[] getJavaTrustStorePassword();

    public List<String> getDeviceManagementServiceIgnore();

    public String getHostname();

    public String getNetVirtualDevicesConfig();

    public String getCommandUser();

    public String getCpuVersion();

    public Optional<ExtendedProperties> getExtendedProperties();

    public boolean isLegacyBluetoothBeaconScan();

    public boolean isLegacyPPPLoggingEnabled();

    public String getJavaVmVendor();

    public String getJdkVendorVersion();
}

