/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.container.orchestration;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.kura.container.orchestration.RegistryCredentials;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class ImageConfiguration {
    private String imageName;
    private String imageTag;
    private Optional<RegistryCredentials> registryCredentials;
    private int imageDownloadTimeoutSeconds = 500;

    private ImageConfiguration() {
    }

    public String getImageName() {
        return this.imageName;
    }

    public String getImageTag() {
        return this.imageTag;
    }

    public int getimageDownloadTimeoutSeconds() {
        return this.imageDownloadTimeoutSeconds;
    }

    public Optional<RegistryCredentials> getRegistryCredentials() {
        return this.registryCredentials;
    }

    public static ImageConfigurationBuilder builder() {
        return new ImageConfigurationBuilder();
    }

    public int hashCode() {
        return Objects.hash(this.imageName, this.imageTag, this.registryCredentials);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ImageConfiguration)) {
            return false;
        }
        ImageConfiguration other = (ImageConfiguration)obj;
        return Objects.equals(this.imageName, other.imageName) && Objects.equals(this.imageTag, other.imageTag) && Objects.equals(this.registryCredentials, other.registryCredentials);
    }

    /* synthetic */ ImageConfiguration(ImageConfiguration imageConfiguration) {
        this();
    }

    public static final class ImageConfigurationBuilder {
        private String imageName;
        private String imageTag = "latest";
        private Optional<RegistryCredentials> registryCredentials;
        private int imageDownloadTimeoutSeconds = 500;

        public ImageConfigurationBuilder setImageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public ImageConfigurationBuilder setImageTag(String imageTag) {
            this.imageTag = imageTag;
            return this;
        }

        public ImageConfigurationBuilder setRegistryCredentials(Optional<RegistryCredentials> registryCredentials) {
            this.registryCredentials = registryCredentials;
            return this;
        }

        public ImageConfigurationBuilder setImageDownloadTimeoutSeconds(int imageDownloadTimeoutSeconds) {
            this.imageDownloadTimeoutSeconds = imageDownloadTimeoutSeconds;
            return this;
        }

        public ImageConfiguration build() {
            ImageConfiguration result = new ImageConfiguration(null);
            result.imageName = Objects.requireNonNull(this.imageName, "Request Image Name cannot be null");
            result.imageTag = this.imageTag;
            result.registryCredentials = Objects.requireNonNull(this.registryCredentials, "Request Registry Credentials object cannot be null.");
            result.imageDownloadTimeoutSeconds = this.imageDownloadTimeoutSeconds;
            return result;
        }
    }
}

