/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.configuration.metatype;

public enum Scalar {
    STRING("String"),
    LONG("Long"),
    DOUBLE("Double"),
    FLOAT("Float"),
    INTEGER("Integer"),
    BYTE("Byte"),
    CHAR("Char"),
    BOOLEAN("Boolean"),
    SHORT("Short"),
    PASSWORD("Password");

    private final String value;

    private Scalar(String v) {
        this.value = v;
    }

    public String value() {
        return this.value;
    }

    public static Scalar fromValue(String v) {
        if ("character".equalsIgnoreCase(v)) {
            return CHAR;
        }
        Scalar[] scalarArray = Scalar.values();
        int n = scalarArray.length;
        int n2 = 0;
        while (n2 < n) {
            Scalar c = scalarArray[n2];
            if (c.value.equals(v)) {
                return c;
            }
            ++n2;
        }
        throw new IllegalArgumentException(v);
    }
}

