/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker.config;

import io.moquette.broker.config.ConfigurationParser;
import io.moquette.broker.config.IConfig;
import io.moquette.broker.config.IResourceLoader;
import java.io.Reader;
import java.text.ParseException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceLoaderConfig
extends IConfig {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceLoaderConfig.class);
    private final Properties m_properties;
    private final IResourceLoader resourceLoader;

    public ResourceLoaderConfig(IResourceLoader resourceLoader) {
        this(resourceLoader, null);
    }

    public ResourceLoaderConfig(IResourceLoader resourceLoader, String configName) {
        LOG.info("Loading configuration. ResourceLoader = {}, configName = {}.", (Object)resourceLoader.getName(), (Object)configName);
        this.resourceLoader = resourceLoader;
        Reader configReader = configName != null ? resourceLoader.loadResource(configName) : resourceLoader.loadDefaultResource();
        if (configReader == null) {
            LOG.error("The resource loader returned no configuration reader. ResourceLoader = {}, configName = {}.", (Object)resourceLoader.getName(), (Object)configName);
            throw new IllegalArgumentException("Can't locate " + resourceLoader.getName() + " \"" + configName + "\"");
        }
        LOG.info("Parsing configuration properties. ResourceLoader = {}, configName = {}.", (Object)resourceLoader.getName(), (Object)configName);
        ConfigurationParser confParser = new ConfigurationParser();
        this.m_properties = confParser.getProperties();
        this.assignDefaults();
        try {
            confParser.parse(configReader);
        }
        catch (ParseException pex) {
            LOG.warn("Unable to parse configuration properties. Using default configuration. ResourceLoader = {}, configName = {}, cause = {}, errorMessage = {}.", resourceLoader.getName(), configName, pex.getCause(), pex.getMessage());
        }
    }

    @Override
    public void setProperty(String name, String value) {
        this.m_properties.setProperty(name, value);
    }

    @Override
    public String getProperty(String name) {
        return this.m_properties.getProperty(name);
    }

    @Override
    public String getProperty(String name, String defaultValue) {
        return this.m_properties.getProperty(name, defaultValue);
    }

    @Override
    public IResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }
}

