/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server;

import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.audit.AuditContext;
import org.eclipse.kura.web.Console;
import org.eclipse.kura.web.UserManager;
import org.eclipse.kura.web.server.OsgiRemoteServiceServlet;
import org.eclipse.kura.web.session.Attributes;
import org.eclipse.kura.web.shared.GwtKuraErrorCode;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.model.GwtConsoleUserOptions;
import org.eclipse.kura.web.shared.model.GwtUserConfig;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtSessionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GwtSessionServiceImpl
extends OsgiRemoteServiceServlet
implements GwtSessionService {
    private static final Logger logger = LoggerFactory.getLogger(GwtSessionServiceImpl.class);
    private final UserManager userManager;
    private static final long serialVersionUID = 1L;

    public GwtSessionServiceImpl(UserManager userManager) {
        this.userManager = userManager;
    }

    @Override
    public void logout(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        HttpServletRequest request = this.getThreadLocalRequest();
        HttpServletResponse response = this.getThreadLocalResponse();
        HttpSession session = request.getSession(false);
        if (session != null) {
            Cookie[] cookies;
            Object username = session.getAttribute(Attributes.AUTORIZED_USER.getValue());
            String id = session.getId();
            session.invalidate();
            logger.info("UI Logout - Success - Logout succeeded for user: {}, session {}", username, (Object)id);
            Cookie[] cookieArray = cookies = request.getCookies();
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                cookie.setMaxAge(0);
                cookie.setValue(null);
                cookie.setPath("/");
                response.addCookie(cookie);
                ++n2;
            }
        }
    }

    @Override
    public GwtConsoleUserOptions getUserOptions(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        return Console.getConsoleOptions().getUserOptions();
    }

    @Override
    public GwtUserConfig getUserConfig(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        HttpServletRequest request = this.getThreadLocalRequest();
        HttpSession session = request.getSession(false);
        if (session == null) {
            throw new GwtKuraException(GwtKuraErrorCode.UNAUTHENTICATED);
        }
        Object username = session.getAttribute(Attributes.AUTORIZED_USER.getValue());
        if (!(username instanceof String)) {
            throw new GwtKuraException(GwtKuraErrorCode.UNAUTHENTICATED);
        }
        return this.userManager.getUserConfig((String)username).orElse(null);
    }

    @Override
    public void updatePassword(GwtXSRFToken xsrfToken, String oldPassword, String newPassword) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        HttpServletRequest request = this.getThreadLocalRequest();
        HttpSession session = request.getSession(false);
        String username = this.getSessionUsername(session);
        Optional<GwtUserConfig> userConfig = this.userManager.getUserConfig(username);
        if (!userConfig.isPresent() || !userConfig.get().isPasswordAuthEnabled()) {
            throw new GwtKuraException(GwtKuraErrorCode.OPERATION_NOT_SUPPORTED);
        }
        try {
            this.userManager.authenticateWithPassword(username, oldPassword);
        }
        catch (KuraException kuraException) {
            logger.warn("Wrong password");
            throw new GwtKuraException(GwtKuraErrorCode.INVALID_USERNAME_PASSWORD);
        }
        try {
            if (!this.userManager.setUserPassword(username, newPassword)) {
                throw new GwtKuraException(GwtKuraErrorCode.PASSWORD_CHANGE_SAME_PASSWORD);
            }
        }
        catch (KuraException e) {
            logger.warn("Failed to update user password", (Throwable)e);
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR);
        }
        this.setAuthenticated(session, username);
    }

    private String getSessionUsername(HttpSession session) throws GwtKuraException {
        if (session == null) {
            throw new GwtKuraException(GwtKuraErrorCode.UNAUTHENTICATED);
        }
        Object username = session.getAttribute(Attributes.AUTORIZED_USER.getValue());
        if (!(username instanceof String)) {
            throw new GwtKuraException(GwtKuraErrorCode.UNAUTHENTICATED);
        }
        return (String)username;
    }

    private void setAuthenticated(HttpSession session, String username) throws GwtKuraException {
        Console.instance().setAuthenticated(session, username, (AuditContext)AuditContext.current().orElseThrow(() -> new GwtKuraException("Audit context is not available")));
        session.removeAttribute(Attributes.LOCKED.getValue());
    }
}

