/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.localization;

import com.github.rodionmoiseev.c10n.C10N;
import com.github.rodionmoiseev.c10n.C10NConfigBase;
import com.github.rodionmoiseev.c10n.annotations.DefaultC10NAnnotations;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public final class LocalizationAdapter {
    private static final Locale CURRENT_LOCALE;

    static {
        C10N.configure((C10NConfigBase)new DefaultC10NAnnotations());
        CURRENT_LOCALE = Locale.getDefault();
    }

    private LocalizationAdapter() {
    }

    public static <T> T adapt(Class<T> clazz) {
        return LocalizationAdapter.adapt(clazz, CURRENT_LOCALE);
    }

    public static <T> T adapt(Class<T> clazz, Locale locale) {
        Objects.requireNonNull(clazz, "Class instance of localization resource cannot be null");
        Objects.requireNonNull(clazz, "Locale instance cannot be null");
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new C10NWrapper<Object>(C10N.get(clazz, (Locale)locale)));
    }

    private static class C10NWrapper<T>
    implements InvocationHandler {
        private final T wrapped;
        private final Map<Method, String> cache = new HashMap<Method, String>();

        public C10NWrapper(T wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (args != null && args.length > 0) {
                return method.invoke(this.wrapped, args);
            }
            String cached = this.cache.get(method);
            if (cached != null) {
                return cached;
            }
            cached = (String)method.invoke(this.wrapped, args);
            this.cache.put(method, cached);
            return cached;
        }
    }
}

