/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin.spi;

import java.io.IOException;
import java.io.InputStream;
import org.apache.felix.deploymentadmin.AbstractDeploymentPackage;
import org.apache.felix.deploymentadmin.BundleInfoImpl;
import org.apache.felix.deploymentadmin.spi.Command;
import org.apache.felix.deploymentadmin.spi.DeploymentSessionImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.service.deploymentadmin.DeploymentException;
import org.osgi.service.log.LogService;

public class DropBundleCommand
extends Command {
    public void execute(DeploymentSessionImpl session) throws DeploymentException {
        AbstractDeploymentPackage target = session.getTargetAbstractDeploymentPackage();
        AbstractDeploymentPackage source = session.getSourceAbstractDeploymentPackage();
        LogService log = session.getLog();
        BundleInfoImpl[] orderedTargetBundles = target.getOrderedBundleInfos();
        for (int i = orderedTargetBundles.length - 1; i >= 0; --i) {
            BundleInfoImpl bundleInfo = orderedTargetBundles[i];
            if (bundleInfo.isCustomizer() || source.getBundleInfoByName(bundleInfo.getSymbolicName()) != null) continue;
            String symbolicName = bundleInfo.getSymbolicName();
            try {
                Bundle bundle = target.getBundle(symbolicName);
                bundle.uninstall();
                this.addRollback(new InstallBundleRunnable(bundle, target, log));
                continue;
            }
            catch (BundleException be) {
                log.log(2, "Bundle '" + symbolicName + "' could not be uninstalled", (Throwable)be);
            }
        }
    }

    private static class InstallBundleRunnable
    implements Runnable {
        private final AbstractDeploymentPackage m_target;
        private final Bundle m_bundle;
        private final LogService m_log;

        public InstallBundleRunnable(Bundle bundle, AbstractDeploymentPackage target, LogService log) {
            this.m_bundle = bundle;
            this.m_target = target;
            this.m_log = log;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            InputStream is = null;
            try {
                try {
                    is = this.m_target.getBundleStream(this.m_bundle.getSymbolicName());
                    if (is != null) {
                        this.m_bundle.update(is);
                    }
                    throw new Exception("Unable to get Inputstream for bundle " + this.m_bundle.getSymbolicName());
                }
                catch (Exception e) {
                    this.m_log.log(2, "Could not rollback uninstallation of bundle '" + this.m_bundle.getSymbolicName() + "'", (Throwable)e);
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }
}

