/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.asset;

import java.util.List;
import org.eclipse.kura.asset.provider.BaseAssetOCD;
import org.eclipse.kura.core.configuration.metatype.Tad;
import org.eclipse.kura.core.configuration.metatype.Toption;
import org.eclipse.kura.core.configuration.metatype.Tscalar;
import org.eclipse.kura.internal.wire.asset.TimestampMode;

public class WireAssetOCD
extends BaseAssetOCD {
    private static final String FALSE = "false";
    private static final String EMIT_ALL_CHANNELS_DESCRIPTION = "Specifies wheter the values of all READ or READ_WRITE channels should be emitted in case of a channel event. If set to true, the values for all channels will be read and emitted, if set to false, only the value for the channel related to the event will be emitted.";
    private static final String TIMESTAMP_MODE_DESCRIPTION = "If set to PER_CHANNEL, the component will emit a driver-generated timestamp per channel property. If set to SINGLE_ASSET_GENERATED, the component will emit a single timestamp per request, generated by the Asset itself before emitting the envelope. If set to SINGLE_DRIVER_GENERATED_MAX or SINGLE_DRIVER_GENERATED_MIN, the component will emit a single driver generated timestamp being respectively the max (most recent) or min (oldest) among the timestamps of the channels.";
    private static final String EMIT_ERRORS_DESCRIPTION = "Specifies wheter errors should be included or not in the emitted envelope";
    private static final String EMIT_ON_CHANGE_DESCRIPTION = "If set to true, this component will include a channel value in the output emitted in Kura Wires only if it is different than the one from the previous read operation or event. Channel errors will always be emitted if emit.errors is set to true.";
    private static final String EMIT_EMPTY_ENVELOPES_DESCRIPTION = "If set to false, this component will not emit empty envelopes. This property can be useful if combined with emit.on.change.";

    private static void addOptions(Tad target, Enum<?>[] values) {
        List options = target.getOption();
        Enum<?>[] enumArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Enum<?> value = enumArray[n2];
            String name = value.name();
            Toption option = new Toption();
            option.setLabel(name);
            option.setValue(name);
            options.add(option);
            ++n2;
        }
    }

    public WireAssetOCD() {
        Tad emitAllChannelsAd = new Tad();
        emitAllChannelsAd.setId("emit.all.channels");
        emitAllChannelsAd.setName("emit.all.channels");
        emitAllChannelsAd.setCardinality(Integer.valueOf(0));
        emitAllChannelsAd.setType(Tscalar.BOOLEAN);
        emitAllChannelsAd.setDescription(EMIT_ALL_CHANNELS_DESCRIPTION);
        emitAllChannelsAd.setRequired(Boolean.valueOf(true));
        emitAllChannelsAd.setDefault(FALSE);
        this.addAD(emitAllChannelsAd);
        Tad timestampModeAd = new Tad();
        timestampModeAd.setId("timestamp.mode");
        timestampModeAd.setName("timestamp.mode");
        timestampModeAd.setCardinality(Integer.valueOf(0));
        timestampModeAd.setType(Tscalar.STRING);
        timestampModeAd.setDescription(TIMESTAMP_MODE_DESCRIPTION);
        timestampModeAd.setRequired(Boolean.valueOf(true));
        timestampModeAd.setDefault(TimestampMode.PER_CHANNEL.name());
        WireAssetOCD.addOptions(timestampModeAd, TimestampMode.values());
        this.addAD(timestampModeAd);
        Tad emitErrorsAd = new Tad();
        emitErrorsAd.setId("emit.errors");
        emitErrorsAd.setName("emit.errors");
        emitErrorsAd.setCardinality(Integer.valueOf(0));
        emitErrorsAd.setType(Tscalar.BOOLEAN);
        emitErrorsAd.setDescription(EMIT_ERRORS_DESCRIPTION);
        emitErrorsAd.setRequired(Boolean.valueOf(true));
        emitErrorsAd.setDefault(FALSE);
        this.addAD(emitErrorsAd);
        Tad emitOnChangeAd = new Tad();
        emitOnChangeAd.setId("emit.on.change");
        emitOnChangeAd.setName("emit.on.change");
        emitOnChangeAd.setCardinality(Integer.valueOf(0));
        emitOnChangeAd.setType(Tscalar.BOOLEAN);
        emitOnChangeAd.setDescription(EMIT_ON_CHANGE_DESCRIPTION);
        emitOnChangeAd.setRequired(Boolean.valueOf(true));
        emitOnChangeAd.setDefault(FALSE);
        this.addAD(emitOnChangeAd);
        Tad emitEmptyEnvelopesAd = new Tad();
        emitEmptyEnvelopesAd.setId("emit.empty.envelopes");
        emitEmptyEnvelopesAd.setName("emit.empty.envelopes");
        emitEmptyEnvelopesAd.setCardinality(Integer.valueOf(0));
        emitEmptyEnvelopesAd.setType(Tscalar.BOOLEAN);
        emitEmptyEnvelopesAd.setDescription(EMIT_EMPTY_ENVELOPES_DESCRIPTION);
        emitEmptyEnvelopesAd.setRequired(Boolean.valueOf(true));
        emitEmptyEnvelopesAd.setDefault("true");
        this.addAD(emitEmptyEnvelopesAd);
    }
}

