/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.util.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

public final class CollectionUtil {
    private CollectionUtil() {
    }

    public static <K, V> Map<K, V> dictionaryToMap(Dictionary<K, V> dictionary) {
        Objects.requireNonNull(dictionary, "Dictionary cannot be null.");
        HashMap<K, V> map = new HashMap<K, V>(dictionary.size());
        Enumeration<K> keys = dictionary.keys();
        while (keys.hasMoreElements()) {
            K key = keys.nextElement();
            map.put(key, dictionary.get(key));
        }
        return map;
    }

    public static <E> List<E> newArrayList() {
        return new ArrayList();
    }

    public static <E> List<E> newArrayListWithCapacity(int initialArraySize) {
        if (initialArraySize < 0) {
            throw new IllegalArgumentException("Initial Array size must not be less than 0.");
        }
        return new ArrayList(initialArraySize);
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentHashMap(Map<K, V> map) {
        Objects.requireNonNull(map, "Map cannot be null.");
        return new ConcurrentHashMap<K, V>(map);
    }

    public static <E> List<E> newCopyOnWriteArrayList() {
        return new CopyOnWriteArrayList();
    }

    public static <K, V> Map<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> Map<K, V> newHashMap(Map<? extends K, ? extends V> map) {
        Objects.requireNonNull(map, "Map cannot be null.");
        return new HashMap<K, V>(map);
    }

    public static <E> Set<E> newHashSet() {
        return new HashSet();
    }

    public static <E> Set<E> newHashSet(Collection<? extends E> collection) {
        Objects.requireNonNull(collection, "Collection cannot be null.");
        return new HashSet<E>(collection);
    }

    public static <K, V> Map<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static <E> List<E> newLinkedList() {
        return new LinkedList();
    }

    public static <K extends Comparable<K>, V> Map<K, V> newTreeMap() {
        return new TreeMap();
    }
}

